/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.modifier;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.visitor.Visitor;

public class ArrayModifier
extends LeftHandSideModifier {
    protected ArrayAccess node;
    protected Object array;
    protected Number cell;
    protected List arrays = new LinkedList();
    protected List cells = new LinkedList();

    public ArrayModifier(ArrayAccess node) {
        this.node = node;
    }

    public Object prepare(Visitor v, Context ctx) {
        this.arrays.add(0, this.array);
        this.cells.add(0, this.cell);
        this.array = this.node.getExpression().acceptVisitor(v);
        Object o = this.node.getCellNumber().acceptVisitor(v);
        if (o instanceof Character) {
            o = new Integer(((Character)o).charValue());
        }
        this.cell = (Number)o;
        return Array.get(this.array, this.cell.intValue());
    }

    public void modify(Context ctx, Object value) {
        try {
            Array.set(this.array, this.cell.intValue(), value);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("array element type mismatch")) {
                throw new ArrayStoreException();
            }
            throw e;
        }
        finally {
            this.array = this.arrays.remove(0);
            this.cell = (Number)this.cells.remove(0);
        }
    }
}

