/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.NoSuchFunctionException;
import koala.dynamicjava.interpreter.context.VariableContext;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.modifier.FinalVariableModifier;
import koala.dynamicjava.interpreter.modifier.InvalidModifier;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.interpreter.modifier.ObjectFieldModifier;
import koala.dynamicjava.interpreter.modifier.StaticFieldModifier;
import koala.dynamicjava.interpreter.modifier.VariableModifier;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PrimaryExpression;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.BufferedImportationManager;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;
import koala.dynamicjava.util.ReflectionUtilities;

public class GlobalContext
extends VariableContext
implements Context {
    protected static final ReferenceType CLASS_TYPE = new ReferenceType("java.lang.Class");
    protected static final ReferenceType MAP_TYPE = new ReferenceType("java.util.Map");
    protected static final ReferenceType OBJECT_TYPE = new ReferenceType("java.lang.Object");
    protected static final ArrayType OBJECT_ARRAY_ARRAY = new ArrayType(OBJECT_TYPE, 2);
    protected static final TypeExpression OBJECT_CLASS = new TypeExpression(OBJECT_TYPE);
    protected static final String LOCALS_NAME = "local$Variables$Reference$0";
    protected static final FieldDeclaration LOCALS = new FieldDeclaration(1, MAP_TYPE, "local$Variables$Reference$0", null);
    protected static int classCount = 0;
    protected ImportationManager importationManager;
    protected Interpreter interpreter;
    protected ClassLoader classLoader;
    protected ClassLoaderContainer clc;
    protected List functions = new LinkedList();
    protected boolean accessible = false;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public GlobalContext(Interpreter i) {
        this.importationManager = new BufferedImportationManager(i.getClassLoader());
        this.interpreter = i;
    }

    public GlobalContext(Interpreter i, ClassLoader cl) {
        this.importationManager = new BufferedImportationManager(cl);
        this.interpreter = i;
        this.classLoader = cl;
    }

    public GlobalContext(Interpreter i, Set entries) {
        super(entries);
        this.interpreter = i;
    }

    public void setAdditionalClassLoaderContainer(ClassLoaderContainer clc) {
        this.clc = clc;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public boolean getAccessible() {
        return this.accessible;
    }

    protected ClassLoader getAdditionalClassLoader() {
        if (this.clc != null) {
            return this.clc.getClassLoader();
        }
        return null;
    }

    public void setFunctions(List l) {
        this.functions = l;
    }

    public List getFunctions() {
        return this.functions;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public ImportationManager getImportationManager() {
        return this.importationManager;
    }

    public void setImportationManager(ImportationManager im) {
        this.importationManager = im;
    }

    public boolean exists(String name) {
        return this.isDefined(name) || this.classExists(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean classExists(String name) {
        boolean result = false;
        this.importationManager.setClassLoader(new PseudoClassLoader());
        try {
            this.lookupClass(name);
            result = true;
        }
        catch (ClassNotFoundException e) {
        }
        catch (PseudoError e) {
            result = true;
        }
        finally {
            if (this.classLoader == null) {
                this.importationManager.setClassLoader(this.interpreter.getClassLoader());
            } else {
                this.importationManager.setClassLoader(this.classLoader);
            }
        }
        return result;
    }

    public void defineFunction(MethodDeclaration node) {
        this.functions.add(0, node);
    }

    public void defineClass(TypeDeclaration node) {
        new TreeCompiler(this.interpreter).compileTree(this, node);
    }

    public boolean isDefined(String name) {
        return this.isDefinedVariable(name);
    }

    public void setCurrentPackage(String pkg) {
        this.importationManager.setCurrentPackage(pkg);
    }

    public String getCurrentPackage() {
        return this.importationManager.getCurrentPackage();
    }

    public void declarePackageImport(String pkg) {
        this.importationManager.declarePackageImport(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareClassImport(String cname) throws ClassNotFoundException {
        this.importationManager.setClassLoader(new PseudoClassLoader());
        try {
            this.importationManager.declareClassImport(cname);
        }
        catch (PseudoError e) {
        }
        finally {
            if (this.classLoader == null) {
                this.importationManager.setClassLoader(this.interpreter.getClassLoader());
            } else {
                this.importationManager.setClassLoader(this.classLoader);
            }
        }
    }

    public Node getDefaultQualifier(Node node) {
        return this.getDefaultQualifier(node, "");
    }

    public Node getDefaultQualifier(Node node, String tname) {
        return null;
    }

    public LeftHandSideModifier getModifier(QualifiedName node) {
        if (this.isFinal(node.getRepresentation())) {
            return new FinalVariableModifier(node, NodeProperties.getType(node));
        }
        return new VariableModifier(node, NodeProperties.getType(node));
    }

    public LeftHandSideModifier getModifier(ObjectFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        if (f.isAccessible()) {
            return new ObjectFieldModifier(f, node);
        }
        return new InvalidModifier(node);
    }

    public LeftHandSideModifier getModifier(StaticFieldAccess node) {
        Field f = (Field)node.getProperty("field");
        if (f.isAccessible()) {
            return new StaticFieldModifier(f, node);
        }
        return new InvalidModifier(node);
    }

    public LeftHandSideModifier getModifier(SuperFieldAccess node) {
        throw new IllegalStateException("internal.error");
    }

    public Object getHiddenArgument() {
        return null;
    }

    public Expression createName(Node node, IdentifierToken name) {
        if (!this.isDefined(name.image())) {
            throw new IllegalStateException();
        }
        LinkedList<IdentifierToken> l = new LinkedList<IdentifierToken>();
        l.add(name);
        return new QualifiedName(l);
    }

    public Class lookupClass(String cname) throws ClassNotFoundException {
        return this.importationManager.lookupClass(cname, null);
    }

    public Class lookupClass(String cname, String ccname) throws ClassNotFoundException {
        return this.importationManager.lookupClass(cname, ccname);
    }

    public Class setProperties(SimpleAllocation node, Class c, Class[] cargs) {
        Constructor cons = null;
        try {
            cons = this.lookupConstructor(c, cargs);
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
        node.setProperty("type", c);
        node.setProperty("constructor", cons);
        return c;
    }

    public Class setProperties(ClassAllocation node, Class c, Class[] args, List memb) {
        String cname = "TopLevel$" + classCount++;
        FieldDeclaration fd = new FieldDeclaration(9, CLASS_TYPE, "declaring$Class$Reference$0", OBJECT_CLASS);
        memb.add(fd);
        memb.add(LOCALS);
        fd = new FieldDeclaration(9, OBJECT_ARRAY_ARRAY, "local$Variables$Class$0", this.createClassArrayInitializer());
        memb.add(fd);
        LinkedList<FormalParameter> params = new LinkedList<FormalParameter>();
        LinkedList<SimpleAssignExpression> stmts = new LinkedList<SimpleAssignExpression>();
        params.add(new FormalParameter(false, MAP_TYPE, "param$0"));
        LinkedList<QualifiedName> superArgs = new LinkedList<QualifiedName>();
        int i = 0;
        while (i < args.length) {
            params.add(new FormalParameter(false, TreeUtilities.classToType(args[i]), "param$" + (i + 1)));
            LinkedList<Identifier> l = new LinkedList<Identifier>();
            l.add(new Identifier("param$" + (i + 1)));
            superArgs.add(new QualifiedName(l));
            ++i;
        }
        ConstructorInvocation ci = null;
        if (superArgs.size() > 0) {
            ci = new ConstructorInvocation(null, superArgs, true);
        }
        LinkedList<Identifier> p1 = new LinkedList<Identifier>();
        p1.add(new Identifier(LOCALS_NAME));
        LinkedList<Identifier> p2 = new LinkedList<Identifier>();
        p2.add(new Identifier("param$0"));
        stmts.add(new SimpleAssignExpression(new QualifiedName(p1), new QualifiedName(p2)));
        ConstructorDeclaration csd = new ConstructorDeclaration(1, cname, params, new LinkedList(), ci, stmts);
        memb.add(csd);
        LinkedList<Identifier> ext = null;
        LinkedList impl = null;
        if (c.isInterface()) {
            impl = new LinkedList();
            LinkedList<Identifier> intf = new LinkedList<Identifier>();
            intf.add(new Identifier(c.getName()));
            impl.add(intf);
        } else {
            ext = new LinkedList<Identifier>();
            ext.add(new Identifier(c.getName()));
        }
        ClassDeclaration type = new ClassDeclaration(1, cname, ext, impl, memb);
        type.setProperty("anonymousDeclaringClass", new JavaClassInfo(class$java$lang$Object == null ? (class$java$lang$Object = GlobalContext.class$("java.lang.Object")) : class$java$lang$Object));
        Class cl = new TreeCompiler(this.interpreter).compileTree(this, type);
        Class[] tmp = new Class[args.length + 1];
        tmp[0] = class$java$util$Map == null ? (class$java$util$Map = GlobalContext.class$("java.util.Map")) : class$java$util$Map;
        int i2 = 1;
        while (i2 < tmp.length) {
            tmp[i2] = args[i2 - 1];
            ++i2;
        }
        args = tmp;
        try {
            node.setProperty("constructor", this.lookupConstructor(cl, args));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        node.setProperty("type", cl);
        return cl;
    }

    protected ArrayInitializer createClassArrayInitializer() {
        LinkedList<ArrayInitializer> cells = new LinkedList<ArrayInitializer>();
        Type tp = new ReferenceType((class$java$lang$Object == null ? (class$java$lang$Object = GlobalContext.class$("java.lang.Object")) : class$java$lang$Object).getName());
        Map m = this.getConstants();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            LinkedList<PrimaryExpression> pair = new LinkedList<PrimaryExpression>();
            pair.add(new StringLiteral('\"' + s + '\"'));
            Class c = (Class)m.get(s);
            pair.add(new TypeExpression(TreeUtilities.classToType(c)));
            ArrayInitializer cell = new ArrayInitializer(pair);
            cell.setElementType(tp);
            cells.add(cell);
        }
        tp = new ArrayType(tp, 1);
        ArrayInitializer ai = new ArrayInitializer(cells);
        ai.setElementType(tp);
        return ai;
    }

    public Constructor lookupConstructor(Class c, Class[] params) throws NoSuchMethodException {
        Constructor cons = ReflectionUtilities.lookupConstructor(c, params);
        this.setAccessFlag(cons);
        return cons;
    }

    public Object invokeConstructor(SimpleAllocation node, Object[] args) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Object invokeConstructor(ClassAllocation node, Object[] args) {
        Constructor cons = (Constructor)node.getProperty("constructor");
        Object[] t = new Object[args.length + 1];
        t[0] = this.getConstants();
        int i = 1;
        while (i < t.length) {
            t[i] = args[i - 1];
            ++i;
        }
        args = t;
        try {
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new ThrownException(e.getTargetException());
        }
        catch (Exception e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    public Method lookupMethod(Node prefix, String mname, Class[] params) throws NoSuchMethodException {
        Class c = NodeProperties.getType(prefix);
        Method m = ReflectionUtilities.lookupMethod(c, mname, params);
        this.setAccessFlag(m);
        if (m.getName().equals("clone")) {
            m.setAccessible(true);
        }
        return m;
    }

    public MethodDeclaration lookupFunction(String mname, Class[] params) throws NoSuchFunctionException {
        MethodDeclaration md;
        Iterator it = this.functions.iterator();
        LinkedList<MethodDeclaration> f = new LinkedList<MethodDeclaration>();
        while (it.hasNext()) {
            md = (MethodDeclaration)it.next();
            if (!md.getName().equals(mname)) continue;
            f.add(md);
        }
        it = f.iterator();
        while (it.hasNext()) {
            md = (MethodDeclaration)it.next();
            List l = md.getParameters();
            if (l.size() != params.length) continue;
            Class[] p = new Class[l.size()];
            Iterator it2 = l.iterator();
            int i = 0;
            while (it2.hasNext()) {
                p[i++] = NodeProperties.getType((Node)it2.next());
            }
            if (!ReflectionUtilities.hasCompatibleSignatures(p, params)) continue;
            return md;
        }
        throw new NoSuchFunctionException(mname);
    }

    public Method lookupSuperMethod(Node node, String mname, Class[] params) throws NoSuchMethodException {
        throw new ExecutionError("super.method", node);
    }

    public Field getField(Class fc, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        Field f = ReflectionUtilities.getField(fc, fn);
        this.setAccessFlag(f);
        return f;
    }

    public Field getSuperField(Node node, String fn) throws NoSuchFieldException, AmbiguousFieldException {
        throw new ExecutionError("super.field", node);
    }

    protected void setAccessFlag(Member m) {
        int mods = m.getModifiers();
        Class<?> c = m.getDeclaringClass();
        int cmods = c.getModifiers();
        String pkg = this.importationManager.getCurrentPackage();
        String mp = this.getPackageName(c);
        boolean samePkg = pkg.equals(mp);
        if (this.getAccessible()) {
            ((AccessibleObject)((Object)m)).setAccessible(true);
        }
        if (Modifier.isPublic(cmods) || samePkg) {
            if (Modifier.isPublic(mods)) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            } else if (Modifier.isProtected(mods)) {
                if (samePkg) {
                    ((AccessibleObject)((Object)m)).setAccessible(true);
                }
            } else if (!Modifier.isPrivate(mods) && samePkg) {
                ((AccessibleObject)((Object)m)).setAccessible(true);
            }
        }
    }

    protected String getPackageName(Class c) {
        String s = c.getName();
        int i = s.lastIndexOf(46);
        return i == -1 ? "" : s.substring(0, i);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompilationUnitVisitor
    extends VisitorObject {
        private String className;
        private String currentPackage;
        private ImportationManager importationManager;
        private TreeClassLoader classLoader;

        public CompilationUnitVisitor(String cname) {
            this.className = cname;
            this.importationManager = new BufferedImportationManager(new PseudoClassLoader());
            this.classLoader = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
        }

        public CompilationUnitVisitor(String cname, ImportationManager im) {
            this.className = cname;
            this.importationManager = im;
            this.importationManager.setClassLoader(new PseudoClassLoader());
            this.classLoader = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
        }

        public Object visit(PackageDeclaration node) {
            this.importationManager.setCurrentPackage(node.getName());
            return null;
        }

        public Object visit(ImportDeclaration node) {
            if (node.isPackage()) {
                this.importationManager.declarePackageImport(node.getName());
            } else {
                try {
                    this.importationManager.declareClassImport(node.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new CatchedExceptionError(e, (Node)node);
                }
                catch (PseudoError e) {
                }
            }
            return null;
        }

        public Object visit(ClassDeclaration node) {
            return this.visitType(node);
        }

        public Object visit(InterfaceDeclaration node) {
            return this.visitType(node);
        }

        private Object visitType(TypeDeclaration node) {
            String cname = this.importationManager.getCurrentPackage();
            cname = (cname.equals("") ? "" : cname + ".") + node.getName();
            this.classLoader.addTree(cname, node);
            node.setProperty("importationManager", this.importationManager);
            if (this.className.equals(cname)) {
                return Boolean.TRUE;
            }
            MembersVisitor v = new MembersVisitor(cname);
            Iterator it = node.getMembers().iterator();
            while (it.hasNext()) {
                Boolean b = (Boolean)((Node)it.next()).acceptVisitor(v);
                if (!Boolean.TRUE.equals(b)) continue;
                return b;
            }
            return Boolean.FALSE;
        }

        private class MembersVisitor
        extends VisitorObject {
            private String outerName;

            public MembersVisitor(String cname) {
                this.outerName = cname;
            }

            public Object visit(ClassDeclaration node) {
                return this.visitType(node);
            }

            public Object visit(InterfaceDeclaration node) {
                return this.visitType(node);
            }

            private Object visitType(TypeDeclaration node) {
                if (CompilationUnitVisitor.this.className.equals(this.outerName + "$" + node.getName())) {
                    return Boolean.TRUE;
                }
                MembersVisitor v = new MembersVisitor(this.outerName + "$" + node.getName());
                Iterator it = node.getMembers().iterator();
                while (it.hasNext()) {
                    Boolean b = (Boolean)((Node)it.next()).acceptVisitor(v);
                    if (!Boolean.TRUE.equals(b)) continue;
                    return b;
                }
                return Boolean.FALSE;
            }
        }
    }

    protected class PseudoError
    extends Error {
        protected PseudoError() {
        }
    }

    protected class PseudoClassLoader
    extends ClassLoader {
        protected PseudoClassLoader() {
            super(GlobalContext.this.interpreter.getClass().getClassLoader());
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            ImportationManager im;
            CompilationUnitVisitor v;
            ClassLoader cl;
            try {
                if (GlobalContext.this.getAdditionalClassLoader() != null) {
                    return Class.forName(name, true, GlobalContext.this.getAdditionalClassLoader());
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ClassLoader classLoader = cl = GlobalContext.this.classLoader == null ? GlobalContext.this.interpreter.getClassLoader() : GlobalContext.this.classLoader;
            if (cl instanceof TreeClassLoader && ((TreeClassLoader)cl).hasDefined(name)) {
                throw new PseudoError();
            }
            TreeClassLoader cld = (TreeClassLoader)GlobalContext.this.interpreter.getClassLoader();
            TypeDeclaration td = cld.getTree(name);
            if (td != null && td.acceptVisitor(v = new CompilationUnitVisitor(name, im = (ImportationManager)td.getProperty("importationManager"))).equals(Boolean.TRUE)) {
                throw new PseudoError();
            }
            LibraryFinder lf = GlobalContext.this.interpreter.getLibraryFinder();
            try {
                ImportationManager im2;
                CompilationUnitVisitor v2;
                String cun = lf.findCompilationUnitName(name);
                td = cld.getTree(cun);
                if (td != null && td.acceptVisitor(v2 = new CompilationUnitVisitor(name, im2 = (ImportationManager)td.getProperty("importationManager"))).equals(Boolean.TRUE)) {
                    throw new PseudoError();
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                File f = lf.findCompilationUnit(name);
                FileInputStream fis = new FileInputStream(f);
                ParserFactory pf = GlobalContext.this.interpreter.getParserFactory();
                SourceCodeParser p = pf.createParser(fis, f.getCanonicalPath());
                List stmts = p.parseCompilationUnit();
                Iterator it = stmts.iterator();
                CompilationUnitVisitor v3 = new CompilationUnitVisitor(name);
                boolean classFound = false;
                while (it.hasNext()) {
                    if (!Boolean.TRUE.equals(((Node)it.next()).acceptVisitor(v3))) continue;
                    classFound = true;
                }
                if (classFound) {
                    throw new PseudoError();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ClassNotFoundException(name);
        }
    }
}

