/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.EvaluationVisitor;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.InterpreterUtilities;
import koala.dynamicjava.interpreter.NameVisitor;
import koala.dynamicjava.interpreter.TreeClassLoader;
import koala.dynamicjava.interpreter.TreeCompiler;
import koala.dynamicjava.interpreter.TypeChecker;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.context.GlobalContext;
import koala.dynamicjava.interpreter.context.MethodContext;
import koala.dynamicjava.interpreter.context.StaticContext;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ReturnException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.parser.wrapper.ParserFactory;
import koala.dynamicjava.parser.wrapper.SourceCodeParser;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.visitor.VisitorObject;
import koala.dynamicjava.util.ImportationManager;
import koala.dynamicjava.util.LibraryFinder;

public class TreeInterpreter
implements Interpreter {
    protected ParserFactory parserFactory;
    protected LibraryFinder libraryFinder = new LibraryFinder();
    protected TreeClassLoader classLoader;
    protected static Map methods = new HashMap();
    List localMethods = new LinkedList();
    protected static Map constructorParameters = new HashMap();
    List localConstructorParameters = new LinkedList();
    protected static int nClass;
    protected Context nameVisitorContext;
    protected Context checkVisitorContext;
    protected Context evalVisitorContext;
    protected boolean accessible;
    static /* synthetic */ Class class$koala$dynamicjava$interpreter$error$CatchedExceptionError;

    public TreeInterpreter(ParserFactory pf) {
        this(pf, null);
    }

    public TreeInterpreter(ParserFactory pf, ClassLoader cl) {
        this.parserFactory = pf;
        this.classLoader = new TreeClassLoader(this, cl);
        this.nameVisitorContext = new GlobalContext(this);
        this.nameVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.checkVisitorContext = new GlobalContext(this);
        this.checkVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
        this.evalVisitorContext = new GlobalContext(this);
        this.evalVisitorContext.setAdditionalClassLoaderContainer(this.classLoader);
    }

    public Object interpret(Reader r, String fname) throws InterpreterException {
        try {
            List statements = this.parserFactory.createParser(r, fname).parseStream();
            Object result = null;
            ListIterator it = statements.listIterator();
            while (it.hasNext()) {
                VisitorObject v;
                Node n = (Node)it.next();
                Object o = n.acceptVisitor(v = new NameVisitor(this.nameVisitorContext));
                if (o != null) {
                    n = (Node)o;
                }
                v = new TypeChecker(this.checkVisitorContext);
                n.acceptVisitor(v);
                this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
                v = new EvaluationVisitor(this.evalVisitorContext);
                result = n.acceptVisitor(v);
            }
            return result;
        }
        catch (ExecutionError e) {
            throw new InterpreterException(e);
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    public Object interpret(InputStream is, String fname) throws InterpreterException {
        return this.interpret(new InputStreamReader(is), fname);
    }

    public Object interpret(String fname) throws InterpreterException, IOException {
        return this.interpret(new FileReader(fname), fname);
    }

    public List buildStatementList(Reader r, String fname) throws InterpreterException {
        try {
            SourceCodeParser p = this.parserFactory.createParser(r, fname);
            List statements = p.parseStream();
            ListIterator it = statements.listIterator();
            ArrayList<Node> resultingList = new ArrayList<Node>();
            while (it.hasNext()) {
                VisitorObject v;
                Node n = (Node)it.next();
                Object o = n.acceptVisitor(v = new NameVisitor(this.nameVisitorContext));
                if (o != null) {
                    n = (Node)o;
                }
                resultingList.add(n);
                v = new TypeChecker(this.checkVisitorContext);
                n.acceptVisitor(v);
                this.evalVisitorContext.defineVariables(this.checkVisitorContext.getCurrentScopeVariables());
            }
            return resultingList;
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    public Object interpret(List statements) throws InterpreterException {
        try {
            ListIterator it = statements.listIterator();
            Object result = null;
            while (it.hasNext()) {
                Node n = (Node)it.next();
                EvaluationVisitor v = new EvaluationVisitor(this.evalVisitorContext);
                result = n.acceptVisitor(v);
            }
            return result;
        }
        catch (ExecutionError e) {
            throw new InterpreterException(e);
        }
        catch (ParseError e) {
            throw new InterpreterException(e);
        }
    }

    public void defineVariable(String name, Object value, Class c) {
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, value);
    }

    public void defineVariable(String name, Object value) {
        this.defineVariable(name, value, value == null ? null : value.getClass());
    }

    public void defineVariable(String name, boolean value) {
        Class<Boolean> c = Boolean.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Boolean(value));
    }

    public void defineVariable(String name, byte value) {
        Class<Byte> c = Byte.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Byte(value));
    }

    public void defineVariable(String name, short value) {
        Class<Short> c = Short.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Short(value));
    }

    public void defineVariable(String name, char value) {
        Class<Character> c = Character.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Character(value));
    }

    public void defineVariable(String name, int value) {
        Class<Integer> c = Integer.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Integer(value));
    }

    public void defineVariable(String name, long value) {
        Class<Long> c = Long.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Long(value));
    }

    public void defineVariable(String name, float value) {
        Class<Float> c = Float.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Float(value));
    }

    public void defineVariable(String name, double value) {
        Class<Double> c = Double.TYPE;
        this.nameVisitorContext.define(name, c);
        this.checkVisitorContext.define(name, c);
        this.evalVisitorContext.define(name, new Double(value));
    }

    public void setVariable(String name, Object value) {
        Class c = (Class)this.checkVisitorContext.get(name);
        if (!InterpreterUtilities.isValidAssignment(c, value)) {
            throw new IllegalStateException(name);
        }
        this.evalVisitorContext.set(name, value);
    }

    public Object getVariable(String name) {
        return this.evalVisitorContext.get(name);
    }

    public Class getVariableClass(String name) {
        return (Class)this.checkVisitorContext.get(name);
    }

    public Set getVariableNames() {
        return this.evalVisitorContext.getCurrentScopeVariableNames();
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
        this.nameVisitorContext.setAccessible(accessible);
        this.checkVisitorContext.setAccessible(accessible);
        this.evalVisitorContext.setAccessible(accessible);
    }

    public boolean getAccessible() {
        return this.accessible;
    }

    public Set getClassNames() {
        return this.classLoader.getClassNames();
    }

    public void addClassPath(String path) {
        try {
            this.classLoader.addURL(new File(path).toURL());
        }
        catch (MalformedURLException e) {}
    }

    public void addClassURL(URL url) {
        this.classLoader.addURL(url);
    }

    public void addLibraryPath(String path) {
        this.libraryFinder.addPath(path);
    }

    public void addLibrarySuffix(String s) {
        this.libraryFinder.addSuffix(s);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return new TreeCompiler(this).compile(name);
    }

    public Class defineClass(String name, byte[] code) {
        return this.classLoader.defineClass(name, code);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public LibraryFinder getLibraryFinder() {
        return this.libraryFinder;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public Class getExceptionClass() {
        return class$koala$dynamicjava$interpreter$error$CatchedExceptionError == null ? (class$koala$dynamicjava$interpreter$error$CatchedExceptionError = TreeInterpreter.class$("koala.dynamicjava.interpreter.error.CatchedExceptionError")) : class$koala$dynamicjava$interpreter$error$CatchedExceptionError;
    }

    public void registerMethod(String sig, MethodDeclaration md, ImportationManager im) {
        this.localMethods.add(sig);
        methods.put(sig, new MethodDescriptor(md, im));
    }

    public static Object invokeMethod(String key, Object obj, Object[] params) {
        MethodDescriptor md = (MethodDescriptor)methods.get(key);
        Class<?> c = null;
        try {
            c = Class.forName(key.substring(0, key.lastIndexOf(35)), true, md.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return md.interpreter.interpretMethod(c, md, obj, params);
    }

    protected Object interpretMethod(Class c, MethodDescriptor md, Object obj, Object[] params) {
        VisitorObject v;
        StaticContext ctx;
        MethodDeclaration meth = md.method;
        List mparams = meth.getParameters();
        List stmts = meth.getBody().getStatements();
        String name = meth.getName();
        StaticContext context = null;
        if (Modifier.isStatic(md.method.getAccessFlags())) {
            if (md.variables == null) {
                md.importationManager.setClassLoader(this.classLoader);
                ctx = new StaticContext((Interpreter)this, c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                v = new NameVisitor(ctx);
                ListIterator<Object> it = mparams.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(v);
                }
                it = stmts.listIterator();
                while (it.hasNext()) {
                    Object o = ((Node)it.next()).acceptVisitor(v);
                    if (o == null) continue;
                    it.set(o);
                }
                ctx = new StaticContext((Interpreter)this, c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                v = new TypeChecker(ctx);
                it = mparams.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(v);
                }
                it = stmts.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(v);
                }
                md.variables = ctx.getCurrentScopeVariables();
                if (!name.equals("<clinit>") && !name.equals("<init>")) {
                    try {
                        md.contextField = c.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
            }
            context = new StaticContext((Interpreter)this, c, md.variables);
        } else {
            if (md.variables == null) {
                Object[] cell;
                md.importationManager.setClassLoader(this.classLoader);
                ctx = new MethodContext((Interpreter)this, c, (Object)c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                v = new NameVisitor(ctx);
                MethodContext ctx2 = new MethodContext((Interpreter)this, c, (Object)c, md.importationManager);
                ctx2.setAdditionalClassLoaderContainer(this.classLoader);
                VisitorObject v2 = new NameVisitor(ctx2);
                Object[][] cc = null;
                try {
                    Field f = c.getField("local$Variables$Class$0");
                    cc = (Object[][])f.get(obj);
                    int i = 0;
                    while (i < cc.length) {
                        cell = cc[i];
                        if (!((String)cell[0]).equals("this")) {
                            ctx.defineConstant((String)cell[0], cell[1]);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ListIterator<Object> it = mparams.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(v);
                }
                it = stmts.listIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    Object o = null;
                    o = n.hasProperty("instanceInitializer") ? n.acceptVisitor(v2) : n.acceptVisitor(v);
                    if (o == null) continue;
                    it.set(o);
                }
                ctx = new MethodContext((Interpreter)this, c, (Object)c, md.importationManager);
                ctx.setAdditionalClassLoaderContainer(this.classLoader);
                v = new TypeChecker(ctx);
                ctx2 = new MethodContext((Interpreter)this, c, (Object)c, md.importationManager);
                ctx2.setAdditionalClassLoaderContainer(this.classLoader);
                v2 = new TypeChecker(ctx2);
                if (cc != null) {
                    int i = 0;
                    while (i < cc.length) {
                        cell = cc[i];
                        if (!((String)cell[0]).equals("this")) {
                            ctx.defineConstant((String)cell[0], cell[1]);
                        }
                        ++i;
                    }
                }
                it = mparams.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(v);
                }
                it = stmts.listIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.hasProperty("instanceInitializer")) {
                        n.acceptVisitor(v2);
                        continue;
                    }
                    n.acceptVisitor(v);
                }
                md.variables = ctx.getCurrentScopeVariables();
                if (!name.equals("<clinit>") && !name.equals("<init>")) {
                    try {
                        md.contextField = c.getField("local$Variables$Reference$0");
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
            }
            context = new MethodContext((Interpreter)this, c, obj, md.variables);
        }
        context.setAdditionalClassLoaderContainer(this.classLoader);
        Iterator<Object> it = mparams.iterator();
        int i = 0;
        while (it.hasNext()) {
            context.set(((FormalParameter)it.next()).getName(), params[i++]);
        }
        if (md.contextField != null) {
            Map vars = null;
            try {
                vars = (Map)md.contextField.get(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (vars != null) {
                it = vars.keySet().iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    if (s.equals("this")) continue;
                    context.setConstant(s, vars.get(s));
                }
            }
        }
        EvaluationVisitor v2 = new EvaluationVisitor(context);
        it = stmts.iterator();
        try {
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(v2);
            }
        }
        catch (ReturnException e) {
            return e.getValue();
        }
        return null;
    }

    public void registerConstructorArguments(String sig, List params, List exprs, ImportationManager im) {
        this.localConstructorParameters.add(sig);
        constructorParameters.put(sig, new ConstructorParametersDescriptor(params, exprs, im));
    }

    public static Object[] interpretArguments(String key, Object[] args) {
        ConstructorParametersDescriptor cpd = (ConstructorParametersDescriptor)constructorParameters.get(key);
        Class<?> c = null;
        try {
            c = Class.forName(key.substring(0, key.lastIndexOf(35)), true, cpd.interpreter.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return cpd.interpreter.interpretArguments(c, cpd, args);
    }

    protected Object[] interpretArguments(Class c, ConstructorParametersDescriptor cpd, Object[] args) {
        ListIterator<Object> it;
        StaticContext ctx;
        if (cpd.variables == null) {
            cpd.importationManager.setClassLoader(this.classLoader);
            ctx = new StaticContext((Interpreter)this, c, cpd.importationManager);
            ctx.setAdditionalClassLoaderContainer(this.classLoader);
            NameVisitor nv = new NameVisitor(ctx);
            TypeChecker tc = new TypeChecker(ctx);
            if (cpd.parameters != null) {
                it = cpd.parameters.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(tc);
                }
            }
            if (cpd.arguments != null) {
                it = cpd.arguments.listIterator();
                while (it.hasNext()) {
                    Node root = (Node)it.next();
                    Object res = root.acceptVisitor(nv);
                    if (res == null) continue;
                    it.set(res);
                }
                it = cpd.arguments.listIterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(tc);
                }
            }
            cpd.variables = ctx.getCurrentScopeVariables();
        }
        ctx = new StaticContext((Interpreter)this, c, cpd.variables);
        ctx.setAdditionalClassLoaderContainer(this.classLoader);
        if (cpd.parameters != null) {
            Iterator it2 = cpd.parameters.iterator();
            int i = 0;
            while (it2.hasNext()) {
                ctx.set(((FormalParameter)it2.next()).getName(), args[i++]);
            }
        }
        Object[] result = new Object[]{};
        if (cpd.arguments != null) {
            EvaluationVisitor v = new EvaluationVisitor(ctx);
            it = cpd.arguments.listIterator();
            result = new Object[cpd.arguments.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = ((Node)it.next()).acceptVisitor(v);
            }
        }
        return result;
    }

    protected void finalize() throws Throwable {
        Iterator it = this.localMethods.iterator();
        while (it.hasNext()) {
            methods.remove(it.next());
        }
        it = this.localConstructorParameters.iterator();
        while (it.hasNext()) {
            constructorParameters.remove(it.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ConstructorParametersDescriptor {
        Set variables;
        List parameters;
        List arguments;
        ImportationManager importationManager;
        TreeInterpreter interpreter;

        ConstructorParametersDescriptor(List params, List args, ImportationManager im) {
            this.parameters = params;
            this.arguments = args;
            this.importationManager = im;
            this.interpreter = TreeInterpreter.this;
        }
    }

    protected class MethodDescriptor {
        Set variables;
        MethodDeclaration method;
        ImportationManager importationManager;
        TreeInterpreter interpreter;
        Field contextField;

        MethodDescriptor(MethodDeclaration md, ImportationManager im) {
            this.method = md;
            this.importationManager = im;
            this.interpreter = TreeInterpreter.this;
        }
    }
}

