/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.ThrownException;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.tree.Node;

public class InterpreterException
extends ThrownException {
    protected SourceInformation sourceInformation;
    protected String message;

    public InterpreterException(ParseError e) {
        super(e);
        if (e.getLine() != -1) {
            this.sourceInformation = new SourceInformation(e.getFilename(), e.getLine(), e.getColumn());
            this.message = "L" + e.getLine() + ", C" + e.getColumn() + " (" + e.getFilename() + "):\n" + e.getMessage();
        } else {
            this.message = e.getMessage();
        }
    }

    public InterpreterException(ExecutionError e) {
        super(e);
        Node n = e.getNode();
        if (n != null && n.getFilename() != null) {
            this.sourceInformation = new SourceInformation(n.getFilename(), n.getBeginLine(), n.getBeginColumn());
            this.message = "L" + n.getBeginLine() + ", C" + n.getBeginColumn() + " (" + n.getFilename() + "):\n";
        } else {
            this.message = "";
        }
        this.message = e instanceof CatchedExceptionError ? this.message + ((CatchedExceptionError)e).getException() : (e instanceof ThrownException ? this.message + ((ThrownException)e).getException() : this.message + e.getMessage());
    }

    public Throwable getError() {
        return this.thrown;
    }

    public SourceInformation getSourceInformation() {
        return this.sourceInformation;
    }

    public String getMessage() {
        return this.message;
    }

    public static class SourceInformation {
        private String filename;
        private int line;
        private int column;

        public SourceInformation(String filename, int line, int column) {
            this.filename = filename;
            this.line = line;
            this.column = column;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

