/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCChannelName;
import irc.IRCUser;
import java.util.zip.Adler32;

class IRCNicknameHashKey
implements Comparable {
    private byte[] key;
    private int hash_code;

    public int hashCode() {
        return this.hash_code;
    }

    public IRCNicknameHashKey(byte[] _key) {
        this.key = _key;
        Adler32 check = new Adler32();
        check.update(IRCChannelName.RawToLow(this.key));
        long value = check.getValue();
        if (value > Integer.MAX_VALUE) {
            value -= 0x100000000L;
        }
        this.hash_code = (int)value;
    }

    public boolean equals(Object obj) {
        return this.hash_code == ((IRCNicknameHashKey)obj).hash_code && this.key.length == ((IRCNicknameHashKey)obj).key.length && this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        byte[] a = this.key;
        byte[] b = ((IRCNicknameHashKey)obj).key;
        int minlength = a.length < b.length ? a.length : b.length;
        for (int i = 0; i < minlength; ++i) {
            int r = IRCUser.tolower(a[i]) - IRCUser.tolower(b[i]);
            if (r == 0) continue;
            return r;
        }
        return a.length - b.length;
    }
}

