/*
 * Decompiled with CFR 0.152.
 */
package irc;

import base.Util;
import irc.CTCPQuote;
import irc.IRCChannel;
import irc.IRCChannelName;
import irc.IRCConnectionListener;
import irc.IRCMessage;
import irc.IRCMessageReader;
import irc.IRCNicknameHash;
import irc.IRCSocketReader;
import irc.IRCSocketReaderListener;
import irc.IRCUser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IRCConnection
implements Runnable {
    public static Logger logger = Logger.getLogger("irc.ircconnection");
    public Object Extra;
    public base.Logger base_logger;
    private IRCConnectionListener listener;
    public boolean fAutoReconnect;
    public String Nick;
    byte[] FirstPrefix;
    public byte[] NickLowerName;
    public IRCUser fromServer;
    public IRCUser myself;
    public String host001;
    LinkedList command_on_authorized = new LinkedList();
    IRCSocketReader sr;
    private boolean isConnect = false;
    int connect_try_count = 0;
    LinkedList ctcp_send_cue = null;
    private Map _Channels = new HashMap();
    private IRCNicknameHash users = new IRCNicknameHash();

    public IRCConnectionListener getListener() {
        return this.listener;
    }

    public IRCConnection(IRCConnectionListener listener, base.Logger base_logger) {
        if (listener == null) {
            throw new NullPointerException("please specify IRCConnectionListener");
        }
        if (base_logger == null) {
            base_logger = new base.Logger(){

                public void Log(String s) {
                    logger.info(s);
                }
            };
        }
        this.listener = listener;
        this.base_logger = base_logger;
    }

    public void cleanup() {
        this.listener = null;
        this.Extra = null;
    }

    public byte[] getMyLowerNick() {
        return this.NickLowerName;
    }

    public void addCommandOnAuthorized(byte[] cmd) {
        this.command_on_authorized.add(cmd);
    }

    void Log(String cmd, String s) {
        this.Log(cmd, null, s);
    }

    void Log(String cmd, IRCChannel chan, String s) {
        if (this.listener == null) {
            String t = Util.GetTime(this.listener.getTimeZone(this));
            String c_name = "";
            if (chan != null) {
                c_name = chan.getShortName();
            }
            logger.info(t + c_name + "@" + this.listener.getConnectionName(this) + " " + cmd + " " + s);
            return;
        }
        IRCMessage m = new IRCMessage(this, cmd, s);
        m.addContext(chan).sendLogToListener();
    }

    public boolean isConnected() {
        return this.isConnect;
    }

    void SetNick(String s) {
        this.SendToServer(IRCConnection.encodeString("NICK " + s), true, true);
    }

    public Socket getSocket() {
        return this.sr == null ? null : this.sr.getSocket();
    }

    public void Connect() {
        this.Connect(true);
    }

    public void Connect(boolean isFirst) {
        block6: {
            if (this.isConnect) {
                return;
            }
            if (isFirst) {
                this.connect_try_count = 0;
                this.fAutoReconnect = this.listener.isAutoReconnect(this);
            } else {
                ++this.connect_try_count;
                if (!this.fAutoReconnect) {
                    return;
                }
            }
            this.isConnect = true;
            this.FirstPrefix = null;
            this.sr = null;
            this.myself = null;
            this.fromServer = null;
            this.host001 = null;
            this.ctcp_send_cue = new LinkedList();
            try {
                String rhost = this.listener.getServerHost(this, this.connect_try_count);
                int rport = this.listener.getServerPort(this, this.connect_try_count);
                this.Log("OnConnectRequest", rhost + " " + rport + "\u306b\u63a5\u7d9a\u3057\u307e\u3059\u2026(\u8a66\u884c" + (this.connect_try_count + 1) + "\u56de\u76ee)");
                this.sr = new IRCSocketReader(this.listener.getSelector(), rhost, rport, this.listener.getLocalHost(this), this.listener.getLocalPort(this), this.listener.getSoTimeout(this), new IRCSocketReaderListener(){

                    public void onConnect() {
                        IRCConnection.this.ConnConnect();
                    }

                    public void onDisconnect(String s) {
                        IRCConnection.this.ConnDisconnect(s);
                    }

                    public void onRecvLine(byte[] ba) {
                        IRCConnection.this.ConnRecvLine(ba);
                    }

                    public void onConnectionError(Throwable e) {
                        IRCConnection.this.Log("OnConnectionError", e.toString() + " " + e.getMessage());
                    }

                    public void onMessageError(Throwable e) {
                        IRCConnection.this.Log("OnMessageError", e.toString() + " " + e.getMessage());
                        StackTraceElement[] list = e.getStackTrace();
                        for (int i = 0; i < list.length; ++i) {
                            IRCConnection.this.Log("OnMessageError", "stack[" + i + "]" + " " + list[i].getFileName() + " " + list[i].getLineNumber() + " " + list[i].getClassName() + " " + list[i].getMethodName() + " native=" + list[i].isNativeMethod());
                        }
                    }
                });
            }
            catch (Throwable e) {
                this.isConnect = false;
                this.Log("OnConnectionError", e.toString() + " " + e.getMessage());
                if (!this.fAutoReconnect) break block6;
                this.listener.invokeLater(2 << this.connect_try_count, this);
            }
        }
    }

    public void run() {
        this.Connect(false);
    }

    public void Disconnect(String s) {
        if (!this.isConnect) {
            return;
        }
        this.Log("OnDisconnectRequest", "\u5207\u65ad\u3057\u307e\u3059\u2026(" + s + ")");
        this.fAutoReconnect = false;
        this.sr.WriteQuit(IRCChannelName.unescape("QUIT :" + s), s);
    }

    public void ConnConnect() {
        if (this.myself != null) {
            return;
        }
        try {
            String pass = this.getListener().getPassword(this);
            if (pass != null && pass.length() > 0) {
                this.SendToServer(IRCConnection.encodeString("PASS " + pass), false, true);
            }
            this.SetNick(this.getListener().getNickName(this, true));
            this.SendToServer(IRCConnection.encodeString("USER " + this.getListener().getUserName(this) + " 0 * :" + this.getListener().getRealName(this)), true, true);
            this.Log("OnConnect", "\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002\u8a8d\u8a3c\u3092\u5f85\u3061\u307e\u3059\u2026");
            if (this.listener != null) {
                this.listener.OnConnectRequest(this);
            }
        }
        catch (Exception e) {
            this.Log("OnError", "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + e.toString() + " " + e.getMessage());
            logger.log(Level.WARNING, "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
    }

    void ConnAuthorized(IRCMessage m) {
        this.isConnect = true;
        this.getListener().OnConnectAuthorized(m);
        this.Log("OnConnectAuthorized", "\u30b5\u30fc\u30d0\u306b\u8a8d\u8a3c\u3055\u308c\u307e\u3057\u305f");
        Iterator it = this.command_on_authorized.iterator();
        while (it.hasNext()) {
            this.sr.Write((byte[])it.next());
        }
        this.command_on_authorized.clear();
    }

    void ConnDisconnect(String s) {
        this.isConnect = false;
        this.ctcp_send_cue = null;
        this.command_on_authorized.clear();
        IRCMessage m = new IRCMessage(this, "OnDisconnect", "\u63a5\u7d9a\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f " + s);
        m.addContext(this);
        Iterator it = this._Channels.values().iterator();
        while (it.hasNext()) {
            IRCChannel chan = (IRCChannel)it.next();
            boolean IsIn = chan.OnPartMyself();
            if (IsIn) {
                this.listener.ChangeChannelJoin(this, chan, false);
            }
            chan.RemoveUserAll(this);
            if (!IsIn) continue;
            m.addContext(chan);
        }
        m.sendLogToListener();
        this.listener.OnDisconnect(this);
        if (this.fAutoReconnect) {
            this.listener.invokeLater(2, this);
        }
    }

    void ConnRecvLine(byte[] ba) {
        if (ba == null || ba.length == 0) {
            return;
        }
        try {
            this.Log("OnRecv", Util.fromJIS(ba));
            if (this.listener.isDumpRecvLine(this)) {
                System.err.println(Util.GetTimeStr(this.listener.getTimeZone(this)) + " s>" + Util.fromJIS(ba));
            }
            IRCMessage message = new IRCMessage(this, ba);
            if ((message = this.listener.rewriteIRCMessage1(message)) == null) {
                return;
            }
            IRCMessageReader.checkMessage(message);
            message = this.listener.rewriteIRCMessage2(message);
            if (message == null) {
                return;
            }
            message.sendLogToListener();
            IRCMessage[] ctcp = message.getCTCP();
            if (ctcp == null) {
                return;
            }
            for (int i = 0; i < ctcp.length; ++i) {
                if (this.listener.isDumpRecvCTCP(this)) {
                    System.err.println("OnRecvCTCP from=" + (ctcp[i].log_from == null ? "(null)" : ctcp[i].log_from.getEscapedName()) + " to=" + (ctcp[i].log_to == null ? "(null)" : ctcp[i].log_to.getEscapedName()) + " ctcp=" + (ctcp[i].line == null ? "(null)" : Util.fromJIS(ctcp[i].line)));
                }
                ctcp[i] = this.listener.rewriteIRCMessage1(ctcp[i]);
                if (ctcp[i] == null) {
                    return;
                }
                IRCMessageReader.checkMessage(ctcp[i]);
                ctcp[i] = this.listener.rewriteIRCMessage2(ctcp[i]);
                if (ctcp[i] == null) continue;
                ctcp[i].sendLogToListener();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "ConnRecvLine: " + Util.GetTimeStr(this.listener.getTimeZone(this)) + " s>" + Util.fromJIS(ba), e);
        }
    }

    public void SendToServer(byte[] ba, boolean recLog, boolean isFast) {
        if (ba == null) {
            return;
        }
        if (recLog) {
            String tmp = Util.fromJIS(ba);
            this.Log("OnSend", tmp);
            if (this.listener.isDumpRecvLine(this)) {
                System.err.println("c>" + tmp);
            }
        }
        if (this.sr != null) {
            if (isFast) {
                this.sr.WriteFast(ba);
            } else {
                this.sr.Write(ba);
            }
        }
    }

    public void SendToServer(byte[] ba) {
        this.SendToServer(ba, true, false);
    }

    public static byte[] encodeString(String s) {
        return Util.toJIS(s);
    }

    public static byte[] encodeUserCommand(String s) {
        return IRCChannelName.unescape(s);
    }

    public byte[] encodeUserTalk(String a_cmd, byte[] to, byte[] text) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(Util.toJIS(a_cmd));
            ba.write(32);
            if (this.listener.isQuoteAllParam(this)) {
                CTCPQuote.encodeParam(ba, to, 0, to.length, false);
            } else {
                ba.write(to);
            }
            ba.write(32);
            ba.write(58);
            CTCPQuote.encodeParam(ba, text, 0, text.length, !this.listener.isQuoteSpace(this));
            return ba.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void SendToServer(List args) {
        this.SendToServer(this.encodeList(args), true, false);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encodeList(List args) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            int i = 0;
            Iterator it = args.iterator();
            while (it.hasNext()) {
                void var6_7;
                byte[] b;
                Object o = it.next();
                if (i > 0) {
                    ba.write(32);
                    if (i == args.size() - 1) {
                        ba.write(58);
                    }
                }
                if (o instanceof byte[]) {
                    b = (byte[])o;
                } else if (o instanceof String) {
                    b = Util.toJIS((String)o);
                } else {
                    throw new Exception("SendToServer :unknown object type:" + o.toString());
                }
                if (this.listener.isQuoteAllParam(this)) {
                    CTCPQuote.encodeParam(ba, (byte[])var6_7, 0, ((void)var6_7).length, i == args.size() - 1 && !this.listener.isQuoteSpace(this));
                } else {
                    ba.write((byte[])var6_7);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.Log("OnError", "IRCConnection.SendToServer(List):" + e.getMessage());
            return null;
        }
        return ba.toByteArray();
    }

    public byte[] encodeCTCP(byte[] to, List ctcp, String priv_or_notice) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        byte[] cmd = Util.toJIS(priv_or_notice);
        CTCPQuote.encodeParam(ba, cmd, 0, cmd.length, false);
        ba.write(32);
        CTCPQuote.encodeParam(ba, to, 0, to.length, false);
        ba.write(32);
        ba.write(58);
        ba.write(1);
        Iterator it = ctcp.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            byte[] b = o instanceof String ? Util.toJIS((String)o) : (byte[])o;
            CTCPQuote.encodeParam(ba, b, 0, b.length, i == ctcp.size() - 1 && !this.listener.isQuoteSpace(this));
            if (i != ctcp.size() - 1) {
                if (this.listener.isQuoteSpaceAtCTCPArg(this)) {
                    ba.write(16);
                    ba.write(64);
                } else {
                    ba.write(32);
                }
            }
            ++i;
        }
        ba.write(1);
        return ba.toByteArray();
    }

    public void SendCTCPReplyIfAvail(GregorianCalendar time, IRCUser to, List reply) {
        if (this.ctcp_send_cue == null) {
            return;
        }
        long now = time.getTime().getTime();
        while (this.ctcp_send_cue.size() > 0 && (Long)this.ctcp_send_cue.getFirst() < now - (long)this.listener.getCTCPSendCueTimeExpire(this)) {
            this.ctcp_send_cue.removeFirst();
        }
        if (this.ctcp_send_cue.size() > this.listener.getCTCPSendCueLimitInTime(this)) {
            this.base_logger.Log("flood\u5bfe\u7b56\u306e\u305f\u3081\u306b\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u9001\u3089\u308c\u306a\u304b\u3063\u305f");
            return;
        }
        this.ctcp_send_cue.add(new Long(now));
        this.SendToServer(this.encodeCTCP(to.getRawBytes(), reply, "NOTICE"));
    }

    public Object RemoveChannel(IRCChannel chan) {
        return (IRCChannel)this._Channels.remove(chan.getCName());
    }

    public void ChangeChannelName(IRCChannelName oldName, IRCChannel chan) {
        this._Channels.remove(oldName);
        this._Channels.put(chan.getCName(), chan);
    }

    public IRCChannel FindChannel(byte[] name, boolean CanCreate) {
        return this.FindChannel(new IRCChannelName(name), CanCreate);
    }

    public IRCChannel FindChannel(String name, boolean CanCreate) {
        return this.FindChannel(new IRCChannelName(name), CanCreate);
    }

    public IRCChannel FindChannel(IRCUser pref, boolean CanCreate) {
        return this.FindChannel(new IRCChannelName(pref.getNick()), CanCreate);
    }

    public IRCChannel FindChannel(IRCChannelName key, boolean CanCreate) {
        IRCChannel chan = (IRCChannel)this._Channels.get(key);
        if (chan != null || !CanCreate) {
            return chan;
        }
        chan = IRCChannel.createByIRCConnection(this, key);
        this._Channels.put(key, chan);
        this.listener.initIRCChannel(this, chan);
        return chan;
    }

    public List getChannels() {
        Vector v = new Vector(this._Channels.size());
        Iterator it = this._Channels.values().iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    public IRCChannel findChannelAmbiguous(IRCChannelName name) {
        IRCChannel chan;
        Iterator it = this._Channels.values().iterator();
        while (it.hasNext()) {
            chan = (IRCChannel)it.next();
            if (!chan.getCName().equals(name)) continue;
            return chan;
        }
        it = this._Channels.values().iterator();
        while (it.hasNext()) {
            chan = (IRCChannel)it.next();
            if (!chan.getCName().getShortName().equalsIgnoreCase(name.getShortName())) continue;
            return chan;
        }
        return null;
    }

    public void removeUserAll() {
        this.users.clear();
    }

    public IRCUser removeUser(IRCUser who) {
        return (IRCUser)this.users.remove(who);
    }

    public IRCUser findUser(byte[] prefix) {
        int i = Util.ByteIndexOf(prefix, '!');
        IRCUser user = (IRCUser)this.users.get(i == -1 ? prefix : Util.ByteSubString(prefix, 0, i));
        if (user == null) {
            user = IRCUser.createByIRCConnection(prefix);
            this.users.put(user.getNickBytes(), (Object)user);
        } else if (i != -1 && (i = user.updatePrefix(prefix, i)) != 0) {
            this.listener.onChangePrefix(this, user, 1);
        }
        return user;
    }

    public IRCUser changeUserNick(IRCUser from, byte[] newname) {
        this.removeUser(from);
        from.changeNick(newname);
        this.users.put(from.getNickBytes(), (Object)from);
        return from;
    }

    static {
        logger.setLevel(null);
    }
}

