/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.LogDocument;
import gui.MyScrollBar;
import gui.MyTransferHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class LogView
extends JPanel
implements Transferable {
    ActionListener LogSweepListener = null;
    private LogDocument doc;
    JScrollBar scroll_bar;
    static DataFlavor[] my_DataFlavor = new DataFlavor[]{DataFlavor.getTextPlainUnicodeFlavor()};

    public LogView(boolean trans) {
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Dialog", 0, 12));
        this.scroll_bar = new MyScrollBar(1, trans);
        this.add((Component)this.scroll_bar, "East");
        this.scroll_bar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                LogView.this.scrollTo(e.getValue());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (LogView.this.doc == null) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 38: 
                    case 224: {
                        LogView.this.scrollLines(-1);
                        break;
                    }
                    case 40: 
                    case 225: {
                        LogView.this.scrollLines(1);
                        break;
                    }
                    case 33: {
                        LogView.this.scrollTo(LogView.this.doc.getScrollY() - LogView.this.getHeight());
                        break;
                    }
                    case 34: {
                        LogView.this.scrollTo(LogView.this.doc.getScrollY() + LogView.this.getHeight());
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                if (LogView.this.doc != null) {
                    LogView.this.doc.mouseExited(e);
                }
            }

            public void mouseClicked(MouseEvent e) {
                LogView.this.requestFocus();
                if (LogView.this.doc != null) {
                    LogView.this.doc.mouseClicked(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                LogView.this.requestFocus();
                if (LogView.this.doc == null) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    LogView.this.doc.mousePressed(e);
                    return;
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (LogView.this.doc != null) {
                    LogView.this.doc.mouseReleased(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                if (LogView.this.doc != null) {
                    LogView.this.doc.mouseMoved(e);
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (LogView.this.doc == null) {
                    return;
                }
                int y = e.getY();
                if (y < 0) {
                    LogView.this.scrollTo(LogView.this.doc.getScrollY() + (y >> 2));
                } else if ((y -= LogView.this.getHeight()) > 0) {
                    LogView.this.scrollTo(LogView.this.doc.getScrollY() + (y >> 2));
                }
                LogView.this.doc.mouseDragged(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                LogView.this.OnResize();
                LogView.this.repaint(100L);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (LogView.this.doc == null) {
                    return;
                }
                LogView.this.scrollLines(e.getUnitsToScroll());
            }
        });
        this.setTransferHandler(new MyTransferHandler(this));
    }

    public void addLogSweepListener(ActionListener a) {
        this.LogSweepListener = a;
    }

    void onLogSweep() {
        this.OnResize();
        this.repaint(100L);
        if (this.LogSweepListener != null) {
            this.LogSweepListener.actionPerformed(new ActionEvent(this, 0, "onLogSweep"));
        }
    }

    public LogDocument getDocument() {
        return this.doc;
    }

    public void setDocument(LogDocument a_doc) {
        if (this.doc != a_doc) {
            if (this.doc != null) {
                this.doc.addView_byLogView(null);
            }
            this.doc = a_doc;
            if (this.doc != null) {
                this.doc.addView_byLogView(this);
                this.doc.ReloadSetting(this);
                int sy = this.doc.getScrollY();
                this.scroll_bar.setVisibleAmount(this.getHeight());
                this.scroll_bar.setMaximum(this.doc.getHeight());
                this.scroll_bar.setValue(this.doc.setScrollY(sy));
            }
            this.OnResize();
            this.repaint(100L);
        }
    }

    public void paint(Graphics g) {
        Rectangle rec = g.getClipBounds();
        int w = this.getWidth() - this.scroll_bar.getWidth();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(rec.x, rec.y, rec.width, rec.height);
        }
        if (this.doc == null) {
            g.setColor(this.getForeground());
            g.drawString("\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u304c\u6307\u5b9a\u3055\u308c\u3066\u306a\u3044", 0, this.getFontMetrics(this.getFont()).getAscent());
        } else {
            this.doc.paint(g, this, this.getWidth() - this.scroll_bar.getWidth());
        }
        super.paintBorder(g);
        super.paintChildren(g);
    }

    public void onAddText(int height) {
        int old_max = this.scroll_bar.getMaximum();
        int old_scroll = this.scroll_bar.getValue();
        this.scroll_bar.setMaximum(this.doc.getHeight());
        if (this.doc.getHeight() <= this.getHeight()) {
            this.scrollTo(0);
            this.repaint(100L, 0, old_max, this.getWidth() - this.scroll_bar.getWidth(), height);
            return;
        }
        if (old_scroll > old_max - this.getHeight() - height) {
            this.scrollTo(this.doc.getHeight() - this.getHeight());
            return;
        }
        if (old_scroll >= old_max - this.getHeight()) {
            this.repaint(100L, 0, old_max, this.getWidth() - this.scroll_bar.getWidth(), height);
            return;
        }
    }

    public int getLineHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    void scrollLines(int lines) {
        if (this.doc == null) {
            return;
        }
        this.scrollTo(this.doc.getScrollY() + lines * this.getLineHeight());
    }

    void scrollTo(int new_y) {
        if (this.doc == null) {
            return;
        }
        int height = this.getHeight();
        int max = this.doc.getHeight() - height;
        if (new_y > max) {
            new_y = max;
        }
        if (new_y < 0) {
            new_y = 0;
        }
        this.scroll_bar.setMaximum(this.doc.getHeight());
        this.scroll_bar.setVisibleAmount(height);
        if (this.doc.getScrollY() == new_y) {
            return;
        }
        this.doc.setScrollY(new_y);
        if (this.doc.getScrollY() != this.scroll_bar.getValue()) {
            this.scroll_bar.setValue(this.doc.getScrollY());
        }
        this.repaint(100L);
    }

    void OnResize() {
        int old_height = this.scroll_bar.getVisibleAmount();
        int old_max = this.scroll_bar.getMaximum();
        int old_scrolly = this.scroll_bar.getValue();
        if (this.doc == null) {
            this.scroll_bar.setMaximum(0);
            this.scroll_bar.setValue(0);
        } else {
            int w = this.getWidth() - this.scroll_bar.getWidth();
            this.doc.setWidth(this, w, this.getHeight());
            this.scroll_bar.setMaximum(this.doc.getHeight());
        }
        this.scroll_bar.setMinimum(0);
        this.scroll_bar.setBlockIncrement(this.getHeight());
        this.scroll_bar.setVisibleAmount(this.getHeight());
        this.scroll_bar.setUnitIncrement(this.getLineHeight());
        if (this.doc != null) {
            int under = old_max - (old_scrolly + old_height);
            if (under < this.getFontMetrics(this.getFont()).getHeight()) {
                under = 0;
            }
            this.scrollTo(this.doc.getHeight() - under - this.getHeight());
        }
    }

    public String getSelectedText() {
        if (this.doc == null) {
            return "";
        }
        return this.doc.getSelectedText();
    }

    public void selectAll() {
        if (this.doc != null) {
            this.doc.selectAll();
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return my_DataFlavor;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return my_DataFlavor[0].equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.getSelectedText();
    }
}

