/*
 * Decompiled with CFR 0.152.
 */
package buffer;

import buffer.BufferTextBlock;
import buffer.LogLineInfo;
import buffer.LogSelPos;
import buffer.LogSelectionRange;
import buffer.PackedLineReader;
import buffer.SpanMetrics;
import buffer.SpanSizeDetail;
import buffer.StyleID;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;

class LogDiv {
    int divsize_height = 0;
    LogLineInfo[] lines;
    BufferTextBlock block;
    int lnum;
    StyleID sid;

    int getHeight() {
        return this.divsize_height;
    }

    LogSelPos GetEndPos() {
        return this.lines[this.lines.length - 1].getEndPos();
    }

    LogSelPos GetBeginPos(Object g) {
        return this.lines[0].getStartPos();
    }

    public LogDiv(BufferTextBlock block, int lnum, StyleID sid) {
        this.block = block;
        this.lnum = lnum;
        this.sid = sid;
    }

    public int updateHeight(Object graphics, int divsize_width) {
        if (divsize_width <= 0) {
            this.lines = new LogLineInfo[1];
            this.lines[0] = new LogLineInfo(0, 0);
            this.divsize_height = 2;
            this.lines[0].height = (short)2;
            this.lines[0].baseline = 1;
            return this.divsize_height;
        }
        this.lines = null;
        this.divsize_height = 0;
        PackedLineReader tsi = new PackedLineReader(this.block, this.lnum, this.sid, "base");
        LinkedList<LogLineInfo> lines = new LinkedList<LogLineInfo>();
        LogLineInfo line = null;
        short line_start_x = 0;
        int line_Ascent = 0;
        int line_Descent = 0;
        int line_Leading = 0;
        int span_index = 0;
        while (true) {
            if (tsi.readSpan() == 0) {
                if (!tsi.hasNextSpan()) break;
                if (line != null) {
                    line_start_x = line.width < divsize_width ? line.width : (short)0;
                }
            }
            SpanMetrics metrics = new SpanMetrics(tsi, this.sid);
            int span_offset = 0;
            do {
                if (line == null) {
                    line = new LogLineInfo(span_index, span_offset);
                    line.x = line.width = line_start_x;
                    line_Leading = 0;
                    line_Descent = 0;
                    line_Ascent = 0;
                }
                boolean closeline = false;
                SpanSizeDetail nodesize = metrics.calcSizeDetail(graphics, span_offset, metrics.length);
                if (line.width + nodesize.width <= divsize_width) {
                    span_offset = metrics.length;
                    if (!tsi.hasNextSpan()) {
                        closeline = true;
                    }
                } else {
                    closeline = true;
                    int mojisu = metrics.calcMojisu(graphics, span_offset, divsize_width - line.width);
                    if (mojisu == 0 && line.x == line.width) {
                        System.err.println("too short width: offset=" + span_offset + " length=" + metrics.length);
                        mojisu = 10;
                    }
                    int old_offset = span_offset;
                    if ((span_offset += mojisu) >= metrics.length) {
                        span_offset = metrics.length;
                    }
                    nodesize = metrics.calcSizeDetail(this, old_offset, span_offset);
                }
                if (nodesize.width > 0) {
                    line.width = (short)(line.width + nodesize.width);
                    if (line_Ascent < nodesize.Ascent) {
                        line_Ascent = nodesize.Ascent;
                    }
                    if (line_Descent < nodesize.Descent) {
                        line_Descent = nodesize.Descent;
                    }
                    if (line_Leading < nodesize.Leading) {
                        line_Leading = nodesize.Leading;
                    }
                }
                if (!closeline) continue;
                line.end_span = (short)span_index;
                line.end_offset = (short)span_offset;
                line.height = (short)(line_Leading + line_Ascent + line_Descent + 1);
                line.baseline = (short)(line.height - (line_Descent + 1));
                lines.add(line);
                this.divsize_height += line.height;
                line = null;
            } while (span_offset < metrics.length);
            ++span_index;
        }
        this.lines = new LogLineInfo[lines.size()];
        Iterator it = lines.iterator();
        for (int i = 0; i < lines.size(); ++i) {
            this.lines[i] = (LogLineInfo)it.next();
        }
        return this.divsize_height;
    }

    public LogSelPos PointToPos(Object component, Point p, boolean severe) {
        if (this.lines == null) {
            return null;
        }
        int x = p.x;
        int y = p.y;
        for (int it = 0; it < this.lines.length; ++it) {
            LogLineInfo line = this.lines[it];
            if (y >= line.height) {
                y -= line.height;
                continue;
            }
            LogSelectionRange range = new LogSelectionRange(line.getStartPos(), line.getEndPos());
            if (x < line.x) {
                return severe ? null : range.start;
            }
            x -= line.x;
            PackedLineReader tsi = new PackedLineReader(this.block, this.lnum, this.sid, "base");
            int s = 0;
            while (true) {
                int text_length = tsi.readSpan();
                if (s >= range.start.span) {
                    int end;
                    if (s > range.end.span) break;
                    SpanMetrics metrics = new SpanMetrics(tsi, this.sid);
                    short start = s == range.start.span ? range.start.offset : (short)0;
                    int nodewidth = metrics.getSubstringWidth(component, start, end = s == range.end.span ? (int)range.end.offset : text_length);
                    if (x < nodewidth) {
                        return new LogSelPos(s, metrics.calcOffset(component, start, x));
                    }
                    x -= nodewidth;
                }
                ++s;
            }
            return severe ? null : range.end;
        }
        if (severe) {
            return null;
        }
        return this.lines[this.lines.length - 1].getEndPos();
    }

    public void draw(Graphics g, int to_y, int lnum, LogSelectionRange range, int hover_span) {
        PackedLineReader tsi = new PackedLineReader(this.block, lnum, this.sid, "base");
        int span_count = -1;
        int it = 0;
        while (it < this.lines.length) {
            LogLineInfo line = this.lines[it];
            int x = line.x;
            LogSelPos line_start = line.getStartPos();
            LogSelPos line_end = line.getEndPos();
            while (span_count < line_start.span) {
                tsi.readSpan();
                ++span_count;
            }
            while (true) {
                int se;
                int ss;
                int end;
                SpanMetrics metrics = new SpanMetrics(tsi, this.sid);
                int isHover = hover_span == span_count ? 1 : 0;
                int start = span_count == line_start.span ? line_start.offset : 0;
                int n = end = span_count == line_end.span ? line_end.offset : metrics.length;
                int n2 = range.start.span < span_count ? start : (range.start.span > span_count ? end : (range.start.offset < start ? start : (ss = range.start.offset > end ? end : (int)range.start.offset)));
                int n3 = range.end.span < span_count ? start : (range.end.span > span_count ? end : (range.end.offset < start ? start : (se = range.end.offset > end ? end : (int)range.end.offset)));
                if (start < ss) {
                    x += metrics.draw(g, x, to_y, line, start, ss, isHover, this.sid);
                    start = ss;
                }
                if (se < end) {
                    x += metrics.draw(g, x, to_y, line, start, se, 2, this.sid);
                    x += metrics.draw(g, x, to_y, line, se, end, isHover, this.sid);
                } else {
                    boolean isSelect;
                    boolean bl = isSelect = ss < se;
                    if (start < end) {
                        x += metrics.draw(g, x, to_y, line, start, end, isSelect ? 2 : isHover, this.sid);
                    }
                }
                if (span_count == line_end.span) break;
                tsi.readSpan();
                ++span_count;
            }
            ++it;
            to_y += line.height;
        }
    }
}

