/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.MyStreamTokenizer;
import base.Util;
import bluntirc.App;
import bluntirc.FontInfoClickable;
import buffer.StyleID;
import gui.BGInfo;
import gui.Color4;
import gui.FontInfo;
import gui.FontInfo2;
import gui.SystemColorLookUpTable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;

public class StyleManager
extends StyleID {
    public static Color[] color_ary = new Color[]{new Color(255, 255, 255), new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(255, 0, 0), new Color(128, 0, 0), new Color(128, 0, 128), new Color(255, 128, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 128, 128), new Color(0, 255, 255), new Color(0, 0, 255), new Color(255, 0, 255), new Color(128, 128, 128), new Color(192, 192, 192)};
    HashMap config = new HashMap();
    private BGInfo def_bg = new BGInfo(SystemColor.window, null);
    private FontInfo2 def_text = new FontInfo2(Color.black, null, Color.white, "Dialog", 0, 12);
    public static final char QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';

    public FontInfo2 findBaseStyle(String name) {
        return this.findTextStyle(name);
    }

    public Color4 findCTCPColor(int fg, int bg) {
        if (bg != -1) {
            return new Color4(color_ary[fg], color_ary[bg]);
        }
        return new Color4(color_ary[fg]);
    }

    public StyleManager() {
        FontInfo2.setDefaultStyle(this.def_text);
    }

    public BGInfo findBGInfo(String key) {
        Object o = this.config.get(key);
        if (o instanceof BGInfo) {
            return (BGInfo)o;
        }
        App.logger.finest("findBGInfo:" + key + " \u306f" + (o != null ? "BGInfo\u3067\u306f\u306a\u3044" : "\u898b\u3064\u304b\u3089\u306a\u3044"));
        return this.def_bg;
    }

    public FontInfo2 findTextStyle(String key) {
        Object o = this.config.get(key);
        if (o instanceof FontInfo2) {
            FontInfo2 fi = (FontInfo2)o;
            return (FontInfo2)o;
        }
        App.logger.finest("findTextStyle:" + key + " \u306f" + (o != null ? "TextStyle\u3067\u306f\u306a\u3044" : "\u898b\u3064\u304b\u3089\u306a\u3044"));
        return this.def_text;
    }

    public FontInfo findFontInfo(String key) {
        FontInfo2 src = this.findTextStyle(key);
        FontInfo f = new FontInfo(src.color.fg, src.color.bg, src.color.fg2, new Font(src.getFontName(), src.getFontStyle() & 3, src.getFontSize()));
        f.bg2 = src.color.bg2;
        return f;
    }

    public static Color readColor(String cname) throws ParseException {
        if (cname == null || cname.length() == 0 || "-".equals(cname)) {
            return null;
        }
        if (cname.charAt(0) != '#') {
            if (!SystemColorLookUpTable.find(cname)) {
                throw new ParseException("\u8272\u6307\u5b9a" + cname + "\u306f\u672a\u5b9a\u7fa9\u3067\u3059", 0);
            }
            return SystemColorLookUpTable.result;
        }
        int[] ir = new int[6];
        if (cname.length() != 7 || -1 == (ir[0] = Character.digit(cname.charAt(1), 16)) || -1 == (ir[1] = Character.digit(cname.charAt(2), 16)) || -1 == (ir[2] = Character.digit(cname.charAt(3), 16)) || -1 == (ir[3] = Character.digit(cname.charAt(4), 16)) || -1 == (ir[4] = Character.digit(cname.charAt(5), 16)) || -1 == (ir[5] = Character.digit(cname.charAt(6), 16))) {
            throw new ParseException("\u8272\u6307\u5b9a" + cname + "\u304c#HHHHHH\u306e\u5f62\u5f0f\u3067\u306f\u306a\u3044", 0);
        }
        return new Color((float)(ir[0] * 16 + ir[1]) / 255.0f, (float)(ir[2] * 16 + ir[3]) / 255.0f, (float)(ir[4] * 16 + ir[5]) / 255.0f);
    }

    public static void setStyleBit(FontInfo2 fi, String value, int mask) throws ParseException {
        if (value == null) {
            return;
        }
        if ((value = value.toLowerCase()).equals("1")) {
            fi.setStyleBit(mask, 0, 1);
        } else if (value.equals("0")) {
            fi.setStyleBit(mask, 0, 0);
        } else if (value.equals("on")) {
            fi.setStyleBit(mask, 0, 1);
        } else if (value.equals("off")) {
            fi.setStyleBit(mask, 0, 0);
        } else if (value.equals("inherit")) {
            fi.setStyleBit(mask, 1, 0);
        } else if (value.equals("xor")) {
            fi.setStyleBit(mask, 1, 1);
        } else {
            throw new ParseException("\u30b9\u30bf\u30a4\u30eb\u6307\u5b9a\u306e\u5024" + value + "\u304c\u304a\u304b\u3057\u3044", 0);
        }
    }

    static Integer toInteger(String s) {
        if (s == null || s.length() == 0) {
            return new Integer(0);
        }
        return new Integer(s);
    }

    static void readStyleOption(FontInfoClickable fi, MyStreamTokenizer in) throws IOException, ParseException {
        if (fi.color.bg2 == null) {
            fi.color.bg2 = fi.color.fg;
        }
        Iterator it = in.readOptions("\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a", true).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            if (me.getKey().equals("clickaction")) {
                fi.click_action = (String)me.getValue();
                continue;
            }
            if (me.getKey().equals("nohover")) {
                fi.nohover = null != me.getValue();
                continue;
            }
            if (me.getKey().equals("bold")) {
                StyleManager.setStyleBit(fi, (String)me.getValue(), 1);
                continue;
            }
            if (me.getKey().equals("italic")) {
                StyleManager.setStyleBit(fi, (String)me.getValue(), 2);
                continue;
            }
            if (me.getKey().equals("underline")) {
                StyleManager.setStyleBit(fi, (String)me.getValue(), 4);
                continue;
            }
            if (me.getKey().equals("reverse")) {
                StyleManager.setStyleBit(fi, (String)me.getValue(), 8);
                continue;
            }
            if (me.getKey().equals("strike")) {
                StyleManager.setStyleBit(fi, (String)me.getValue(), 16);
                continue;
            }
            if (me.getKey().equals("popupmenu")) {
                fi.popup_name = (String)me.getValue();
                continue;
            }
            if (me.getKey().equals("ascent_plus")) {
                fi.ascent_plus = StyleManager.toInteger((String)me.getValue());
                continue;
            }
            if (me.getKey().equals("descent_plus")) {
                fi.descent_plus = StyleManager.toInteger((String)me.getValue());
                continue;
            }
            if (me.getKey().equals("leading_plus")) {
                fi.leading_plus = StyleManager.toInteger((String)me.getValue());
                continue;
            }
            if (me.getKey().equals("cursor")) {
                String value = ((String)me.getValue()).toLowerCase();
                if (value.equals("crosshair")) {
                    fi.cursor = new Cursor(1);
                    continue;
                }
                if (value.equals("default")) {
                    fi.cursor = new Cursor(0);
                    continue;
                }
                if (value.equals("e_resize")) {
                    fi.cursor = new Cursor(11);
                    continue;
                }
                if (value.equals("hand")) {
                    fi.cursor = new Cursor(12);
                    continue;
                }
                if (value.equals("move")) {
                    fi.cursor = new Cursor(13);
                    continue;
                }
                if (value.equals("n_resize")) {
                    fi.cursor = new Cursor(8);
                    continue;
                }
                if (value.equals("ne_resize")) {
                    fi.cursor = new Cursor(7);
                    continue;
                }
                if (value.equals("nw_resize")) {
                    fi.cursor = new Cursor(6);
                    continue;
                }
                if (value.equals("s_resize")) {
                    fi.cursor = new Cursor(9);
                    continue;
                }
                if (value.equals("se_resize")) {
                    fi.cursor = new Cursor(5);
                    continue;
                }
                if (value.equals("sw_resize")) {
                    fi.cursor = new Cursor(4);
                    continue;
                }
                if (value.equals("text")) {
                    fi.cursor = new Cursor(2);
                    continue;
                }
                if (value.equals("w_resize")) {
                    fi.cursor = new Cursor(10);
                    continue;
                }
                if (value.equals("wait")) {
                    fi.cursor = new Cursor(3);
                    continue;
                }
                throw new ParseException(fi.name + "\u306e\u30aa\u30d7\u30b7\u30e7\u30f3" + me.getKey() + "\u306e\u6307\u5b9a" + value + "\u306ftypo\u304b\u4f55\u304b\u3060\u3068\u601d\u3046", 0);
            }
            throw new ParseException(fi.name + "\u306e\u30aa\u30d7\u30b7\u30e7\u30f3" + me.getKey() + "\u306ftypo\u304b\u4f55\u304b\u3060\u3068\u601d\u3046", 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HashMap readStream(Reader a_in, String fname) throws IOException {
        MyStreamTokenizer in = new MyStreamTokenizer(a_in, fname, false);
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean hasError = false;
        while (true) {
            try {
                while (true) {
                    FontInfoClickable fi;
                    String keyname;
                    in.skipToStartOfStatement();
                    if (in.ttype == -1) break;
                    String type = in.readWord("ColorFont\u304bBGInfo\u304bTextStyle");
                    if (type.equals("ColorFont")) {
                        keyname = in.readWordOrQuote("ColorFont\u306e\u6b21\u306e\u30ad\u30fc\u540d");
                        fi = new FontInfoClickable(keyname);
                        fi.color = new Color4();
                        fi.color.fg = StyleManager.readColor(in.readQuote("\u6587\u5b57\u8272"));
                        fi.color.bg = StyleManager.readColor(in.readQuote("\u80cc\u666f\u8272"));
                        fi.color.fg2 = StyleManager.readColor(in.readQuote("\u9078\u629e\u6642\u6587\u5b57\u8272"));
                        fi.color.bg2 = StyleManager.readColor(in.readQuote("\u9078\u629e\u6642\u80cc\u666f\u8272"));
                        fi.font_size = (int)in.readNumber("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba");
                        fi.font_name = in.readQuote("\u30d5\u30a9\u30f3\u30c8\u540d");
                        StyleManager.readStyleOption(fi, in);
                        result.put(keyname, fi);
                        continue;
                    }
                    if (type.equals("BGInfo")) {
                        keyname = in.readWordOrQuote("BGInfo\u306e\u6b21\u306e\u30ad\u30fc\u540d");
                        Color bg = StyleManager.readColor(in.readQuote("\u80cc\u666f\u8272"));
                        String bgfile = in.readQuote("\u80cc\u666f\u753b\u50cf");
                        ImageIcon i = null;
                        if (bgfile != null && bgfile.length() != 0 && !bgfile.equals("-")) {
                            i = Util.GetImageIconFromJAR(bgfile);
                        }
                        result.put(keyname, new BGInfo(bg, i));
                        continue;
                    }
                    if (!type.equals("TextStyle")) throw in.nomatch("\u7a2e\u985e" + type + "\u306fColorFont\u3067\u3082BGInfo\u3067\u3082TextStyle\u3067\u3082\u306a\u3044");
                    keyname = in.readWordOrQuote("TextStyle\u306e\u6b21\u306e\u30ad\u30fc\u540d");
                    fi = new FontInfoClickable(keyname);
                    fi.color = new Color4();
                    fi.font_name = in.readQuote("\u30d5\u30a9\u30f3\u30c8\u540d");
                    fi.font_size = (int)in.readNumber("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba");
                    fi.color.fg = StyleManager.readColor(in.readQuote("\u6587\u5b57\u8272"));
                    fi.color.bg = StyleManager.readColor(in.readQuote("\u80cc\u666f\u8272"));
                    fi.color.fg2 = StyleManager.readColor(in.readQuote("\u9078\u629e\u6642\u6587\u5b57\u8272"));
                    fi.color.bg2 = StyleManager.readColor(in.readQuote("\u9078\u629e\u6642\u80cc\u666f\u8272"));
                    StyleManager.readStyleOption(fi, in);
                    result.put(keyname, fi);
                }
            }
            catch (ParseException e) {
                hasError = true;
                App.Log(in.fname + " " + in.lineno() + "\u884c: " + e.getMessage());
                in.skipToEndOfStatement();
                continue;
            }
            break;
        }
        if (hasError) {
            return null;
        }
        HashMap<String, Object> hashMap = result;
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(String fname) {
        try {
            InputStreamReader in = new InputStreamReader(Util.OpenFile(fname), "UTF-8");
            try {
                HashMap a = StyleManager.readStream(in, fname);
                if (a == null) return false;
                this.config = a;
                App.Log(fname + "\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                super.clear();
                boolean bl = true;
                return bl;
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            App.Log(e.getMessage());
            return false;
        }
        catch (IOException e) {
            App.Log(fname + ":" + e.getMessage());
        }
        return false;
    }
}

