/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.EscapeReader;
import base.MyURL;
import base.Util;
import bluntirc.App;
import bluntirc.WinLF;
import bluntirc.djava.HookManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;

public class OSDependence
implements ClipboardOwner {
    public static Logger logger = Logger.getLogger("bluntirc.osdependence");
    TreeInterpreter ti;
    private LookAndFeel win_lf;
    private String old_lf = "?";

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void Copy(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            App.main_window.getToolkit().getSystemClipboard().setContents(new StringSelection(s), this);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "clipboard-copy is failed", e);
        }
    }

    public boolean canGetClipboardText() {
        try {
            App app = App.getApp();
            if (app != null && App.main_window != null) {
                Transferable t = App.main_window.getToolkit().getSystemClipboard().getContents(app);
                return t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
        }
        catch (Throwable e) {
            App.Log("canGetClipboardText" + e.toString());
            logger.log(Level.WARNING, "canGetClipboardText", e);
        }
        return false;
    }

    public String getClipboardText() {
        try {
            Transferable t;
            App app = App.getApp();
            if (app != null && App.main_window != null && (t = App.main_window.getToolkit().getSystemClipboard().getContents(app)) != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Throwable e) {
            App.Log("getClipboardText " + e.toString());
            logger.log(Level.WARNING, "getClipboardText", e);
        }
        return null;
    }

    public String[] parsecmd(String desc, String cmdline, String target) {
        boolean hasError;
        Vector<String> v;
        boolean foundTargetMacro;
        block16: {
            if (cmdline == null || cmdline.length() == 0) {
                if (desc != null) {
                    App.Log(desc + "\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                }
                return null;
            }
            foundTargetMacro = false;
            StreamTokenizer in = new StreamTokenizer(new StringReader(cmdline));
            in.resetSyntax();
            in.whitespaceChars(0, 32);
            in.wordChars(33, 33);
            in.quoteChar(34);
            in.wordChars(35, 38);
            in.quoteChar(39);
            in.wordChars(40, 126);
            v = new Vector<String>();
            hasError = false;
            try {
                while (true) {
                    switch (in.nextToken()) {
                        case 10: {
                            break block16;
                        }
                        case -1: {
                            break block16;
                        }
                        case -3: 
                        case 34: 
                        case 39: {
                            String arg = in.sval;
                            if (-1 != arg.indexOf("${target}")) {
                                foundTargetMacro = true;
                                arg = arg.replaceAll("\\$\\{target\\}", target);
                            }
                            App.logger.finer("Command param[" + v.size() + "]=" + arg);
                            v.add(arg);
                            break;
                        }
                        default: {
                            App.logger.warning("Command has bad token " + (char)in.ttype + " num=" + Integer.toHexString(in.ttype));
                            hasError = true;
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                if (desc != null) {
                    App.Log(desc + "\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + e);
                }
                return null;
            }
        }
        if (v.size() == 0 || hasError) {
            if (desc != null) {
                App.Log(desc + "\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            return null;
        }
        if (!foundTargetMacro) {
            v.add(target);
        }
        String[] cmdarray = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            cmdarray[i] = (String)v.get(i);
        }
        return cmdarray;
    }

    public boolean openURL(String desc, String cmdline, String url) {
        if (url == null) {
            App.Log("\u51e6\u7406\u3059\u308bURL\u3092\u53d6\u5f97\u3067\u304d\u306a\u3044");
            return false;
        }
        Iterator it = Util.URISplitter(url).iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof MyURL)) continue;
            if (App.root_property.getBoolean("UseMRJToOpenURL", false)) {
                String script = "com.apple.mrj.MRJFileUtils.openURL(" + Util.qq(url) + ");";
                try {
                    if (this.ti == null) {
                        this.ti = new TreeInterpreter(new JavaCCParserFactory());
                        this.ti.setAccessible(true);
                    }
                    this.ti.interpret(new EscapeReader(new StringReader(script)), "mrj-open_url");
                    return true;
                }
                catch (Throwable e) {
                    HookManager.parseScriptError("mrj-open_url", e);
                    return false;
                }
            }
            String[] cmdarray = this.parsecmd(desc, cmdline, ((MyURL)o).toString());
            if (cmdarray == null) {
                return false;
            }
            try {
                Runtime.getRuntime().exec(cmdarray);
            }
            catch (IOException error) {
                App.Log("Runtime.getRuntime().exec :" + error.toString() + " " + error.getMessage());
                logger.log(Level.WARNING, "cmd=[" + cmdline + "] url=" + cmdarray[cmdarray.length - 1], error);
            }
        }
        return true;
    }

    public void editTextFile(File file) {
        String cmdline = App.root_property.getString("TextEditorPath");
        String[] cmdarray = this.parsecmd("TextEditorPath", cmdline, file.getAbsolutePath());
        if (cmdarray == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException error) {
            App.Log("Runtime.getRuntime().exec :" + error.toString() + " " + error.getMessage());
            logger.log(Level.WARNING, "cmd=[" + cmdline + "] arg=" + cmdarray[cmdarray.length - 1], error);
        }
    }

    public void openFolder(File file) {
        String cmdline = App.root_property.getString("FolderViewerPath");
        String[] cmdarray = this.parsecmd("FolderViewerPath", cmdline, file.getAbsolutePath());
        if (cmdarray == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException error) {
            App.Log("Runtime.getRuntime().exec :" + error.toString() + " " + error.getMessage());
            logger.log(Level.WARNING, "cmd=[" + cmdline + "] arg=" + cmdarray[cmdarray.length - 1], error);
        }
    }

    public boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.indexOf("Windows") != -1;
    }

    public void removeBorder(Component c) {
        if (c instanceof JSplitPane) {
            ((JSplitPane)c).setBorder(null);
            ((JComponent)((JSplitPane)c).getLeftComponent()).setBorder(null);
            ((JComponent)((JSplitPane)c).getRightComponent()).setBorder(null);
        }
        if (c instanceof JScrollPane) {
            ((JScrollPane)c).setBorder(null);
            ((JScrollPane)c).setOpaque(false);
            try {
                ((JScrollPane)c).setViewportBorder(null);
                ((JScrollPane)c).getViewport().setOpaque(false);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                ((JScrollPane)c).getColumnHeader().setOpaque(false);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (c instanceof Container) {
            int count = ((Container)c).getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.removeBorder(((Container)c).getComponent(i));
            }
        }
    }

    public void removeBorder(Window w) {
        Window[] list = w.getOwnedWindows();
        this.removeBorder((Component)w);
        for (int i = 0; i < list.length; ++i) {
            this.removeBorder(list[i]);
        }
    }

    public void updateUI(Color c, Window w) {
        w.setBackground(c);
        SwingUtilities.updateComponentTreeUI(w);
        Window[] list = w.getOwnedWindows();
        for (int i = 0; i < list.length; ++i) {
            this.updateUI(c, list[i]);
        }
    }

    public boolean setLF(String name) {
        try {
            if (!name.equals(this.old_lf)) {
                if (!this.isWindows() && name.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                    if (this.win_lf == null) {
                        this.win_lf = new WinLF();
                    }
                    UIManager.setLookAndFeel(this.win_lf);
                } else {
                    UIManager.setLookAndFeel(name);
                }
                App.logger.finer("setLF " + name);
                this.old_lf = name;
            }
            Color c = UIManager.getColor("control");
            Frame[] frames = Frame.getFrames();
            for (int i = 0; i < frames.length; ++i) {
                this.updateUI(c, frames[i]);
            }
            if (App.getApp() != null && App.main_window != null) {
                App.main_window.updateOpaque();
            }
            Frame[] frames2 = Frame.getFrames();
            for (int i = 0; i < frames2.length; ++i) {
                this.removeBorder(frames2[i]);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "setLookAndFeel failed (" + name + ")", e);
        }
        return false;
    }

    static {
        logger.setLevel(null);
    }
}

