/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.SelectorRun;
import base.Util;
import bdate.BuildDate;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ConnTreeNode;
import bluntirc.PrintFormat;
import bluntirc.PrintFormatMacro;
import bluntirc.PrintFormatToTextSpan;
import bluntirc.Servers;
import bluntirc.djava.HookManager;
import bluntirc.djava.ScriptItem;
import buffer.PackedLineWriter;
import hook.IRCMessageRewrite1;
import hook.IRCMessageRewrite2;
import irc.IRCChannel;
import irc.IRCChannelMember;
import irc.IRCConnection;
import irc.IRCConnectionListener;
import irc.IRCLogContext;
import irc.IRCMessage;
import irc.IRCUser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionListener
implements IRCConnectionListener {
    public static File logdir = new File("log");
    Pattern hostport_ipv6 = Pattern.compile("([^\\s;]+)\\s*;\\s*");
    Pattern hostport_ipv4 = Pattern.compile("([^\\s:]+)\\s*:\\s*");
    Pattern numeric_pattern = Pattern.compile("(\\d+)");
    Pattern range_pattern = Pattern.compile("(\\d+)\\D+(\\d+)");

    public SelectorRun getSelector() {
        return App.selector;
    }

    public IRCMessage rewriteIRCMessage1(IRCMessage m) {
        Iterator it = App.hook_manager.getHookList();
        while (it.hasNext()) {
            ScriptItem si = (ScriptItem)it.next();
            Object plugin = si.getPlugin();
            if (!(plugin instanceof IRCMessageRewrite1)) continue;
            try {
                if ((m = ((IRCMessageRewrite1)plugin).rewriteIRCMessage1(m)) != null) continue;
                break;
            }
            catch (Throwable e) {
                HookManager.parseScriptError(si.getName(), e);
            }
        }
        return m;
    }

    public IRCMessage rewriteIRCMessage2(IRCMessage m) {
        Iterator it = App.hook_manager.getHookList();
        while (it.hasNext()) {
            ScriptItem si = (ScriptItem)it.next();
            Object plugin = si.getPlugin();
            if (!(plugin instanceof IRCMessageRewrite2)) continue;
            try {
                if ((m = ((IRCMessageRewrite2)plugin).rewriteIRCMessage2(m)) != null) continue;
                break;
            }
            catch (Throwable e) {
                HookManager.parseScriptError(si.getName(), e);
            }
        }
        return m;
    }

    public TimeZone getTimeZone(IRCConnection conn) {
        Object o = ((CTN_Conn)conn.Extra).property.get("TimeZoneObject");
        if (o instanceof TimeZone) {
            return (TimeZone)o;
        }
        TimeZone tz = TimeZone.getTimeZone(((CTN_Conn)conn.Extra).property.setDefaultString("TimeZone", "JST"));
        ((CTN_Conn)conn.Extra).property.set("TimeZoneObject", (Object)tz);
        return tz;
    }

    static int rand(int size) {
        return (int)(Math.random() * (double)size);
    }

    public int getServerPort(IRCConnection conn, int connect_try_count) {
        Servers sv = (Servers)((CTN_Conn)conn.Extra).property.get("__Servers");
        return sv.ServerPort;
    }

    public String getServerHost(IRCConnection conn, int connect_try_count) {
        Servers sv;
        if (connect_try_count == 0) {
            sv = new Servers();
            ((CTN_Conn)conn.Extra).property.put("__Servers", (Object)sv);
            sv.servers = new Vector();
            sv.servers.add(new String[]{((CTN_Conn)conn.Extra).property.getString("Server"), "" + ((CTN_Conn)conn.Extra).property.setDefaultInt("Port", 6667)});
            String src = ((CTN_Conn)conn.Extra).property.setDefaultString("Server2", "");
            int lnum = 0;
            block0: for (int i = 0; i < src.length(); ++i) {
                int start = i;
                if ((i = src.indexOf(10, start)) == -1) {
                    i = src.length();
                }
                ++lnum;
                String line = src.substring(start, i).trim();
                if (line.length() == 0) continue;
                String[] hp = line.split(-1 != line.indexOf(59) ? ";" : ":", 2);
                if (hp.length < 2) {
                    App.Log("\u30b5\u30fc\u30d0\u6307\u5b9a2\u306e" + line + "\u306f host;port,port-port ... \u306e\u5f62\u5f0f\u306b\u30de\u30c3\u30c1\u3057\u306a\u3044(1)");
                    continue;
                }
                String host = hp[0].trim();
                String[] ports = hp[1].split(",");
                Vector<String> ports_tmp = new Vector<String>();
                for (int j = 0; j < ports.length; ++j) {
                    String s = ports[j].trim();
                    Matcher m = this.range_pattern.matcher(s);
                    if (m.matches()) {
                        ports_tmp.add(m.group(1) + "-" + m.group(2));
                        continue;
                    }
                    m = this.numeric_pattern.matcher(s);
                    if (m.matches()) {
                        ports_tmp.add(m.group(1));
                        continue;
                    }
                    App.Log("\u30b5\u30fc\u30d0\u6307\u5b9a2\u306e\u30dd\u30fc\u30c8\u90e8\u306e" + s + "\u306f port \u307e\u305f\u306f port-port \u306e\u5f62\u5f0f\u306b\u30de\u30c3\u30c1\u3057\u306a\u3044(2)");
                    continue block0;
                }
                if (ports_tmp.size() == 0) {
                    App.Log("\u30b5\u30fc\u30d0\u6307\u5b9a2\u306e" + line + "\u306b\u306f\u30dd\u30fc\u30c8\u756a\u53f7\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044");
                    continue;
                }
                String[] item = new String[ports_tmp.size() + 1];
                item[0] = host;
                for (int j = 1; j < item.length; ++j) {
                    item[j] = (String)ports_tmp.get(j - 1);
                }
                sv.servers.add(item);
            }
        } else {
            sv = (Servers)((CTN_Conn)conn.Extra).property.get("__Servers");
        }
        String[] item = (String[])sv.servers.get(connect_try_count % sv.servers.size());
        String host = item[0];
        String port = item[1 + ConnectionListener.rand(item.length - 1)];
        int d = port.indexOf(45);
        if (d != -1) {
            int last;
            int first = Integer.parseInt(port.substring(0, d));
            if (first > (last = Integer.parseInt(port.substring(d + 1)))) {
                int tmp = last;
                last = first;
                first = tmp;
            }
            sv.ServerPort = first + ConnectionListener.rand(first - last);
        } else {
            sv.ServerPort = Integer.parseInt(port);
        }
        return host;
    }

    public int getSoTimeout(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultInt("SoTimeout", 0);
    }

    public String getLocalHost(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultString("SourceHost", "");
    }

    public int getLocalPort(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultInt("SourcePort", 0);
    }

    public String getNickName(IRCConnection conn, boolean isFirst) {
        return ((CTN_Conn)conn.Extra).getNickName(isFirst);
    }

    public String getPassword(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("Password");
    }

    public String getUserName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("UserName");
    }

    public String getRealName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.getString("RealName");
    }

    public String getMyUserMode(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("UserMode", "");
    }

    public String getConnectionName(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).getName();
    }

    public static String system_property(String key) {
        return key + "=" + System.getProperty(key) + " ";
    }

    public String getCTCPReplyVersion(IRCMessage m) {
        return App.config_AppName + " http://tate.undef.jp/pub/BluntIRC/BluntIRC.html " + ":build " + BuildDate.getVersion() + ":" + ConnectionListener.system_property("java.runtime.name") + ConnectionListener.system_property("java.runtime.version") + ConnectionListener.system_property("os.arch") + ConnectionListener.system_property("os.name") + ConnectionListener.system_property("os.version") + ConnectionListener.system_property("sun.os.patch.level") + ConnectionListener.system_property("user.language") + ConnectionListener.system_property("sun.arch.data.model");
    }

    public String getCTCPReplyFinger(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyFinger", "\u8a2d\u5b9a\u306a\u3057");
    }

    public String getCTCPReplyUserInfo(IRCMessage m) {
        return ((CTN_Conn)m.conn.Extra).property.setDefaultString("CTCPReplyUserInfo", "\u8a2d\u5b9a\u306a\u3057");
    }

    public boolean isAutoReconnect(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("AutoReconnect", false);
    }

    public boolean isDumpRecvLine(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvLine", false);
    }

    public boolean isDumpRecvCTCP(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("dumpRecvCTCP", true);
    }

    public boolean isDontParseCTCP(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("DontParseCTCP", false);
    }

    public boolean isQuoteAllParam(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteAllParam", false);
    }

    public boolean isQuoteSpace(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpace", false);
    }

    public boolean isQuoteSpaceAtCTCPArg(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("QuoteSpaceAtCTCPArg", false);
    }

    public boolean isQuote001(IRCConnection conn) {
        return ((CTN_Conn)conn.Extra).property.setDefaultBoolean("Quote001", true);
    }

    public void onChannelKicked(IRCMessage m) {
        CTN_Chan node = (CTN_Chan)((IRCChannel)m.target.get((int)0)).Extra;
        if (node.property.setDefaultBoolean("RejoinOnKicked", false)) {
            node.OnMenuJoin();
        }
    }

    public int getCTCPSendCueTimeExpire(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("SendCueTimeExpire", 60);
    }

    public int getCTCPSendCueLimitInTime(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueLimitInTime", 20);
    }

    public int getCTCPSendCueMaxInLine(IRCConnection c) {
        return ((CTN_Conn)c.Extra).property.setDefaultInt("CTCPSendCueMaxInLine", 4);
    }

    public void OnLogEvent(IRCMessage m) {
        if (m.target.size() == 0) {
            m.addContext(m.conn);
        }
        int t = m.target.size();
        Object main_context = null;
        for (int i = 0; i < t; ++i) {
            Object to = m.target.get(i);
            if (to instanceof IRCConnection) {
                if (main_context == null) {
                    main_context = ((IRCConnection)to).Extra;
                }
                this.OnLogEvent(m, to, IRCLogContext.LB_Conn, main_context);
                this.OnLogEvent(m, to, IRCLogContext.LF_Conn, main_context);
                continue;
            }
            if (!(to instanceof IRCChannel)) continue;
            IRCChannel chan = (IRCChannel)to;
            if (main_context == null) {
                main_context = ((IRCChannel)to).Extra;
            }
            if (chan.isChannel()) {
                this.OnLogEvent(m, to, IRCLogContext.LB_Chan, main_context);
                this.OnLogEvent(m, to, IRCLogContext.LF_Chan, main_context);
                continue;
            }
            this.OnLogEvent(m, to, IRCLogContext.LB_Priv, main_context);
            this.OnLogEvent(m, to, IRCLogContext.LF_Priv, main_context);
        }
        Object to = m.target.get(0);
        this.OnLogEvent(m, to, IRCLogContext.LB_Dump, main_context);
        this.OnLogEvent(m, to, IRCLogContext.LF_Dump, main_context);
        this.OnLogEvent(m, to, IRCLogContext.LB_All, main_context);
    }

    public void OnLogEvent(IRCMessage m, Object to, IRCLogContext buffer_id, Object main_context) {
        PrintFormat pf;
        String fname = null;
        if (buffer_id.isLogFile()) {
            if (logdir == null) {
                return;
            }
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "LogFileName");
            if (pf == null) {
                App.Log("PrintFormat.conf \u306e\u300c" + buffer_id.toString() + "\u300d\u306bLogFileName\u306e\u6307\u5b9a\u304c\u306a\u3044");
                return;
            }
            fname = PrintFormatToTextSpan.getText(m, to, pf, false);
            if (fname == null) {
                return;
            }
        }
        if ((pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), m.cmd)) == null && 0 == m.cmd.indexOf("On")) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "OnOther");
        }
        if (pf == null && 0 == m.cmd.indexOf("CTCP")) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "OtherCTCP");
        }
        if (pf == null) {
            pf = App.pfm_manager.findPrintFormat(buffer_id.toString(), "other");
        }
        if (pf == null) {
            pf = new PrintFormat();
            pf.macro.add("!");
            pf.macro.add(PrintFormatMacro.getNormalName(m.log_from));
            pf.macro.add(" ");
            pf.macro.add(m.cmd);
            pf.macro.add(" ");
            pf.macro.add(m.params_str);
        }
        if (!buffer_id.isLogFile()) {
            PackedLineWriter line = PrintFormatToTextSpan.getTextLine(m, to, pf, true, App.style_manager);
            if (line != null) {
                if (buffer_id == IRCLogContext.LB_All) {
                    ConnTreeNode node;
                    if (App.root_property.getBoolean("AllLog_ChocoaStingy", false) && (node = App.getSelected()) != null) {
                        if (to instanceof IRCConnection && node instanceof CTN_Conn && ((CTN_Conn)node).conn == to) {
                            return;
                        }
                        if (to instanceof IRCChannel && node instanceof CTN_Chan && ((CTN_Chan)node).chan == to) {
                            return;
                        }
                        if (to instanceof IRCChannel && node instanceof CTN_Priv && ((CTN_Priv)node).chan == to) {
                            return;
                        }
                    }
                    App.getApp();
                    App.log_all.doc.addText(App.main_window, line, main_context);
                } else if (buffer_id == IRCLogContext.LB_Dump) {
                    App.getApp().addMidoku(line, main_context);
                } else if (buffer_id == IRCLogContext.LB_Conn) {
                    ((CTN_Conn)m.conn.Extra).addMidoku(line, main_context);
                } else if (buffer_id == IRCLogContext.LB_Chan) {
                    ((CTN_Chan)((IRCChannel)to).Extra).addMidoku(line, pf.NoCountMidoku);
                } else if (buffer_id == IRCLogContext.LB_Priv) {
                    ((CTN_Priv)((IRCChannel)to).Extra).addMidoku(line, pf.NoCountMidoku);
                }
            }
            return;
        }
        fname = Util.EscapeForFile(fname);
        String line = PrintFormatToTextSpan.getText(m, to, pf, true);
        if (line == null) {
            return;
        }
        File f = logdir;
        try {
            f = new File(f, fname);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = new File(f, m.getDateStr() + "." + App.root_property.getString("LogFileEncoding") + ".txt");
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ba.write(line.getBytes(App.root_property.getString("LogFileEncoding")));
            if (App.root_property.getBoolean("LogCRLF", false)) {
                ba.write(13);
            }
            ba.write(10);
            App.delay_log.add(f, ba.toByteArray());
        }
        catch (Throwable e) {
            App.Log(f.getAbsolutePath() + "\u3078\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u305f" + e.toString());
            logdir = null;
        }
    }

    public void OnConnectRequest(IRCConnection conn) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void OnConnectAuthorized(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void OnConnectMOTDEnd(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        String mode = m.conn.getListener().getMyUserMode(m);
        if (mode != null) {
            LinkedList<Object> v = new LinkedList<Object>();
            v.add("MODE");
            v.add(m.conn.myself.getNickBytes());
            v.add(mode);
            m.conn.SendToServer(v);
        }
        Iterator it = connNode.getChannelNodes().iterator();
        while (it.hasNext()) {
            CTN_Chan node = (CTN_Chan)it.next();
            node.checkAutoJoin();
        }
    }

    public void OnDisconnect(IRCConnection conn) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.redrawTreeView(connNode);
    }

    public void initIRCChannel(IRCConnection conn, IRCChannel chan) {
        if (chan.Extra == null) {
            chan.Extra = chan.isChannel() ? CTN_Chan.createByInitIRCChannel((CTN_Conn)conn.Extra, chan) : CTN_Priv.createByInitIRCChannel((CTN_Conn)conn.Extra, chan);
        }
    }

    public void RemoveChannel(IRCConnection conn, IRCChannel chan) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        App.logger.warning("CTN_Conn.RemoveChannel");
    }

    public void ChangeChannelJoin(IRCConnection conn, IRCChannel c, boolean is_in) {
        CTN_Conn connNode = (CTN_Conn)conn.Extra;
        this.initIRCChannel(conn, c);
        CTN_Chan node = (CTN_Chan)c.Extra;
        App.redrawTreeView(node);
        if (!is_in) {
            if (c.isChannel()) {
                c.setChannelModeString("-");
            }
        } else if (c.isChannel()) {
            LinkedList<Object> v;
            if (node.property.getBoolean("AutoWho", true)) {
                v = new LinkedList<Object>();
                v.add("WHO");
                v.add(c.getCName().getRawBytes());
                conn.SendToServer(v);
            }
            if (node.property.getBoolean("AutoModeQuery", true)) {
                v = new LinkedList();
                v.add("MODE");
                v.add(c.getCName().getRawBytes());
                conn.SendToServer(v);
            }
        }
        if (App.getSelected() == connNode) {
            App.getApp().updateTopic();
        }
        App.redrawTreeView(connNode);
    }

    public void SetChannelMode(IRCMessage m, IRCChannel c) {
        App.getApp().updateTopic();
    }

    public void ChangeNickMyself(IRCMessage m) {
        CTN_Conn connNode = (CTN_Conn)m.conn.Extra;
        App.getApp().updateTopic();
    }

    public void ChangeUserInfo(IRCConnection conn, IRCChannel c, byte[] fromNick, IRCChannelMember to) {
        this.initIRCChannel(conn, c);
        if (c.isChannel()) {
            ((CTN_Chan)c.Extra).userlist.ChangeUserInfo(fromNick, to);
        } else {
            App.updateBufferListItem((CTN_Priv)c.Extra);
        }
    }

    public void RemoveUserList(IRCConnection conn, IRCChannel c, IRCChannelMember who) {
        this.initIRCChannel(conn, c);
        ((CTN_Chan)c.Extra).userlist.RemoveUserList(who);
        if (App.getSelected() == c.Extra) {
            App.getApp().updateTopic();
        }
    }

    public void OnWhoReply(IRCMessage m, IRCChannel c, IRCUser who) {
        if (c != null) {
            this.initIRCChannel(m.conn, c);
            ((CTN_Chan)c.Extra).userlist.setWhoReply(who);
        }
    }

    public void onChangePrefix(IRCConnection conn, IRCUser who, int type) {
        CTN_Chan node = App.getSelectedChannel();
        if (node != null) {
            node.userlist.setWhoReply(who);
        }
        if (type >= 2) {
            App.Log(who.getPrefixStr() + " \u306eprefix\u306f\u4eca\u307e\u3067\u3068\u7570\u306a\u308a\u307e\u3059 " + type);
        }
    }

    public void ChangeTopic(IRCMessage m, IRCChannel c) {
        if (App.getSelectedChannel() == c.Extra) {
            App.getApp().updateTopic();
        }
    }

    public void checkCTCPPingReply(IRCMessage ctcp) {
        try {
            long old_time = Long.parseLong(ctcp.log_msg, 10);
            long now = ctcp.time.getTime().getTime();
            long diff = now - old_time;
            if (diff >= 0L) {
                String low = Long.toString(diff % 1000L + 1000L);
                String s = Long.toString(diff / 1000L) + "." + low.substring(low.length() - 3);
                ctcp.log_msg = ctcp.from.getShortName() + " \u306e\u30e9\u30b0\u30bf\u30a4\u30e0\u306f " + s + " \u79d2\u3067\u3059\u3002";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void invokeLater(int second, Runnable method) {
        App.addDelayProc(second, method);
    }
}

