/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import base.Util;
import bluntirc.App;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ChannelMemberList;
import bluntirc.PropertyManager;
import buffer.LogDocument;
import buffer.PackedLineWriter;
import irc.IRCChannel;
import irc.IRCConnection;
import irc.IRCMessage;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public abstract class ConnTreeNode
implements Comparable {
    protected ConnTreeNode parent;
    protected LinkedList child = new LinkedList();
    LogDocument doc;
    public PropertyManager property = new PropertyManager(this);
    public static int sort_type;
    public int order_in_list;
    static String[] TypeStr;

    public final ConnTreeNode getParent() {
        return this.parent;
    }

    public final Iterator getChilds() {
        return ((LinkedList)this.child.clone()).iterator();
    }

    public final int getChildCount() {
        return this.child.size();
    }

    public final void insertNodeInto(ConnTreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        node.parent = this;
        this.child.addFirst(node);
        App.buf_list.addItem(node, this, App.root_property.setDefaultBoolean("ActivateBufferOnCreate", false));
    }

    public final void removeChildAll() {
        Iterator it = this.getChilds();
        while (it.hasNext()) {
            this.removeNode((ConnTreeNode)it.next());
        }
    }

    public final void removeNode(ConnTreeNode node) {
        node.removeChildAll();
        node.PreRemove();
        node.parent = null;
        this.child.remove(node);
        App.buf_list.removeItem(node);
    }

    ConnTreeNode(LogDocument doc) {
        if (doc == null) {
            doc = new LogDocument(App.style_manager);
        }
        this.doc = doc;
    }

    public LogDocument getLogDocument() {
        return this.doc;
    }

    public void addMidoku(PackedLineWriter tsi, Object main_context) {
        this.doc.addText(App.main_window, tsi, main_context);
        if (App.getSelected() == this) {
            App.getApp().updateTopic();
        }
    }

    public String getBufferInfo() {
        return Integer.toString(this.getLogDocument().getLineCount()) + "\u884c";
    }

    public abstract Object getPropertyExtra();

    public ChannelMemberList getUserList() {
        return null;
    }

    public CTN_Conn getConnNode() {
        return null;
    }

    public CTN_Chan getChannelNode() {
        return null;
    }

    public CTN_Priv getPrivNode() {
        return null;
    }

    public abstract String getTitle();

    public abstract String getPopupName();

    public String GetCaption() {
        return "ConnTreeNode";
    }

    public ImageIcon getImageIcon() {
        return App.icon_app;
    }

    public abstract int getListLevel();

    public int getListOffset() {
        CTN_Conn cn = this.getConnNode();
        return cn == null || cn == this ? 0 : 1;
    }

    public String getListLabel1() {
        return this.GetCaption();
    }

    public String getListLabel2() {
        CTN_Conn cn = this.getConnNode();
        return cn == null || cn == this ? "" : cn.GetCaption();
    }

    public int getOrderInList() {
        return this.property.getInt("order_in_list", 0);
    }

    public int compareTo(Object o) {
        ConnTreeNode b = (ConnTreeNode)o;
        if (sort_type == 1) {
            return this.getOrderInList() - b.getOrderInList();
        }
        return this.getSortString().compareTo(b.getSortString());
    }

    private String getSortString() {
        CTN_Conn l1 = this.getConnNode();
        if (l1 == null) {
            return "";
        }
        ConnTreeNode l2 = this.getChannelNode();
        if (l2 != null) {
            return ((ConnTreeNode)l1).GetCaption() + "\n\n" + l2.GetCaption();
        }
        l2 = this.getPrivNode();
        if (l2 != null) {
            return ((ConnTreeNode)l1).GetCaption() + "\n" + l2.GetCaption();
        }
        return ((ConnTreeNode)l1).GetCaption();
    }

    public void OnDoubleClick(MouseEvent e) {
    }

    public void OnMiddleClick(MouseEvent e) {
    }

    public void OnSelect() {
    }

    public void onClick(MouseEvent e) {
        if (0 != (e.getModifiers() & 0x10)) {
            if (e.getClickCount() > 1) {
                this.OnDoubleClick(e);
            }
        } else if (0 != (e.getModifiers() & 8)) {
            this.OnMiddleClick(e);
        }
    }

    public boolean SendFromUserInput(String a, int type) {
        IRCConnection conn = this.getConnNode().conn;
        if (conn == null) {
            return false;
        }
        IRCChannel to = null;
        if (this.getPropertyExtra() instanceof IRCChannel) {
            to = (IRCChannel)this.getPropertyExtra();
        }
        if (!conn.isConnected()) {
            return false;
        }
        for (int i = 0; i < a.length(); i += i < a.length() && a.charAt(i) == '\n' ? 1 : 0) {
            int start = i;
            while (i < a.length() && a.charAt(i) != '\n') {
                ++i;
            }
            if (i <= start) continue;
            if (a.charAt(start) == App.root_property.getString("CommandSlash").charAt(0)) {
                String cmd = a.substring(start + 1, i);
                if (App.action_manager.fireUserCommand(cmd)) continue;
                conn.SendToServer(IRCConnection.encodeUserCommand(cmd));
                continue;
            }
            Vector<byte[]> v = new Vector<byte[]>();
            if (type == 3) {
                v.add(Util.toJIS("ACTION"));
                v.add(Util.toJIS(a, start, i));
                conn.SendToServer(conn.encodeCTCP(to.getCName().getRawBytes(), v, "PRIVMSG"));
            } else {
                conn.SendToServer(conn.encodeUserTalk(TypeStr[type], to.getCName().getRawBytes(), Util.toJIS(a, start, i)));
            }
            if (type == 1) continue;
            IRCMessage m = new IRCMessage(conn, TypeStr[type], a.substring(start, i));
            if (type == 3) {
                m.cmd = "CTCP_ACTION";
            }
            if (!to.isChannel()) {
                m.cmd = m.cmd + "_u";
            }
            m.log_to = to;
            m.from = conn.myself;
            m.log_from = m.from;
            m.log_context = to;
            m.addContext(m.log_context);
            m.sendLogToListener();
        }
        return true;
    }

    public abstract void PreRemove();

    public abstract void onHashLoad();

    public abstract void onHashSave();

    public abstract void onPropertyChanged(String var1, Object var2);

    public abstract List getCreateParam();

    static {
        TypeStr = new String[]{"PRIVMSG", "TOPIC", "NOTICE", "PRIVMSG"};
    }
}

