/*
 * Decompiled with CFR 0.152.
 */
package bluntirc;

import action.BaseActions;
import base.ConvertChar;
import base.SelectorRun;
import base.Util;
import bdate.BuildDate;
import bluntirc.AllLogWindow;
import bluntirc.BufferList;
import bluntirc.CTN_Chan;
import bluntirc.CTN_Conn;
import bluntirc.CTN_Priv;
import bluntirc.ConnTreeNode;
import bluntirc.ConnectionListener;
import bluntirc.DelayLog;
import bluntirc.DelayProc;
import bluntirc.MainWindow;
import bluntirc.MenuConf;
import bluntirc.MyFormatter;
import bluntirc.OSDependence;
import bluntirc.PrintFormatMacroManager;
import bluntirc.PropertyManager;
import bluntirc.ScreenLogHandler;
import bluntirc.StyleManager;
import bluntirc.WindowPos;
import bluntirc.djava.ActionManager;
import bluntirc.djava.HookManager;
import bluntirc.djava.ScriptManagerCompiled;
import bluntirc.djava.ScriptManagerWindow;
import buffer.LogDocument;
import irc.IRCMessageReader;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class App
extends ConnTreeNode {
    public static Logger root_logger = Logger.getLogger("");
    public static FileHandler log_file_handler;
    public static ScreenLogHandler log_screen_handler;
    public static Logger logger;
    public static String config_AppName;
    public static String IniFileName;
    public static ImageIcon icon_app;
    public static base.Logger connection_logger;
    public static OSDependence os_dependence;
    public static SelectorRun selector;
    public static ConnectionListener conn_hook;
    public static PrintFormatMacroManager pfm_manager;
    public static StyleManager style_manager;
    public static MenuConf menu_conf;
    public static ActionManager action_manager;
    public static HookManager hook_manager;
    public static ScriptManagerCompiled compiled_scripts;
    public static BufferList buf_list;
    public static LogDocument console_doc;
    public static DelayLog delay_log;
    public static LinkedList delay_proc_list;
    public static MainWindow main_window;
    public static ScriptManagerWindow script_manager;
    public static AllLogWindow log_all;
    private static App application;
    public static PropertyManager root_property;
    private static Timer timer;
    private static volatile int timerState;
    String lastTitle = null;
    static Component pre_focus;
    static /* synthetic */ Class class$bluntirc$App;

    public String GetName() {
        return config_AppName;
    }

    public static App getApp() {
        return application;
    }

    public static void main(String[] args) {
        logger.info(config_AppName + " build " + BuildDate.getVersion());
        logger.info("CWD is " + new File("nonexistent").getAbsoluteFile().getParent());
        ScriptManagerWindow.loadDummyScript();
        Util.AppClassLoader = (class$bluntirc$App == null ? (class$bluntirc$App = App.class$("bluntirc.App")) : class$bluntirc$App).getClassLoader();
        try {
            ConvertChar.Setup();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "base.ConvertChar.Setup failed.", e);
            return;
        }
        IRCMessageReader.init();
        try {
            Security.setProperty("networkaddress.cache.ttl", "0");
            Security.setProperty("networkaddress.cache.negative.ttl", "0");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "cant set networkaddress.cache Property", e);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                icon_app = Util.GetImageIconFromJAR("images/app.gif");
                if (!style_manager.load("Style.conf")) {
                    return;
                }
                if (!pfm_manager.load("PrintFormat.conf")) {
                    return;
                }
                console_doc = new LogDocument(style_manager);
                new App().init();
            }
        });
        try {
            selector = new SelectorRun();
            selector.loop();
            logger.fine("socket selector closed.");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "selector\u306e\u99c6\u52d5\u306b\u5931\u6557", e);
        }
        log_file_handler.setLevel(Level.FINEST);
        log_screen_handler.setLevel(Level.FINEST);
        logger.log(Level.INFO, "main\u7d42\u4e86\u51e6\u7406\u958b\u59cb");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    App.getApp().removeChildAll();
                    delay_log.flushAll();
                }
            });
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "main\u7d42\u4e86\u51e6\u7406\u5931\u6557", e);
        }
        logger.log(Level.INFO, "System.runFinalization");
        System.runFinalization();
        logger.log(Level.INFO, "System.exit");
        System.exit(0);
    }

    public synchronized void MyWait(long t) {
        try {
            this.wait(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public App() {
        super(console_doc);
    }

    public void init() {
        while (selector == null) {
            this.MyWait(1000L);
        }
        try {
            application = this;
            this.setDefaultProperty();
            root_property = this.property;
            PropertyManager.preloadIniFile(App.getApp(), IniFileName);
            BaseActions.entry();
            menu_conf.load();
            log_all = new AllLogWindow(!root_property.getBoolean("AlloLogInMain", false));
            log_all.setSize(400, 300);
            main_window = new MainWindow();
            script_manager = new ScriptManagerWindow();
            WindowPos.setWindowsPosToCenter(main_window);
            WindowPos.setWindowsPosToCenter(script_manager);
            WindowPos.setWindowsPosToCenter(log_all);
            PropertyManager.load(App.getApp(), IniFileName);
            this.setDefaultProperty();
            buf_list.sortByOrder();
            buf_list.select(root_property.getInt("buf_list_last_select", 0));
            main_window.reloadBGInfoAll();
            Iterator it = root_property.getList("Scripts").iterator();
            while (it.hasNext()) {
                script_manager.loadInfo(PropertyManager.StringValue(it.next()));
            }
            compiled_scripts.setup();
            os_dependence.setLF(root_property.setDefaultString("LookAndFeel", UIManager.getSystemLookAndFeelClassName()));
            WindowPos.loadWindowPos(main_window, "WindowBounds_Main");
            WindowPos.loadWindowPos(script_manager, "WindowBounds_Scripts");
            WindowPos.loadWindowPos(log_all, "WindowBounds_AllLog");
            WindowPos.loadSplitterPos("ChannelAndUserSplitter", App.main_window.ChannelAndUserSplitter);
            WindowPos.loadSplitterPos("LRSplitter", App.main_window.LRSplitter);
            WindowPos.loadSplitterPos("AllLogSplitter", App.main_window.AllLogSplitter);
            WindowPos.loadTableColPos(App.main_window.user_view.table, "UserViewColmnWidth");
            if (null == root_property.get("WindowBounds_AllLog")) {
                log_all.show();
            }
            if (null == root_property.get("ChannelAndUserSplitter")) {
                int w = root_property.getBoolean("TopTree", false) ? (int)App.main_window.buflist_scroll.getPreferredSize().getWidth() : (int)((double)App.main_window.ChannelAndUserSplitter.getWidth() - App.main_window.buflist_scroll.getPreferredSize().getWidth());
                try {
                    App.main_window.ChannelAndUserSplitter.setDividerLocation(w);
                }
                catch (Throwable e) {
                    App.Log("neatSplitter fail ChannelAndUserSplitter=" + w);
                    App.main_window.ChannelAndUserSplitter.setDividerLocation(-1);
                }
            }
            main_window.setVisible(true);
            main_window.repaint();
            timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        block1 : switch (timerState) {
                            case 0: {
                                os_dependence.setLF(root_property.setDefaultString("LookAndFeel", UIManager.getSystemLookAndFeelClassName()));
                                Iterator it = App.this.getChilds();
                                while (it.hasNext()) {
                                    Object o = it.next();
                                    if (!(o instanceof CTN_Conn)) continue;
                                    ((CTN_Conn)o).onLoad();
                                }
                                ((Timer)evt.getSource()).setDelay(1000);
                                timerState = 100;
                                break;
                            }
                            case 100: {
                                hook_manager.callTimer();
                                Iterator it = App.this.getChilds();
                                while (it.hasNext()) {
                                    Object o = it.next();
                                    if (!(o instanceof CTN_Conn)) continue;
                                    ((CTN_Conn)o).onTimer();
                                }
                                delay_log.onTimer();
                                long now = System.currentTimeMillis();
                                while (!delay_proc_list.isEmpty()) {
                                    DelayProc dp = (DelayProc)delay_proc_list.getFirst();
                                    if (dp.time > now) break block1;
                                    delay_proc_list.removeFirst();
                                    SwingUtilities.invokeLater(dp.method);
                                }
                                break;
                            }
                            case 1000: {
                                timerState = 1010;
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "timerState=" + timerState, e);
                    }
                }
            });
            timer.start();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "init", e);
        }
    }

    public void AppExit(String reason) {
        try {
            timer.stop();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            root_property.set("Scripts", (Object)script_manager.getScriptInfo());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            WindowPos.saveTableColPos(App.main_window.user_view.table, "UserViewColmnWidth");
            WindowPos.saveSplitterPos("ChannelAndUserSplitter", App.main_window.ChannelAndUserSplitter);
            WindowPos.saveSplitterPos("LRSplitter", App.main_window.LRSplitter);
            WindowPos.saveSplitterPos("AllLogSplitter", App.main_window.AllLogSplitter);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            WindowPos.saveWindowPos(main_window, "WindowBounds_Main");
            WindowPos.saveWindowPos(script_manager, "WindowBounds_Scripts");
            WindowPos.saveWindowPos(log_all, "WindowBounds_AllLog");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            buf_list.saveOrder();
            root_property.set("buf_list_last_select", (Object)("" + buf_list.getSelectedIndex()));
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            script_manager.exit();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            compiled_scripts.unloadAll();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            PropertyManager.save(App.getApp(), IniFileName);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            this.disconnectAll();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            System.runFinalization();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            log_all.hide();
            main_window.hide();
            script_manager.hide();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
        try {
            logger.info("AppExit reason=" + reason);
            App.selector.exit_flag = true;
            logger.info("close socket selector ...");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "AppExit reason=" + reason, e);
        }
    }

    public boolean isApp() {
        return true;
    }

    public String GetCaption() {
        return App.getApp().GetName();
    }

    public String getPopupName() {
        return "popup-app";
    }

    public int getListLevel() {
        return 0;
    }

    public String getTitle() {
        return config_AppName + " - ";
    }

    public boolean SendFromUserInput(String a, int type) {
        return false;
    }

    public void disconnectAll() {
        Vector v = new Vector();
        Iterator it = this.child.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        for (int i = 0; i < v.size(); ++i) {
            ConnTreeNode o = (ConnTreeNode)v.get(i);
            if (!(o instanceof CTN_Conn)) continue;
            ((CTN_Conn)o).disconnect();
        }
    }

    public List getCreateParam() {
        LinkedList<String> l = new LinkedList<String>();
        l.add(this.GetCaption());
        return l;
    }

    public static ConnTreeNode createNode(ConnTreeNode parent, List param) {
        return App.getApp();
    }

    public void PreRemove() {
    }

    public Object getPropertyExtra() {
        return this;
    }

    public void onHashSave() {
    }

    public void onHashLoad() {
    }

    public void onPropertyChanged(String name, Object value) {
        if (name.equals("LogSweepMax") && (LogDocument.config_LogSweepMax = PropertyManager.IntValue(value)) < 1) {
            LogDocument.config_LogSweepMax = 1;
        }
        if (name.equals("LookAndFeel")) {
            os_dependence.setLF((String)value);
        }
        if (name.equals("ConvertChar/BaseDecodeMode")) {
            ConvertChar.setBaseDecodeMode(PropertyManager.IntValue(value));
        }
    }

    public void setDefaultProperty() {
        this.property.setDefaultObject("ConvertChar", new HashMap());
        this.property.setDefaultObject("DelayLog", new HashMap());
        this.property.setDefaultInt("ConvertChar/BaseDecodeMode", 1);
        this.property.setDefaultBoolean("ActivateBufferOnCreate", true);
        this.property.setDefaultBoolean("LogCRLF", true);
        this.property.setDefaultBoolean("RightTree", true);
        this.property.setDefaultBoolean("TopTree", true);
        this.property.setDefaultBoolean("AlloLogInMain", false);
        this.property.setDefaultBoolean("alllog_top", false);
        this.property.setDefaultBoolean("HorizontalLayout", true);
        this.property.setDefaultString("LogFileEncoding", "UTF-8");
        this.property.setDefaultString("CommandSlash", "/");
        this.property.setDefaultString("LogSweepMax", "2000");
        this.property.setDefaultString("TextEditorPath", "notepad.exe");
        this.property.setDefaultString("FolderViewerPath", "cmd.exe /C start");
        this.property.setDefaultString("BrowserName", "cmd.exe /C start");
    }

    public static ConnTreeNode getSelected() {
        return buf_list == null ? null : buf_list.getSelected();
    }

    public static CTN_Conn getSelectedConn() {
        return buf_list == null ? null : buf_list.getConn();
    }

    public static CTN_Chan getSelectedChannel() {
        return buf_list == null ? null : buf_list.getChannel();
    }

    public static CTN_Priv getSelectedPriv() {
        return buf_list == null ? null : buf_list.getPrivNode();
    }

    public static void selectTreeView(ConnTreeNode node) {
        buf_list.select(node);
    }

    public static void redrawTreeView(ConnTreeNode node) {
        buf_list.redrawItem(node);
    }

    public static void updateBufferListItem(ConnTreeNode node) {
        buf_list.notifySizeChange();
    }

    public void updateTopic() {
        ConnTreeNode c = buf_list.getSelected();
        if (c == null) {
            return;
        }
        String t = c.getTitle();
        if (!t.equals(this.lastTitle)) {
            this.lastTitle = t;
            main_window.setTitle(this.lastTitle);
        }
        App.main_window.labelBufferInfo.setText(c.getBufferInfo());
        App.main_window.log_view.setDocument(c.getLogDocument());
        App.main_window.user_view.setDocument(c, c.getUserList());
    }

    public static void Log(String text) {
        block7: {
            block6: {
                if (text == null || text.length() == 0) {
                    return;
                }
                App app = App.getApp();
                if (app == null) break block6;
                if (console_doc != null) break block7;
            }
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            int lf = text.indexOf(10, i);
            if (lf == -1) {
                lf = text.length();
            }
            if (lf <= i) continue;
            String s = text.substring(i, lf);
            i = lf;
            console_doc.addText((Component)main_window, s);
            if (log_all == null) continue;
            if (App.log_all.doc == null) continue;
            App.log_all.doc.addText((Component)main_window, s);
        }
    }

    public static boolean isLoggable(LogRecord record) {
        block3: {
            block2: {
                App app = App.getApp();
                if (app == null) break block2;
                if (console_doc != null && timerState < 1000) break block3;
            }
            return false;
        }
        return true;
    }

    public static void publish(String head, String msg) {
        if (head != null) {
            App.Log(head);
        }
        App.Log(msg);
    }

    public static void recordPreFocus(String context) {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c == null || c instanceof JRootPane) {
            return;
        }
        pre_focus = c;
    }

    public static Object getFocusComponent() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c instanceof JRootPane) {
            c = pre_focus;
        }
        return c;
    }

    public static void addDelayProc(int second, Runnable method) {
        DelayProc dp = new DelayProc();
        dp.time = System.currentTimeMillis() + (long)(second * 1000);
        dp.method = method;
        int i = 0;
        Iterator it = delay_proc_list.iterator();
        while (it.hasNext()) {
            DelayProc item = (DelayProc)it.next();
            if (dp.time < item.time) break;
            ++i;
        }
        delay_proc_list.add(i, dp);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            int i;
            root_logger.setLevel(Level.FINEST);
            root_logger.setFilter(null);
            Handler[] hs = root_logger.getHandlers();
            for (i = 0; i < hs.length; ++i) {
                hs[i].setFormatter(new MyFormatter());
            }
            log_file_handler = new FileHandler("BluntIRC-debug.log", false);
            log_file_handler.setEncoding("UTF-8");
            log_file_handler.setFormatter(new MyFormatter());
            root_logger.addHandler(log_file_handler);
            log_screen_handler = new ScreenLogHandler();
            log_screen_handler.setEncoding("UTF-8");
            log_screen_handler.setFormatter(new MyFormatter());
            root_logger.addHandler(log_screen_handler);
            hs = root_logger.getHandlers();
            for (i = 0; i < hs.length; ++i) {
                hs[i].setLevel(Level.INFO);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger = Logger.getLogger("bluntirc.app");
        logger.setLevel(null);
        config_AppName = "BluntIRC";
        IniFileName = "hash.ini";
        connection_logger = new base.Logger(){

            public void Log(String s) {
                App.Log(s);
            }
        };
        os_dependence = new OSDependence();
        conn_hook = new ConnectionListener();
        pfm_manager = new PrintFormatMacroManager();
        style_manager = new StyleManager();
        menu_conf = new MenuConf();
        action_manager = new ActionManager();
        hook_manager = new HookManager();
        compiled_scripts = new ScriptManagerCompiled();
        buf_list = new BufferList();
        delay_log = new DelayLog();
        delay_proc_list = new LinkedList();
        timerState = 0;
    }
}

