/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.ConvertChar;
import base.MyURL;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class Util {
    public static Logger logger = Logger.getLogger("base.util");
    public static ClassLoader AppClassLoader;
    static Map RecycleString_map;

    public static InputStream OpenFile(String fname) throws IOException, FileNotFoundException {
        InputStream result = null;
        try {
            result = new FileInputStream(new File(fname));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (result == null && AppClassLoader != null) {
            result = AppClassLoader.getResourceAsStream(fname);
        }
        if (result != null) {
            return result;
        }
        throw new FileNotFoundException(fname + "\u306f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u3082\u30ea\u30bd\u30fc\u30b9\u306b\u3082\u542b\u307e\u308c\u3066\u3044\u306a\u3044");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon GetImageIconFromJAR(String fname) {
        ImageIcon imageIcon;
        InputStream i = Util.OpenFile(fname);
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            while (true) {
                byte[] b;
                int readed;
                int s;
                if ((s = i.available()) < 1) {
                    s = 1;
                }
                if ((readed = i.read(b = new byte[s])) == -1) break;
                ba.write(b, 0, readed);
            }
            imageIcon = new ImageIcon(ba.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                i.close();
                throw throwable;
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "GetImageIconFromJAR", e);
                return null;
            }
        }
        i.close();
        return imageIcon;
    }

    public static byte[] toJIS(String src) {
        return ConvertChar.UnicodeToJIS(src, 0, src.length());
    }

    public static byte[] toJIS(String src, int start, int end) {
        return ConvertChar.UnicodeToJIS(src, start, end);
    }

    public static String fromJIS(byte[] src) {
        return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src, 0, src.length));
    }

    public static String fromJIS(byte[] src, int start, int end) {
        return ConvertChar.convertForDisplay(ConvertChar.JISToUnicode(src, start, end));
    }

    public static byte[] ByteSubString(byte[] src, int start, int end) {
        if (start < 0 || end < start || end > src.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] dst = new byte[end - start];
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = src[i + start];
        }
        return dst;
    }

    public static int ByteIndexOf(byte[] src, int c) {
        return Util.ByteIndexOf(src, (byte)c);
    }

    public static int ByteIndexOf(byte[] src, char c) {
        return Util.ByteIndexOf(src, (byte)c);
    }

    public static int ByteIndexOf(byte[] src, byte c) {
        for (int i = 0; i < src.length; ++i) {
            if (src[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static int compareByteArray(byte[] a, int a_start, byte[] b, int b_start) {
        int minlength = a.length - a_start < b.length - b_start ? a.length - a_start : b.length - b_start;
        for (int i = 0; i < minlength; ++i) {
            if (a[a_start++] == b[b_start++]) continue;
            return a[a_start - 1] - b[b_start - 1];
        }
        return a.length - a_start - (b.length - b_start);
    }

    public static byte[] AsciiToByteArray(String s) {
        byte[] r = new byte[s.length()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)s.charAt(i);
        }
        return r;
    }

    public static String qqByteArray(byte[] src) {
        if (src == null) {
            return "\"(null)\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        for (int i = 0; i < src.length; ++i) {
            int c = src[i];
            if (c < 0) {
                c += 256;
            }
            sb.append("%");
            String Hex = Integer.toHexString(c);
            for (int j = Hex.length(); j < 2; ++j) {
                sb.append('0');
            }
            sb.append(Hex);
        }
        sb.append('\"');
        return new String(sb);
    }

    public static String qq(String src) {
        if (src == null) {
            return "\"(null)\"";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if ("\"\\".indexOf(c) != -1) {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (Character.isISOControl(c)) {
                if (c == '\b') {
                    sb.append("\\b");
                    continue;
                }
                if (c == '\t') {
                    sb.append("\\t");
                    continue;
                }
                if (c == '\n') {
                    sb.append("\\n");
                    continue;
                }
                if (c == '\f') {
                    sb.append("\\f");
                    continue;
                }
                if (c == '\r') {
                    sb.append("\\r");
                    continue;
                }
                sb.append("\\u");
                String Hex = Integer.toHexString(c);
                for (int j = Hex.length(); j < 4; ++j) {
                    sb.append('0');
                }
                sb.append(Hex);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return new String(sb);
    }

    public static String unquote(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean escape = false;
        block6: for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != '\\') {
                if (c == '\"') continue;
                sb.append(c);
                continue;
            }
            c = src.charAt(++i);
            switch (c) {
                default: {
                    sb.append(c);
                    continue block6;
                }
                case 'n': {
                    sb.append('\n');
                    continue block6;
                }
                case 'r': {
                    sb.append('\r');
                    continue block6;
                }
                case 't': {
                    sb.append('\t');
                    continue block6;
                }
                case 'u': {
                    if (++i < src.length() && src.charAt(i) == 'u') {
                        sb.append("\\u");
                        continue block6;
                    }
                    int code = 0;
                    for (int j = 0; j < 4 && ++i < src.length(); ++j) {
                        int h;
                        c = src.charAt(i);
                        if (c >= 'a' && c <= 'z') {
                            c = (char)(c - 32);
                        }
                        if ((h = "0123456789ABCDEF".indexOf(c)) == -1) {
                            --i;
                            break;
                        }
                        code = code * 16 + h;
                    }
                    sb.append(code);
                }
            }
        }
        return new String(sb);
    }

    public static final boolean isURIAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static final boolean isURIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean isScheme(char c) {
        return Util.isURIAlpha(c) || Util.isURIDigit(c) || -1 != "+-.".indexOf(c);
    }

    public static final boolean isURIChar(char c) {
        return Util.isURIAlpha(c) || Util.isURIDigit(c) || -1 != ".%/-_=?&:~!*'();@+$,#~\u203e".indexOf(c);
    }

    public static List URISplitter(String src) {
        Vector<Object> v = new Vector<Object>();
        int start = 0;
        while (start < src.length()) {
            int uristart = start;
            int uriend = 0;
            block1: while (true) {
                if (uristart < src.length() && !Util.isURIAlpha(src.charAt(uristart))) {
                    ++uristart;
                    continue;
                }
                if (uristart >= src.length() - 2) {
                    uristart = src.length();
                    break;
                }
                int colon = src.indexOf(58, uristart + 1);
                if (colon == -1) {
                    uristart = src.length();
                    break;
                }
                for (int i = uristart + 1; i < colon; ++i) {
                    if (Util.isScheme(src.charAt(i))) continue;
                    uristart = i;
                    continue block1;
                }
                if (colon + 1 >= src.length() || src.charAt(colon + 1) != '/') {
                    uristart = colon + 1;
                    continue;
                }
                for (uriend = colon += 2; uriend < src.length() && Util.isURIChar(src.charAt(uriend)); ++uriend) {
                }
                if (uriend != colon) break;
                uristart = colon;
            }
            if (uristart > start) {
                int n = start;
                start = uristart;
                v.add(src.substring(n, start));
            }
            if (uriend <= uristart) continue;
            start = uriend;
            v.add(new MyURL(src.substring(uristart, start)));
        }
        return v;
    }

    public static String EscapeForFile(String src) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (-1 != "\\/:;?*,<>|\"".indexOf(c)) {
                c = '-';
            }
            sb.append(c);
        }
        return new String(sb);
    }

    public static String WildcardToRegEx(String mask) {
        StringBuffer sb = new StringBuffer();
        sb.append('^');
        boolean escape = false;
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                if (escape) {
                    escape = false;
                    sb.append('\\');
                }
                sb.append(c);
                continue;
            }
            if (escape) {
                escape = false;
                sb.append(c);
                continue;
            }
            if (c == '\\' && i < mask.length() - 1) {
                escape = true;
                continue;
            }
            if (c == '?') {
                sb.append('.');
                continue;
            }
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            sb.append('\\');
            sb.append(c);
        }
        sb.append('$');
        String a = sb.toString();
        logger.finer("wildcard " + mask + " => regex " + a);
        return a;
    }

    private static String to2keta(String t) {
        if (t.length() < 2) {
            return "0" + t;
        }
        return t;
    }

    public static String GetTime(TimeZone tz) {
        return Util.GetTimeStr(tz);
    }

    public static String GetTimeStr(TimeZone tz) {
        return Util.GetTimeStr(new GregorianCalendar(tz));
    }

    public static String GetTimeStr(GregorianCalendar now) {
        String h = Util.to2keta(Integer.toString(now.get(11)));
        String m = Util.to2keta(Integer.toString(now.get(12)));
        return h + ":" + m;
    }

    public static String getDateStr(GregorianCalendar now) {
        String yy = Integer.toString(now.get(1));
        String mm = Util.to2keta(Integer.toString(1 + now.get(2)));
        String dd = Util.to2keta(Integer.toString(now.get(5)));
        return yy + mm + dd;
    }

    public static int SkipDelimitor(String src, String dlm, int start) {
        int i;
        for (i = start; i < src.length() && -1 != dlm.indexOf(src.charAt(i)); ++i) {
        }
        return i;
    }

    public static String JoinStr(String padding, String[] params, int start) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < params.length; ++i) {
            if (i != start) {
                sb.append(padding);
            }
            sb.append(params[i]);
        }
        return new String(sb);
    }

    public static String RecycleString(String key) {
        if (key == null) {
            return null;
        }
        Object o = RecycleString_map.get(key);
        if (o != null) {
            return (String)o;
        }
        RecycleString_map.put(key, key);
        return key;
    }

    static {
        logger.setLevel(null);
        AppClassLoader = null;
        RecycleString_map = new HashMap();
    }
}

