/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.SelectorItem;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class SelectorRun
implements Runnable {
    public static Logger logger = Logger.getLogger("base.selectorrun");
    public static long select_interval_min;
    public static int select_interval_step;
    public static long select_interval_max;
    static long next;
    boolean dmode = false;
    int cost_count = 0;
    long wantwrite_step = System.currentTimeMillis();
    long sps_before = System.currentTimeMillis();
    long sps_progress = 0L;
    long sps_count = 0L;
    Selector selector;
    public volatile boolean exit_flag = false;
    public volatile boolean closed = false;
    Object[][] saved_keys = null;
    int avail;
    long now;
    long step;
    long timer_next = System.currentTimeMillis();

    synchronized void my_wait(long time) {
        try {
            this.wait(time);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run() {
        SelectableChannel channel;
        SelectorItem item;
        SelectionKey key;
        Set<SelectionKey> keys = this.selector.keys();
        Set<SelectionKey> selected = this.selector.selectedKeys();
        String status = "avail=" + this.avail + " selectedKeys=" + selected.size() + " keys=" + keys.size();
        Iterator<SelectionKey> it = selected.iterator();
        while (it.hasNext()) {
            key = it.next();
            it.remove();
            item = (SelectorItem)key.attachment();
            channel = key.channel();
            try {
                int ready_flag = key.readyOps();
                if (this.dmode) {
                    logger.finest(((ready_flag & 8) != 0 ? "C" : "") + ((ready_flag & 0x10) != 0 ? "A" : "") + ((ready_flag & 1) != 0 ? "R" : "") + ((ready_flag & 4) != 0 ? "W" : "") + " " + item.getName(channel));
                }
                if ((ready_flag & 1) != 0) {
                    item.onReadable(channel);
                } else if ((ready_flag & 0x10) != 0) {
                    item.onAcceptable(channel);
                } else if ((ready_flag & 4) != 0) {
                    item.onWritable(channel);
                } else if ((ready_flag & 8) != 0) {
                    item.onConnectable(channel);
                    try {
                        key.interestOps(key.interestOps() & ~8);
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "OP_CONNECT", e);
                    }
                } else {
                    logger.warning(ready_flag + " " + item.getName(channel));
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "selection key", e);
            }
            try {
                int ops = key.interestOps();
                key.interestOps(item.wantWrite(channel) ? ops | 4 : ops & ~4);
            }
            catch (Throwable e) {}
        }
        if (this.exit_flag) {
            it = keys.iterator();
            while (it.hasNext()) {
                try {
                    key = it.next();
                    item = (SelectorItem)key.attachment();
                    channel = key.channel();
                    if (channel == null) continue;
                    logger.info("wait for " + item.getClass().getName() + " " + (channel instanceof SocketChannel ? ((SocketChannel)channel).socket().getRemoteSocketAddress().toString() : (channel instanceof ServerSocketChannel ? ((ServerSocketChannel)channel).socket().getLocalSocketAddress().toString() : "")));
                    item.onSelectorExit(channel);
                }
                catch (NullPointerException e) {
                }
                catch (CancelledKeyException e) {
                }
                catch (ConcurrentModificationException e) {
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "closeAll", e);
                }
            }
        }
        if (this.now < this.timer_next) {
            this.timer_next += 1000L;
            it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                item = (SelectorItem)key.attachment();
                channel = key.channel();
                try {
                    if (channel == null) continue;
                    item.onTimer(channel);
                }
                catch (NullPointerException e) {
                }
                catch (CancelledKeyException e) {
                }
                catch (ConcurrentModificationException e) {
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "onTimer", e);
                }
            }
        }
        boolean wantwrite = true;
        if (this.avail == 0 || this.sps_progress == 0L) {
            wantwrite = false;
            Iterator<SelectionKey> it2 = keys.iterator();
            while (it2.hasNext()) {
                SelectionKey key2 = it2.next();
                SelectorItem item2 = (SelectorItem)key2.attachment();
                SelectableChannel channel2 = key2.channel();
                try {
                    if (channel2 == null) continue;
                    boolean ww = item2.wantWrite(channel2);
                    if (ww) {
                        wantwrite = true;
                    }
                    int ops = key2.interestOps();
                    key2.interestOps(ww ? ops | 4 : ops & ~4);
                }
                catch (Throwable e) {}
            }
        }
        logger.finest(status + " fps=" + this.sps_count + "/sec step=" + this.step + "ms");
        if (wantwrite) {
            this.step = select_interval_min;
            this.dmode = false;
            this.cost_count = 0;
        } else {
            if ((this.step += this.step * (long)select_interval_step >> 8) > select_interval_max) {
                this.step = select_interval_max;
            }
            if (++this.cost_count > 300) {
                this.dmode = true;
            }
        }
    }

    public void loop() {
        try {
            this.selector = Selector.open();
            while (!this.exit_flag) {
                if (this.selector == null) {
                    try {
                        this.selector = Selector.open();
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "open selector", e);
                    }
                }
                if (this.saved_keys != null) {
                    for (int i = 0; i < this.saved_keys.length; ++i) {
                        Object[] item = this.saved_keys[i];
                        try {
                            ((SelectableChannel)item[0]).register(this.selector, (Integer)item[1], item[2]);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, "regist saved key to selector", e);
                        }
                    }
                    this.saved_keys = null;
                }
                this.step = select_interval_min;
                while (!this.exit_flag && this.saved_keys == null) {
                    if (this.selector.keys().isEmpty()) {
                        this.my_wait(500L);
                        continue;
                    }
                    this.now = System.currentTimeMillis();
                    this.avail = this.selector.select(this.step);
                    long select_blocked = System.currentTimeMillis() - this.now;
                    if (this.avail == 0 && this.selector.selectedKeys().size() == 0 && this.step >= 300L && select_blocked < 50L) {
                        logger.severe("network is unplugged?");
                        this.saved_keys = new Object[this.selector.keys().size()][];
                        int i = 0;
                        Iterator<SelectionKey> it = this.selector.keys().iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            this.saved_keys[i++] = new Object[]{key.channel(), new Integer(key.interestOps()), key.attachment()};
                        }
                        try {
                            this.selector.close();
                        }
                        catch (Throwable e) {
                            logger.log(Level.WARNING, "temporary close selector", e);
                        }
                        this.selector = null;
                        break;
                    }
                    ++this.sps_progress;
                    if (this.now - this.sps_before >= 1000L) {
                        this.sps_before += 1000L;
                        this.sps_count = this.sps_progress;
                        this.sps_progress = 0L;
                    }
                    SwingUtilities.invokeAndWait(this);
                }
                this.my_wait(2000L);
            }
            this.exit_flag = true;
            while (!this.selector.keys().isEmpty()) {
                this.now = System.currentTimeMillis();
                this.avail = this.selector.select(100L);
                ++this.sps_progress;
                if (this.now - this.sps_before >= 1000L) {
                    this.sps_before += 1000L;
                    this.sps_count = this.sps_progress;
                    this.sps_progress = 0L;
                }
                SwingUtilities.invokeAndWait(this);
            }
            try {
                this.selector.close();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "close selector", e);
            }
            this.closed = true;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "selector loop", e);
        }
    }

    public SelectionKey register(SelectorItem item, SelectableChannel channel, int op) throws IOException, ClosedChannelException {
        return channel.register(this.selector, op, item);
    }

    public SelectionKey register(SelectorItem item, SelectableChannel channel) throws IOException, ClosedChannelException {
        return channel.register(this.selector, channel.validOps(), item);
    }

    static {
        logger.setLevel(null);
        select_interval_min = 100L;
        select_interval_step = 256;
        select_interval_max = 1000L;
        next = System.currentTimeMillis();
    }
}

