/*
 * Decompiled with CFR 0.152.
 */
package base;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.HashMap;

public class MyStreamTokenizer
extends StreamTokenizer {
    public static final char QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public String fname;

    public ParseException nomatch(String desc) {
        String t;
        switch (this.ttype) {
            case -1: {
                t = "\u30d5\u30a1\u30a4\u30eb\u7d42\u7aef";
                break;
            }
            case 10: {
                t = "\u884c\u672b";
                break;
            }
            case -2: {
                t = "\u6570\u5024 " + this.nval;
                break;
            }
            case -3: {
                t = "\u5358\u8a9e " + this.sval;
                break;
            }
            case 39: {
                t = "\u6587\u5b57\u5217 " + this.sval;
                break;
            }
            case 34: {
                t = "\u6587\u5b57\u5217 " + this.sval;
                break;
            }
            default: {
                t = "\u6587\u5b57 " + (char)this.ttype + " " + Integer.toHexString((char)this.ttype);
            }
        }
        return new ParseException(desc + "\u3092\u671f\u5f85\u3057\u305f\u304c\u51fa\u73fe\u3057\u305f\u306e\u306f[" + t + "]\u3060\u3063\u305f", 0);
    }

    public String readQuote(String desc) throws IOException, ParseException {
        if (this.ttype == 39 || this.ttype == 34) {
            String r = this.sval;
            this.nextToken();
            return r;
        }
        throw this.nomatch(desc);
    }

    public String readWord(String desc) throws IOException, ParseException {
        if (this.ttype == -3) {
            String r = this.sval;
            this.nextToken();
            return r;
        }
        if (this.ttype == -2) {
            String r = Double.toString(this.nval);
            this.nextToken();
            return r;
        }
        throw this.nomatch(desc);
    }

    public double readNumber(String desc) throws IOException, ParseException {
        if (this.ttype == -2) {
            double d = this.nval;
            this.nextToken();
            return d;
        }
        if (this.ttype == -3) {
            String r = this.sval;
            this.nextToken();
            return Double.parseDouble(r);
        }
        throw this.nomatch(desc);
    }

    public int readInt(String desc) throws ParseException, IOException {
        return (int)this.readNumber(desc);
    }

    public String readWordOrQuote(String desc) throws IOException, ParseException {
        if (this.ttype == -3 || this.ttype == 39 || this.ttype == 34) {
            String r = this.sval;
            this.nextToken();
            return r;
        }
        if (this.ttype == -2) {
            String r = Double.toString(this.nval);
            this.nextToken();
            return r;
        }
        throw this.nomatch(desc);
    }

    public HashMap readOptions(String desc, boolean toLower) throws IOException, ParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = null;
        int mode = 0;
        while (!this.isEndOfStatement()) {
            if (this.ttype == 61) {
                if (mode != 1) {
                    throw new ParseException("\u4e88\u671f\u3057\u306a\u3044 '='", 0);
                }
                mode = 2;
                this.nextToken();
                continue;
            }
            String s = this.readWordOrQuote("\u30aa\u30d7\u30b7\u30e7\u30f3\u6307\u5b9a");
            if (mode == 2) {
                map.put(key, s);
                mode = 0;
                continue;
            }
            key = toLower ? s.toLowerCase() : s;
            map.put(key, "1");
            mode = 1;
        }
        return map;
    }

    public void skipToStartOfStatement() throws IOException, ParseException {
        while (true) {
            if ('\ufffc' == (char)this.ttype || this.ttype == -3 && this.sval.charAt(0) == '\ufeff') {
                this.nextToken();
                continue;
            }
            if (this.ttype != 10 && this.ttype != 59) break;
            this.nextToken();
        }
    }

    public boolean isEndOfStatement() throws IOException {
        return this.ttype == 59 || this.ttype == 10 || this.ttype == -1;
    }

    public void skipToEndOfStatement() throws IOException {
        while (this.ttype != 59 && this.ttype != 10 && this.ttype != -1) {
            this.nextToken();
        }
    }

    public MyStreamTokenizer(Reader r, String fname, boolean doParseNumbers) throws IOException {
        this(r, fname, doParseNumbers, false);
    }

    public MyStreamTokenizer(Reader r, String fname, boolean doParseNumbers, boolean doSkipEOL) throws IOException {
        super(r);
        this.fname = fname;
        this.resetSyntax();
        this.whitespaceChars(32, 32);
        this.whitespaceChars(9, 9);
        this.whitespaceChars(10, 10);
        this.whitespaceChars(13, 13);
        this.quoteChar(39);
        this.quoteChar(34);
        this.slashStarComments(true);
        this.slashSlashComments(true);
        if (!doSkipEOL) {
            this.eolIsSignificant(true);
        }
        this.ordinaryChar(61);
        this.wordChars(48, 57);
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(95, 95);
        if (doParseNumbers) {
            this.parseNumbers();
        } else {
            this.wordChars(45, 45);
        }
        this.nextToken();
        if (this.ttype == -3 && this.sval.length() == 1 && this.sval.charAt(0) == '\ufeff') {
            this.nextToken();
        }
    }

    public String errorString(ParseException e) {
        return this.fname + " " + this.lineno() + "\u884c: " + e.getMessage();
    }
}

