/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.CodeStringTable;
import base.Util;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConvertChar {
    public static boolean decode_NumericCharacterReferences = false;
    static int base_decode_mode = 1;
    static int kana_escapes_type = 0;
    public static Logger logger = Logger.getLogger("base.convertchar");
    static CodeStringTable j2safe = new CodeStringTable();
    static CodeStringTable u2safe = new CodeStringTable();
    static char[][] ary_ToDisplay = new char[][]{{'\\', '\u00a5'}, {'~', '\u203e'}, {'\u00a2', '\uffe0'}, {'\u00a3', '\uffe1'}, {'\u00ac', '\uffe2'}, {'\u2015', '\u2014'}, {'\u2016', '\u2225'}, {'\u2026', '\u22ef'}, {'\u2212', '\uff0d'}, {'\u301c', '\uff5e'}};
    static int FirstCall = 0;
    public static char[] ary_JIS208ToUnicode = new char[65536];
    private static ByteBuffer decodejis_bb = ByteBuffer.allocate(16);
    static Font font = new Font("Dialog", 0, 12);
    static CharsetDecoder base_decorder;
    static CharsetDecoder jis212_decorder;
    static CharsetDecoder x201_decorder;
    private static final byte[] ary_BrokenJISToX0213_2;
    private static byte[] jis212_escape;
    static byte[] src212;
    static char[] ary_UnicodeToJIS;
    static final byte[] nojis_result;
    static final byte[] kana_escapesJ;
    static final byte[] kana_escapesI;
    static final Object[][] encode_escapes;

    public static void setBaseDecodeMode(int nv) {
        base_decode_mode = nv;
    }

    public static String HexDump(byte[] ba, int start, int end) {
        StringBuffer tmp = new StringBuffer();
        char[] a = new char[1];
        for (int i = start; i < end; ++i) {
            byte c = ba[i];
            if (c >= 32 && c <= 126 && c != 37) {
                tmp.append((char)c);
                continue;
            }
            tmp.append('%');
            String Hex = Integer.toHexString(c + 256);
            tmp.append(Hex.substring(Hex.length() - 2));
        }
        return new String(tmp);
    }

    public static String convertForDisplay(String from) {
        StringBuffer dst = new StringBuffer();
        block0: for (int i = 0; i < from.length(); ++i) {
            String s;
            char f = from.charAt(i);
            if (f != '\u0000') {
                for (int j = 0; j < ary_ToDisplay.length; ++j) {
                    if (f != ary_ToDisplay[j][0]) continue;
                    dst.append(ary_ToDisplay[j][1]);
                    continue block0;
                }
            }
            if ((s = null) != null) {
                dst.append(s);
                continue;
            }
            dst.append(f);
        }
        return new String(dst);
    }

    public static void Setup() throws IOException {
        if (FirstCall == 0) {
            int c2;
            int c1;
            FirstCall = 1;
            j2safe.load("j2safe.dat");
            u2safe.load("u2safe.dat");
            for (int i = 0; i < ary_UnicodeToJIS.length; ++i) {
                ConvertChar.ary_UnicodeToJIS[i] = '\u0000';
            }
            BufferedReader isr = new BufferedReader(new InputStreamReader(Util.OpenFile("u2j208.dat"), "UTF-16BE"));
            int count = 0;
            while (true) {
                c1 = ((Reader)isr).read();
                c2 = ((Reader)isr).read();
                if (c1 == -1 || c2 == -1) break;
                ConvertChar.ary_UnicodeToJIS[c1] = (char)c2;
                ++count;
            }
            logger.info("ary_UnicodeToJIS:read " + count + " entrys");
            ((Reader)isr).close();
            for (int i = 0; i < ary_JIS208ToUnicode.length; ++i) {
                ConvertChar.ary_JIS208ToUnicode[i] = '\u0000';
            }
            isr = new BufferedReader(new InputStreamReader(Util.OpenFile("j2u208.dat"), "UTF-16BE"));
            count = 0;
            while (true) {
                c1 = ((Reader)isr).read();
                c2 = ((Reader)isr).read();
                if (c1 == -1 || c2 == -1) break;
                ConvertChar.ary_JIS208ToUnicode[c1] = (char)c2;
                ++count;
            }
            logger.info("ary_JIS208ToUnicode:read " + count + " entrys");
            ((Reader)isr).close();
            char[] c = new char[1];
            try {
                base_decorder = Charset.forName("ISO-8859-1").newDecoder();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                x201_decorder = Charset.forName("JIS0201").newDecoder();
            }
            catch (Throwable e) {
                // empty catch block
            }
            StringBuffer log_sb = new StringBuffer();
            log_sb.append("ToDisplay:");
            for (int i = 0; i < ary_ToDisplay.length; ++i) {
                boolean a2 = false;
                boolean a1 = false;
                c[0] = ary_ToDisplay[i][0];
                String s = new String(c);
                a1 = s.equals(new String(s.getBytes()));
                c[0] = ary_ToDisplay[i][1];
                s = new String(c);
                a2 = s.equals(new String(s.getBytes()));
                if (a1 == a2) {
                    ConvertChar.ary_ToDisplay[i][0] = '\u0000';
                    continue;
                }
                if (!a2) {
                    c[0] = ary_ToDisplay[i][0];
                    ConvertChar.ary_ToDisplay[i][0] = ary_ToDisplay[i][1];
                    ConvertChar.ary_ToDisplay[i][1] = c[0];
                }
                log_sb.append(" 0x" + Integer.toHexString(ary_ToDisplay[i][0]) + "=>0x" + Integer.toHexString(ary_ToDisplay[i][1]));
            }
            logger.info(log_sb.toString());
        }
    }

    private static final void decodeX201(StringBuffer sb, int b, char mode, boolean shift_out) {
        if ((b &= 0xFF) < 128) {
            if (mode == 'J' && !shift_out) {
                sb.append((char)b);
                return;
            }
            if (!(mode == 'J' && shift_out || mode == 'I')) {
                logger.finer("mode=" + mode + " shiftout=" + shift_out + " code=0x" + Integer.toHexString(b));
            }
        }
        if (x201_decorder != null) {
            decodejis_bb.clear();
            decodejis_bb.put((byte)(b | 0x80));
            decodejis_bb.flip();
            try {
                CharBuffer cb = x201_decorder.decode(decodejis_bb);
                sb.append(cb.array(), cb.position(), cb.remaining());
                return;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        sb.append("(x201%" + Integer.toHexString(b) + ")");
    }

    private static final void decodeJIS212(StringBuffer sb, byte b1, byte b2) {
        if (jis212_decorder != null) {
            decodejis_bb.clear();
            decodejis_bb.put(jis212_escape);
            decodejis_bb.put(b1);
            decodejis_bb.put(b2);
            decodejis_bb.flip();
            try {
                CharBuffer cb = jis212_decorder.decode(decodejis_bb);
                String s = new String(cb.array(), cb.position(), cb.remaining());
                if (s != null && s.length() > 0) {
                    sb.append(s);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        sb.append("(jis212%" + Integer.toHexString(b1 & 0xFF) + "%" + Integer.toHexString(b2 & 0xFF) + ")");
    }

    public static String JISToUnicode(byte[] ba) {
        return ConvertChar.JISToUnicode(ba, 0, ba.length);
    }

    /*
     * Unable to fully structure code
     */
    public static String JISToUnicode(byte[] ba, int arg_start, int end) {
        i = arg_start;
        sb = new StringBuffer();
        block40: while (i < end) {
            if (ConvertChar.base_decode_mode == 0) {
                start = i;
                while (i < end && ba[i] != 27) {
                    ++i;
                }
                if (i > start) {
                    try {
                        cb = ConvertChar.base_decorder.decode(ByteBuffer.wrap(ba, start, i - start));
                        sb.append(cb.array(), cb.position(), cb.remaining());
                    }
                    catch (Throwable e) {
                        ConvertChar.logger.log(Level.SEVERE, ConvertChar.HexDump(ba, start, i), e);
                        for (j = start; j < i; ++j) {
                            sb.append(ba[j] & 255);
                        }
                    }
                }
            } else {
                while (i < end && (b = 255 & ba[i]) != 27) {
                    ++i;
                    if (b < 128) {
                        sb.append((char)b);
                        continue;
                    }
                    if (b >= 161 && b <= 223) {
                        ConvertChar.decodeX201(sb, b, 'b', false);
                        continue;
                    }
                    if (i < end) {
                        b2 = 255 & ba[i];
                        if (b >= 129 && b <= 252 && b2 >= 64 && b2 <= 252 && b2 != 127) {
                            ++i;
                            jis = (b << 9) + (b <= 159 ? -57600 : -90368) + b2 + (b2 <= 126 ? -31 : (b2 <= 158 ? -32 : 130));
                            u = ConvertChar.ary_JIS208ToUnicode[jis];
                            if (u != '\u0000') {
                                sb.append(u);
                                continue;
                            }
                            s = ConvertChar.j2safe.find(jis);
                            if (s != null) {
                                sb.append(s);
                                continue;
                            }
                            sb.append("(SJIS-0x" + Integer.toHexString(b) + Integer.toHexString(b2) + ")");
                            continue;
                        }
                    }
                    sb.append("%" + Integer.toHexString(b));
                }
            }
            maxescape = end - 3;
            page = 0;
            while (i < end) {
                block2 : switch (ba[i]) {
                    case 32: {
                        page = 0;
                        continue block40;
                    }
                    case 14: {
                        if (page == 72010) {
                            page = 72011;
                            break;
                        }
                        if (page == 82010) {
                            page = 82011;
                            break;
                        }
                        page = 0;
                        continue block40;
                    }
                    case 15: {
                        if (page == 72011) {
                            page = 72010;
                            break;
                        }
                        if (page == 82011) {
                            page = 82010;
                            break;
                        }
                        page = 0;
                        continue block40;
                    }
                    case 27: {
                        if (i <= maxescape) {
                            switch (ba[i + 1]) {
                                case 40: {
                                    switch (ba[i + 2]) {
                                        case 66: {
                                            page = 0;
                                            i += 2;
                                            break block2;
                                        }
                                        case 73: {
                                            page = 72010;
                                            i += 2;
                                            break block2;
                                        }
                                        case 74: {
                                            page = 82010;
                                            i += 2;
                                            break block2;
                                        }
                                    }
                                    break;
                                }
                                case 36: {
                                    switch (ba[i + 2]) {
                                        case 64: {
                                            page = 2131;
                                            i += 2;
                                            break block2;
                                        }
                                        case 66: {
                                            page = 208;
                                            i += 2;
                                            break block2;
                                        }
                                        case 73: {
                                            page = 201;
                                            i += 2;
                                            break block2;
                                        }
                                        case 40: {
                                            if (i < maxescape) {
                                                switch (ba[i + 3]) {
                                                    case 79: {
                                                        page = 2131;
                                                        i += 3;
                                                        break block2;
                                                    }
                                                    case 80: {
                                                        page = 2132;
                                                        i += 3;
                                                        break block2;
                                                    }
                                                    case 68: {
                                                        page = 212;
                                                        i += 3;
                                                        break block2;
                                                    }
                                                }
                                            } else {
                                                ** GOTO lbl124
                                            }
                                        }
                                    }
                                }
                            }
lbl124:
                            // 6 sources

                            ConvertChar.logger.warning(ConvertChar.HexDump(ba, i, i + 3));
                        }
                        sb.append(ba[i++]);
                        continue block40;
                    }
                    default: {
                        switch (page) {
                            default: {
                                continue block40;
                            }
                            case 201: {
                                ConvertChar.decodeX201(sb, ba[i], ' ', false);
                                break block2;
                            }
                            case 82010: {
                                ConvertChar.decodeX201(sb, ba[i], 'J', false);
                                break block2;
                            }
                            case 82011: {
                                ConvertChar.decodeX201(sb, ba[i], 'J', true);
                                break block2;
                            }
                            case 72010: {
                                ConvertChar.decodeX201(sb, ba[i], 'I', false);
                                break block2;
                            }
                            case 72011: {
                                ConvertChar.decodeX201(sb, ba[i], 'I', true);
                                break block2;
                            }
                            case 208: 
                            case 2131: {
                                if (i == end - 1 || (c1 = 255 & ba[i]) <= 32 || (c2 = 255 & ba[i + 1]) <= 32) continue block40;
                                jis = c2 | c1 << 8;
                                u = ConvertChar.ary_JIS208ToUnicode[jis];
                                if (u != '\u0000') {
                                    sb.append(u);
                                } else {
                                    s = ConvertChar.j2safe.find(jis);
                                    if (s != null) {
                                        sb.append(s);
                                    } else {
                                        sb.append("(JIS1\u9762-0x" + Integer.toHexString(c2 | c1 << 8) + ")");
                                    }
                                }
                                ++i;
                                break block2;
                            }
                            case 2132: {
                                if (i == end - 1 || (c1 = 255 & ba[i]) <= 32 || (c2 = 255 & ba[i + 1]) <= 32) continue block40;
                                k = -1;
                                for (j = 0; j < ConvertChar.ary_BrokenJISToX0213_2.length; ++j) {
                                    if (ConvertChar.ary_BrokenJISToX0213_2[j] != c1 - 32) continue;
                                    k = j + 127;
                                    break;
                                }
                                if (k == -1) continue block40;
                                u = ConvertChar.ary_JIS208ToUnicode[c2 | k << 8];
                                if (u != '\u0000') {
                                    sb.append(u);
                                } else {
                                    sb.append("(JIS2\u9762-0x" + Integer.toHexString(c1) + Integer.toHexString(c2) + ")");
                                }
                                ++i;
                                break block2;
                            }
                            case 212: 
                        }
                        if (i == end - 1 || ba[i] <= 32) continue block40;
                        ConvertChar.decodeJIS212(sb, ba[i], ba[i + 1]);
                        ++i;
                    }
                }
                ++i;
            }
        }
        src = sb.toString();
        if (ConvertChar.decode_NumericCharacterReferences && -1 != src.indexOf("&#")) {
            sb = new StringBuffer();
            entity = '\u0000';
            e_end = 0;
            start = 0;
            while (start < src.length()) {
                e_start = start;
                block47: while (e_start < src.length()) {
                    if ((e_start = src.indexOf("&#", e_start)) == -1) {
                        e_end = e_start = src.length();
                        break;
                    }
                    n_start = e_start + 2;
                    e_end = src.indexOf(59, n_start);
                    if (e_end == -1) {
                        e_end = e_start = src.length();
                        break;
                    }
                    radix = 10;
                    maxlen = 5;
                    if (-1 != "xX".indexOf(src.charAt(n_start))) {
                        ++n_start;
                        radix = 16;
                        maxlen = 4;
                    }
                    if (e_end - n_start < 1 || e_end - n_start > maxlen) {
                        e_start = e_end + 1;
                        continue;
                    }
                    flag = true;
                    for (i = n_start; i < e_end; ++i) {
                        c = src.charAt(i);
                        if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') continue;
                        e_end = e_start = i;
                        continue block47;
                    }
                    try {
                        ConvertChar.logger.finer("decode entity " + src.substring(n_start, e_end) + " radix=" + radix);
                        entity = (char)Integer.parseInt(src.substring(n_start, e_end), radix);
                        break;
                    }
                    catch (Throwable e) {
                        e_start = e_end + 1;
                    }
                }
                if (e_start > start) {
                    sb.append(src.substring(start, e_start));
                    start = e_start;
                }
                if (e_end <= e_start) continue;
                start = e_end + 1;
                if (!ConvertChar.font.canDisplay(entity)) {
                    ConvertChar.logger.fine(src.substring(e_start, start) + "\u306f\u73fe\u5728\u306e\u74b0\u5883\u3067\u306f\u8868\u793a\u3067\u304d\u306a\u3044");
                    sb.append(src.substring(e_start, start));
                    continue;
                }
                sb.append(entity);
            }
            src = sb.toString();
        }
        return src;
    }

    public static byte[] UnicodeToJIS(String src, int start, int end) {
        if (end < 0) {
            end = src.length();
        }
        ByteArrayOutputStream UnicodeToJIS_bao = new ByteArrayOutputStream();
        byte[] byte2 = new byte[2];
        int mode = 0;
        boolean need_shift_in = false;
        try {
            UnicodeToJIS_bao.reset();
            for (int i = start; i < end; ++i) {
                char c = src.charAt(i);
                String s = null;
                s = u2safe.find(c);
                int max = s != null ? s.length() : 1;
                for (int j = 0; j < max; ++j) {
                    if (s != null) {
                        c = s.charAt(j);
                    }
                    int new_mode = 0;
                    boolean new_need_shift_in = false;
                    byte[] encode_result = byte2;
                    byte[] new_escape = null;
                    int encode_result_length = 1;
                    if (c <= '\u0080') {
                        byte2[0] = (byte)c;
                    } else {
                        char jis = ary_UnicodeToJIS[c];
                        if (jis == '\u0000') {
                            new_mode = 0;
                            String hex = "&#x" + Integer.toHexString(c) + ";";
                            try {
                                encode_result = hex.getBytes("UTF-8");
                            }
                            catch (Throwable e) {
                                logger.severe("encode entity failed");
                                encode_result = nojis_result;
                            }
                            encode_result_length = encode_result.length;
                        } else if (jis >= '\u0100') {
                            new_mode = 1;
                            byte2[0] = (byte)(jis >> 8);
                            byte2[1] = (byte)(jis & 0xFF);
                            encode_result_length = 2;
                        } else if (jis >= '\u00a0' && jis <= '\u00df') {
                            switch (kana_escapes_type) {
                                case 0: {
                                    new_mode = 2010;
                                    new_escape = kana_escapesJ;
                                    jis = (char)(jis & 0x7F);
                                    new_need_shift_in = true;
                                    break;
                                }
                                case 1: {
                                    new_mode = 2011;
                                    new_escape = kana_escapesJ;
                                    break;
                                }
                                case 2: {
                                    new_mode = 2012;
                                    new_escape = kana_escapesI;
                                    jis = (char)(jis & 0x7F);
                                    break;
                                }
                                case 3: {
                                    new_mode = 2013;
                                    new_escape = kana_escapesI;
                                }
                            }
                            byte2[0] = (byte)jis;
                        } else {
                            new_mode = 0;
                            byte2[0] = (byte)jis;
                        }
                    }
                    if (mode != new_mode) {
                        mode = new_mode;
                        if (need_shift_in) {
                            UnicodeToJIS_bao.write(15);
                        }
                        UnicodeToJIS_bao.write(new_escape != null ? new_escape : (byte[])encode_escapes[mode][1]);
                        need_shift_in = new_need_shift_in;
                        if (need_shift_in) {
                            UnicodeToJIS_bao.write(14);
                        }
                    }
                    UnicodeToJIS_bao.write(encode_result, 0, encode_result_length);
                }
            }
            if (mode != 0) {
                if (need_shift_in) {
                    UnicodeToJIS_bao.write(15);
                }
                UnicodeToJIS_bao.write((byte[])encode_escapes[0][1]);
            }
            return UnicodeToJIS_bao.toByteArray();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "UnicodeToJIS", e);
            return new byte[0];
        }
    }

    static {
        ary_BrokenJISToX0213_2 = new byte[]{1, 8, 3, 4, 5, 12, 13, 14, 15, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94};
        jis212_escape = new byte[]{27, 36, 68};
        src212 = new byte[2];
        ary_UnicodeToJIS = new char[65536];
        nojis_result = new byte[]{63};
        kana_escapesJ = new byte[]{27, 40, 74};
        kana_escapesI = new byte[]{27, 40, 73};
        encode_escapes = new Object[][]{{null, new byte[]{27, 40, 66}}, {"JIS0208", new byte[]{27, 36, 66}}, {"JIS0201", null}};
    }
}

