class HTTPFilter < BloggerPost::Filter
  def translate(html)
    html = filter_attr(html, 'bphttp') do |param|
      get_title('http:' + param)
    end
    html = filter_attr(html, 'bphttps') do |param|
      get_title('https:' + param)
    end
    html
  end

  private

  def get_title(url)
    res = http_get(@config, URI.parse(url))
    title = nil
    title = get_title_text(res.body.toutf8) if res.code == '200'
    title = url unless title
    "<a href=\"#{url}\">#{title}</a>"
  end
end

BloggerPost.register_filter(HTTPFilter)
