class RDStyle < BloggerPost::Style
  def self.style_name
    'rd'
  end

  def self.extname
    '.rd'
  end

  def entry_to_html(entry)
    src = entry.body
    rtopt = ''
    titleopt = ''
    if src =~ /^=begin RT/
      rtopt = '-r rd/rt-filter --with-part=RT:rt'
      src.gsub!(/^=begin RTRD($.*?)^=end$/m) do
        "=end\n=begin RT" + $1 + "=end\n=begin\n"
      end
    end
    src = src.sub(/^= (.*)/, '')
    if $1
      title = $1
      title = CGI.escapeHTML(title)
      titleopt = "--html-title='#{title}'"
    end
    if (src =~ /\s*^=begin\n/m) != 0
      src = "=begin\n" + src + "\n=end\n"
    end
    html = external_convert("rd2 -r rd/rd2html-lib #{titleopt} #{rtopt}", src)
    html = delete_first_h1(html)
    html
  end
end

BloggerPost.register_style(RDStyle)
