class MarkdownStyle < BloggerPost::Style
  def self.style_name
    'markdown'
  end

  def self.extname
    '.txt'
  end

  def entry_to_html(entry)
    html = external_convert('markdown', entry.body)
    html = wrap_html_first_h1(html)
    html = escape_pre_text(html)
    html
  end
end

BloggerPost.register_style(MarkdownStyle)
