class GrutatxtStyle < BloggerPost::Style
  def self.style_name
    'grutatxt'
  end

  def self.extname
    '.txt'
  end

  def entry_to_html(entry)
    html = external_convert('grutatxt -i', entry.body)
    html = delete_first_a(html)
    html = delete_first_h1(html)
    html = tidy_html(html)
    html
  end
end

BloggerPost.register_style(GrutatxtStyle)
