class SyntaxFilter < BloggerPost::Filter
  def translate(html)
    html = filter_pre_text_attr(html, 'bpsyntax') do |src, param|
      vim_syntax_filter(src, param)
    end
    html
  end

  private

  def vim_syntax_filter(src, type)
    src = CGI.unescapeHTML(src)
    tempfile_in = make_tempfile_in(src)
    tempfile_out = make_tempfile_out
    system("vim -c ':set encoding=utf-8' -c ':set syn=#{type}' -c ':let html_use_css = 1' -c ':TOhtml' -c ':w! #{tempfile_out.path}' -c ':qa!' #{tempfile_in.path} &>/dev/null")
    tempfile_out.open
    colored_src = tempfile_out.read
    tempfile_out.close
    colored_src =~ /<pre>\n(.*)<\/pre>/m
    '<pre class="bpsyntax">' + $1 + '</pre>'
  end
end

BloggerPost.register_filter(SyntaxFilter)
