/*
 * Copyright 2006 - 2006 the original author or authors. This source code
 * licensed under the GPL License. You may not use this file except in
 * compliance with the License.
 */

package jp.sf.bli.web.sample.servlet;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.bli.testingframework.BliDjUnitTestCase;
import servletunit.HttpServletRequestSimulator;
import servletunit.HttpServletResponseSimulator;
import servletunit.ServletContextSimulator;

/**
 * <pre>
 *    [テストケース対象クラス]
 *    SampleServletTest
 *    [コメント]
 *    serviceはServletException,IOExceptionを起こせない為テスト外
 * </pre>
 * 
 * @author takeda
 */
public class SampleServletTest extends BliDjUnitTestCase {

    /**
     * SampleServlet serviceメソッド 正常終了01
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   SampleFilterのdoFilterが正常終了する
     *   [事後条件]
     *   Exceptionを発生しない
     * </pre>
     */
    public void testService01() {

        String testMethodNameStr = "testService01()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 ServletContextSimulatorのインスタンス化と加工
        // ----------------------------------------------------------------------

        ServletContext contextSimulator = new ServletContextSimulator();

        // 本メソッド加工なし

        // ----------------------------------------------------------------------
        // テスト準備2 HttpServletRequestSimulatorのインスタンス化と加工
        // ----------------------------------------------------------------------

        ServletContext context = ( ServletContext ) contextSimulator;

        HttpServletRequestSimulator reqSimulator = new HttpServletRequestSimulator(
                context );

        // パラメータをセット
        reqSimulator.setParameterValue( "test", new String[] {
            "test1"
        } );

        // HttpServletRequestにキャスト
        HttpServletRequest req = ( HttpServletRequest ) reqSimulator;

        // ----------------------------------------------------------------------
        // テスト準備3 HttpServletResponseSimulatorのインスタンス化と加工
        // ----------------------------------------------------------------------

        HttpServletResponseSimulator resSimulator = new HttpServletResponseSimulator();

        // 本メソッド加工なし

        // HttpServletResponseにキャスト
        HttpServletResponse res = ( HttpServletResponse ) resSimulator;

        // ----------------------------------------------------------------------
        // テスト準備4 HttpSessionの取得と加工
        // ----------------------------------------------------------------------

        // 本メソッド加工なし
        // HttpSession session = req.getSession();

        // ----------------------------------------------------------------------
        // テスト準備5 FilterChainのインスタンス化と加工
        // ----------------------------------------------------------------------

        // FilterChainSimulator chainSimulator = new FilterChainSimulator();

        // 本メソッド加工なし

        // FilterChain chain = (FilterChain)chainSimulator;

        // ----------------------------------------------------------------------
        // テスト準備6 FilterConfigのインスタンス化と加工
        // ----------------------------------------------------------------------

        // FilterConfigSimulator configSimulator = new
        // FilterConfigSimulator(context);

        // 本メソッド加工なし

        // FilterConfig config = (FilterConfigSimulator)configSimulator;

        // ----------------------------------------------------------------------
        // テスト準備7 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備8 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleServlet sampleServlet = new SampleServlet();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleServlet.service( req, res );

            logging( testMethodNameStr, "想定どおりException発生せず" );

        } catch ( IOException e ) {

            logging( testMethodNameStr, "IOExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "IOExceptionは発生してはいけません" );

        } catch ( Exception e ) {

            logging( testMethodNameStr, "Exceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "Exceptionは発生してはいけません" );

        }

        logEnd( testMethodNameStr );

    }

}
