/*
 * Copyright 2006 - 2006 the original author or authors. This source code
 * licensed under the GPL License. You may not use this file except in
 * compliance with the License.
 */

package jp.sf.bli.web.sample.servlet;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.bli.testingframework.BliDjUnitTestCase;
import servletunit.FilterChainSimulator;
import servletunit.FilterConfigSimulator;
import servletunit.HttpServletRequestSimulator;
import servletunit.HttpServletResponseSimulator;
import servletunit.ServletContextSimulator;

/**
 * <pre>
 *    [テストケース対象クラス]
 *    SampleFilterTest
 *    [コメント]
 *    特になし
 * </pre>
 * 
 * @author takeda
 */
public class SampleFilterTest extends BliDjUnitTestCase {

    /**
     * SmapleFilter doFilterメソッド 正常終了01
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   SampleFilterのdoFilterが正常終了する
     *   [事後条件]
     *   Exceptionを発生しない
     * </pre>
     */
    public void testDoFilter01() {

        String testMethodNameStr = "testDoFilter01()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ----------------------------------------------------------------------

        ServletContext context = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( context );
        HttpServletResponse res = new HttpServletResponseSimulator();
        // HttpSession session = req.getSession();
        FilterChain chain = new FilterChainSimulator();
        // FilterConfig config = new FilterConfigSimulator(context);

        // ----------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleFilter sampleFilter = new SampleFilter();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleFilter.doFilter( req, res, chain );

            logging( testMethodNameStr, "想定どおりException発生せず" );

        } catch ( IOException e ) {

            logging( testMethodNameStr, "IOExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "IOExceptionは発生してはいけません" );

        } catch ( ServletException e ) {

            logging( testMethodNameStr, "ServletExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "ServletExceptionは発生してはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * SmapleFilter doFilterメソッド 異常終了 IOException
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   doFilterメソッドがIOExceptionで異常終了する。
     *   [事後条件]
     *   テストコード内で、IOExceptionがキャッチされる。
     * </pre>
     */
    public void testDoFilterIOException() {

        String testMethodNameStr = "testDoFilterIOException()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ----------------------------------------------------------------------

        ServletContext context = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( context );
        HttpServletResponse res = new HttpServletResponseSimulator();
        // HttpSession session = req.getSession();
        FilterChain chain = new FilterChainSimulator();
        // FilterConfig config = new FilterConfigSimulator(context);

        // ----------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        addReturnValue( "javax.servlet.FilterChain", "doFilter",
                new IOException( "IOException." ) );

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleFilter sampleFilter = new SampleFilter();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleFilter.doFilter( req, res, chain );

            logging( testMethodNameStr, "正常終了してはいけません" );

            fail( "正常終了してはいけません" );

        } catch ( IOException e ) {

            logging( testMethodNameStr, "想定どおりIOException発生" );
            e.printStackTrace();

        } catch ( ServletException e ) {

            logging( testMethodNameStr, "ServletExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "ServletExceptionは発生してはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * SmapleFilter doFilterメソッド 異常終了 ServletException
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    doFilterメソッドがServletExceptionで異常終了する。
     *    [事後条件]
     *    テストコード内で、ServletExceptionがキャッチされる。
     * </pre>
     */
    public void testDoFilterServletException() {

        String testMethodNameStr = "testDoFilterServletException()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ----------------------------------------------------------------------

        ServletContext context = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( context );
        HttpServletResponse res = new HttpServletResponseSimulator();
        // HttpSession session = req.getSession();
        FilterChain chain = new FilterChainSimulator();
        // FilterConfig config = new FilterConfigSimulator(context);

        // ----------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        addReturnValue( "javax.servlet.FilterChain", "doFilter",
                new ServletException( "ServletException." ) );

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleFilter sampleFilter = new SampleFilter();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleFilter.doFilter( req, res, chain );

            logging( testMethodNameStr, "正常終了してはいけません" );

            fail( "正常終了してはいけません" );

        } catch ( IOException e ) {

            logging( testMethodNameStr, "IOExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "IOExceptionは発生してはいけません" );

        } catch ( ServletException e ) {

            logging( testMethodNameStr, "想定どおりServletException発生" );
            e.printStackTrace();

        }

        logEnd( testMethodNameStr );
    }


    /**
     * SmapleFilter initメソッド 正常終了01
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    SampleFilterのdoFilterが正常終了する
     *    [事後条件]
     *    
     *    Exceptionを発生しない
     * </pre>
     */
    public void testInit01() {

        String testMethodNameStr = "testInit01()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ----------------------------------------------------------------------

        ServletContext context = new ServletContextSimulator();
        // HttpServletRequest req = new HttpServletRequestSimulator(context);
        // HttpServletResponse res = new HttpServletResponseSimulator();
        // HttpSession session = req.getSession();
        // FilterChain chain = new FilterChainSimulator();
        FilterConfig config = new FilterConfigSimulator( context );

        // ----------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleFilter sampleFilter = new SampleFilter();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleFilter.init( config );

            logging( testMethodNameStr, "想定どおりException発生せず" );

        } catch ( ServletException e ) {

            logging( testMethodNameStr, "ServletExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "ServletExceptionは発生してはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * SmapleFilter destoryメソッド 正常終了01
     * 
     * <pre>
     *    [前提条件]
     *    なし
     *    [テスト内容]
     *    SampleFilterのdestoryが正常終了する
     *    [事後条件]
     *    
     *    Exceptionを発生しない
     * </pre>
     */
    public void testDestory01() {

        String testMethodNameStr = "testDestory()";

        logStart( testMethodNameStr );

        // ----------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ----------------------------------------------------------------------

        // 本メソッド設定なし
        
        // ----------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        // 本メソッド設定なし

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleFilter sampleFilter = new SampleFilter();

        // -------------------------------------------------------------------------
        // 単体テスト実行
        // -------------------------------------------------------------------------

        try {

            sampleFilter.destroy();

            logging( testMethodNameStr, "想定どおりException発生せず" );

        } catch ( Exception e ) {

            logging( testMethodNameStr, "ServletExceptionは発生してはいけません" );
            e.printStackTrace();

            fail( "ServletExceptionは発生してはいけません" );

        }

        logEnd( testMethodNameStr );

    }

}
