/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.bli.ss.sample.dao.SampleDao;
import jp.sf.bli.ss.sample.dao.impl.sample.SampleDaoImpl;
import jp.sf.bli.ss.sample.model.Sample;
import jp.sf.bli.testingframework.BliDjUnitTestCase;

/**
 * SampleSelectBlDoに対するUnitTestクラス
 */
public class SampleSelectBlDoTest extends BliDjUnitTestCase {

    /**
     * BLDoの初期化プロセスをテストする
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   BLDoのinitProcessを実行する。
     *   [事後条件]
     *   Exceptionにならずにテストが終了する。
     * </pre>
     */
    public void testBlDoInitProcess() {

        String testMethodNameStr = "testBlDoInitProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleSelectBlDo blDo = new SampleSelectBlDo();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blDo.initProcess( loginId, inputValueMap, outputValueMap );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLDoのdoBizLogicMainをテストする
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   BLDoのdoBizLogicMainを実行する。
     *   [事後条件]
     *   Exceptionにならずにテストが終了する。
     * </pre>
     */
    public void testBlDoDoBizLogicMain() {

        String testMethodNameStr = "testBlDoDoBizLogicMain";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        SampleDao sampleDao = new SampleDaoImpl();

        List< Sample > list = new ArrayList< Sample >();
        Sample sample = new Sample();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        sample.setId( Integer.valueOf( 1 ) );
        sample.setName( "武田" );
        sample.setAge( Integer.valueOf( 11 ) );

        list.add( sample );

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        addReturnValue( "jp.sf.bli.ss.sample.dao.impl.sample.SampleDaoImpl",
                "selectSample", list );

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleSelectBlDo blDo = new SampleSelectBlDo();

        blDo.setSampleDao( sampleDao );

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blDo.doBizLogicMain( loginId, inputValueMap, outputValueMap );

            List sampleList = ( List ) outputValueMap.get( "sampleList" );

            Sample rtnSample = ( Sample ) sampleList.get( 0 );

            assertEquals( rtnSample.getId(), Integer.valueOf( 1 ) );
            assertEquals( rtnSample.getName(), "武田" );
            assertEquals( rtnSample.getAge(), Integer.valueOf( 11 ) );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLDoの終了プロセスをテストする
     * 
     * <pre>
     *   [前提条件]
     *   なし
     *   [テスト内容]
     *   BLDoのendProcessを実行する。
     *   [事後条件]
     *   Exceptionにならずにテストが終了する。
     * </pre>
     */
    public void testBlDoEndProcess() {

        String testMethodNameStr = "testBlDoEndProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        String loginId = "loginId";
        Map< String, Object > inputValueMap = new HashMap< String, Object >();
        Map< String, Object > outputValueMap = new HashMap< String, Object >();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleSelectBlDo blDo = new SampleSelectBlDo();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blDo.endProcess( loginId, inputValueMap, outputValueMap );

        } catch ( Exception e ) {

            e.printStackTrace();
            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }

}
