/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample;

import java.util.ArrayList;
import java.util.List;

import jp.sf.bli.ss.sample.model.Sample;
import jp.sf.bli.testingframework.BliDjUnitTestCase;

/**
 * SampleFormに対するUnitTestクラス
 */
public class SampleFormTest extends BliDjUnitTestCase {

    /**
     * SmapleForm getter setter テスト
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  引数なしコンストラクタでインスタンス化しsetterでセットした値を
     *  getterしてチェックする
     *  [事後条件]
     *  テストにすべてパスする。
     * </pre>
     */
    public void testSampleForm01() {

        String testMethodNameStr = "testSampleForm01";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        Sample sample = new Sample();
        List< Sample > sampleList = new ArrayList< Sample >();

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用データ加工
        // ---------------------------------------------------------------------

        sample.setId( Integer.valueOf( 5 ) );
        sample.setName( "陣内" );
        sample.setAge( Integer.valueOf( 23 ) );

        sampleList.add( sample );

        // ---------------------------------------------------------------------
        // テスト準備3 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleForm sampleForm = new SampleForm();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        sampleForm.setName( "名前" );
        sampleForm.setAge( Integer.valueOf( 11 ) );
        sampleForm.setSampleList( sampleList );

        assertEquals( sampleForm.getName(), "名前" );
        assertEquals( sampleForm.getAge(), Integer.valueOf( 11 ) );
        assertEquals( sampleForm.getSampleList().size(), 1 );
        assertEquals( sampleForm.getSampleList().get( 0 ).getId(), Integer
                .valueOf( 5 ) );
        assertEquals( sampleForm.getSampleList().get( 0 ).getName(), "陣内" );
        assertEquals( sampleForm.getSampleList().get( 0 ).getAge(), Integer
                .valueOf( 23 ) );

        logEnd( testMethodNameStr );

    }

}
