/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sf.bli.ss.sample.model.Sample;
import jp.sf.bli.testingframework.BliDjUnitTestCase;
import servletunit.HttpServletRequestSimulator;
import servletunit.HttpServletResponseSimulator;
import servletunit.ServletContextSimulator;

/**
 * SampleBlCtrlに対するUnitTestクラス
 */
public class SampleBlCtrlTest extends BliDjUnitTestCase {

    /**
     * BLCtrlの初期化プロセスをテストする
     * 
     * <pre>
     *                    [前提条件]
     *                    なし
     *                    [テスト内容]
     *                    BlCtrlのInitProcessを実行する。
     *                    [事後条件]
     *                    Exceptionにならずにテストが終了し、inputMapとoutPutMapには
     *                    エントリーが無い。
     * </pre>
     */
    public void testBlCtrlInitProcess() {

        String testMethodNameStr = "testBlCtrlInitProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        ServletContext sc = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( sc );
        HttpServletResponse res = new HttpServletResponseSimulator();
        HttpSession session = req.getSession();

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        SampleForm form = new SampleForm();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlCtrl blCtrl = new SampleBlCtrl();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {
            blCtrl.init( session );
            blCtrl.initProcess( sc, session, res, req, form );

            assertEquals( blCtrl.getInputValueMap().isEmpty(), true );
            assertEquals( blCtrl.getOutputValueMap().isEmpty(), true );

        } catch ( Exception e ) {

            e.printStackTrace();

            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLCtrlの画面からの値のInputMapへのセットをテストする
     * 
     * <pre>
     *                   [前提条件]
     *                   なし
     *                   [テスト内容]
     *                   BlCtrlのparameter2InputValueMapで画面からの値をinputValueMapに
     *                   値をセットする
     *                   [事後条件]
     *                   Exceptionにならずにテストが終了し、inputValueMapに
     *                   画面からの値が正しくセットされる
     * </pre>
     */
    public void testBlCtrlParameter2InputValueMap() {

        String testMethodNameStr = "testBlCtrlParameter2InputValueMap";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        ServletContext sc = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( sc );
        HttpServletResponse res = new HttpServletResponseSimulator();
        HttpSession session = req.getSession();

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        SampleForm form = new SampleForm();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        form.setName( "test1" );
        form.setAge( Integer.valueOf( 54 ) );

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlCtrl blCtrl = new SampleBlCtrl();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {

            blCtrl.init( session );
            blCtrl.parameter2InputValueMap( sc, session, res, req, form );

            assertEquals( ( String ) blCtrl.getInputValueMap().get( "name" ),
                    "test1" );
            assertEquals( ( Integer ) blCtrl.getInputValueMap().get( "age" ),
                    Integer.valueOf( 54 ) );

        } catch ( Exception e ) {

            e.printStackTrace();

            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLCtrlにおけるBLDo群の処理結果のrequest,sessionへのセットをテストする
     * 
     * <pre>
     *                   [前提条件]
     *                   なし
     *                   [テスト内容]
     *                   BlCtrlのviewDispSetでBLDo群の処理結果をrequest,sessionに
     *                   セットする
     *                   [事後条件]
     *                   Exceptionにならずにテストが終了し、request,sessionに
     *                   outputValueMapからの値が正しくセットされる
     * </pre>
     */
    public void testBlCtrlViewDispSet() {

        String testMethodNameStr = "testBlCtrlViewDispSet";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        ServletContext sc = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( sc );
        HttpServletResponse res = new HttpServletResponseSimulator();
        HttpSession session = req.getSession();

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        SampleForm form = new SampleForm();
        Sample sample = new Sample();
        List< Sample > sampleList = new ArrayList< Sample >();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        sample.setId( Integer.valueOf( 5 ) );
        sample.setName( "陣内" );
        sample.setAge( Integer.valueOf( 23 ) );

        sampleList.add( sample );

        form.setName( "test1" );
        form.setAge( Integer.valueOf( 54 ) );

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ----------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ----------------------------------------------------------------------

        SampleBlCtrl blCtrl = new SampleBlCtrl();

        // ----------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ----------------------------------------------------------------------

        try {

            // BLCtrlの初期化処理実行
            blCtrl.init( session );

            // viewDispSetの処理に必要な事前データをMapにセット
            Map< String, Object > inputValueMap = blCtrl.getInputValueMap();
            Map< String, Object > outputValueMap = blCtrl.getOutputValueMap();

            inputValueMap.put( "age", Integer.valueOf( 54 ) );
            inputValueMap.put( "name", "test1" );

            outputValueMap.put( "sampleList", sampleList );

            // viewDispSetを実行
            blCtrl.viewDispSet( sc, session, res, req, form );

            // HttpServletRequestにセットされているかテストに入る。
            SampleForm rtnForm = ( SampleForm ) req.getAttribute( "sampleForm" );
            List rtnList = ( List ) rtnForm.getSampleList();

            assertEquals( rtnForm.getName(), "test1" );
            assertEquals( ( ( Sample ) rtnList.get( 0 ) ).getId(), Integer
                    .valueOf( 5 ) );
            assertEquals( ( ( Sample ) rtnList.get( 0 ) ).getName(), "陣内" );
            assertEquals( ( ( Sample ) rtnList.get( 0 ) ).getAge(), Integer
                    .valueOf( 23 ) );

        } catch ( Exception e ) {

            e.printStackTrace();

            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }


    /**
     * BLCtrlの終了プロセスをテストする
     * 
     * <pre>
     *                   [前提条件]
     *                   なし
     *                   [テスト内容]
     *                   BlCtrlのEndProcessを実行する。
     *                   [事後条件]
     *                   Exceptionにならずにテストが終了し、inputMapとoutPutMapには
     *                   エントリーが無い。
     * </pre>
     */
    public void testBlCtrlEndProcess() {

        String testMethodNameStr = "testBlCtrlEndProcess";

        logStart( testMethodNameStr );

        // ---------------------------------------------------------------------
        // テスト準備1 HTTP系モックのインスタンス化
        // ---------------------------------------------------------------------

        ServletContext sc = new ServletContextSimulator();
        HttpServletRequest req = new HttpServletRequestSimulator( sc );
        HttpServletResponse res = new HttpServletResponseSimulator();
        HttpSession session = req.getSession();

        // ---------------------------------------------------------------------
        // テスト準備2 テスト用に必要なインスタンスを用意
        // ---------------------------------------------------------------------

        SampleForm form = new SampleForm();

        // ---------------------------------------------------------------------
        // テスト準備3 テスト用データ加工
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ---------------------------------------------------------------------

        // 処理なし

        // ---------------------------------------------------------------------
        // テスト準備5 テスト対象クラスインスタンス化
        // ---------------------------------------------------------------------

        SampleBlCtrl blCtrl = new SampleBlCtrl();

        // ---------------------------------------------------------------------
        // 単体テスト実行 テスト準備で用意されたインスタンスでテストケースを実行
        // ---------------------------------------------------------------------

        try {

            blCtrl.init( session );
            blCtrl.endProcess( sc, session, res, req, form );

            assertEquals( blCtrl.getInputValueMap().isEmpty(), true );
            assertEquals( blCtrl.getOutputValueMap().isEmpty(), true );

        } catch ( Exception e ) {

            e.printStackTrace();

            fail( "Exceptionは起こしてはいけません" );

        }

        logEnd( testMethodNameStr );

    }

}
