/*
 * Copyright 2006 - 2007 the original author or authors.
 * This source code licensed under the GPL License.
 * You may not use this file except in compliance with the License.
 */
package jp.sf.bli.ss.sample;

import java.sql.SQLException;

import jp.sf.bli.framework.ss.BusinessLogicCtrlSS;
import jp.sf.bli.testingframework.BliDjUnitMockStrutsTestCase;

/**
 * SampleActionに対するUnitTestクラス
 * 
 */
public class SampleActionTest extends BliDjUnitMockStrutsTestCase {

    /**
     * SmapleAction BL正常終了
     * 
     * <pre>
     *  [前提条件]
     *  なし
     *  [テスト内容]
     *  SampleBLのdoBizLogicが0で正常終了した時の遷移
     *  [事後条件]
     *  successとなり、/WEB-INF/jsp/success.jspに遷移する
     * </pre>
     */
    public void testSampleActionSuccess() {

        String testMethodNameStr = "testSampleActionSuccess()";

        logStart( testMethodNameStr );

        // StrutsTestCase では、仕様制限で
        // セッションに値を保存してテストは出来ないので注意！

        // ----------------------------------------------------------------------
        // テスト準備1 テスト用 XML系の指定
        // ----------------------------------------------------------------------

        setServletConfigFile( "/WEB-INF/web.xml" );
        setConfigFile( "/WEB-INF/struts-config.xml" );

        // ----------------------------------------------------------------------
        // テスト準備2 テストする.doを設定
        // ----------------------------------------------------------------------

        setRequestPathInfo( "/sample" );

        // ----------------------------------------------------------------------
        // テスト準備3 POST・GETをシュミレート
        // ----------------------------------------------------------------------

        addRequestParameter( "postStaring01", "test" );
        addRequestParameter( "postStaring02", new String[] {
                "test02-1", "test02-2", "test02-3"
        } );

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        /*
         * テストのActionクラスのメッソッドの返り値を変更するデータ加工をする。
         * 開発時は、doBizLogicを横取りして、ActionクラスからBusiness Logicの
         * 処理を横取りしてテストケースの想定値にする事。
         */

        BusinessLogicCtrlSS blCtrl = new SampleBlCtrl();

        Integer forwardway = Integer.valueOf( 1 );

        addReturnValue( "jp.sf.bli.ss.sample.SampleAction", "getBlCtrl", blCtrl );
        addReturnValue( "jp.sf.bli.framework.ss.BusinessLogicCtrlSS",
                "doBizCtrl", forwardway );

        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRemoteAddr", "192.168.1.1" );
        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRequestURL", new StringBuffer() );

        // ----------------------------------------------------------------------
        // テスト準備3 Strutsのアクションを実行
        // ----------------------------------------------------------------------

        actionPerform();

        // -------------------------------------------------------------------------
        // Struts用単体テスト実行
        // -------------------------------------------------------------------------

        /* forwardの値をテスト */
        verifyForward( "success" );

        /* pathの値をテスト */
        verifyForwardPath( "/WEB-INF/jsp/disp.jsp" );

        /* ActionErrorが発生していないかテスト */
        verifyNoActionErrors();

        logEnd( testMethodNameStr );

    }


    /**
     * SmapleAction BL異常終了
     * 
     * <pre>
     *                [前提条件]
     *                 なし
     *                 [テスト内容]
     *                 SampleBLのdoBizLogicが1で終了失敗した時の遷移
     *                 [事後条件]
     *                 successとなり、/WEB-INF/jsp/success.jspに遷移する
     * </pre>
     */
    public void testSampleActionFailure() {

        String testMethodNameStr = "testSampleActionFailure()";

        logStart( testMethodNameStr );

        // StrutsTestCase では、仕様制限で
        // セッションに値を保存してテストは出来ないので注意！

        // ----------------------------------------------------------------------
        // テスト準備1 テスト用 XML系の指定
        // ----------------------------------------------------------------------

        setServletConfigFile( "/WEB-INF/web.xml" );
        setConfigFile( "/WEB-INF/struts-config.xml" );

        // ----------------------------------------------------------------------
        // テスト準備2 テストする.doを設定
        // ----------------------------------------------------------------------

        setRequestPathInfo( "/sample" );

        // ----------------------------------------------------------------------
        // テスト準備3 POST・GETをシュミレート
        // ----------------------------------------------------------------------

        addRequestParameter( "postStaring01", "test" );

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        /*
         * テストのActionクラスのメッソッドの返り値を変更するデータ加工をする。
         * 開発時は、doBizLogicを横取りして、ActionクラスからBusiness Logicの
         * 処理を横取りしてテストケースの想定値にする事。
         */

        BusinessLogicCtrlSS blCtrl = new SampleBlCtrl();
        Integer forwardway = Integer.valueOf( 0 );

        addReturnValue( "jp.sf.bli.ss.sample.SampleAction", "getBlCtrl", blCtrl );
        addReturnValue( "jp.sf.bli.framework.ss.BusinessLogicCtrlSS",
                "doBizCtrl", forwardway );

        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRemoteAddr", "192.168.1.1" );
        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRequestURL", new StringBuffer() );

        // ----------------------------------------------------------------------
        // テスト準備3 Strutsのアクションを実行
        // ----------------------------------------------------------------------

        actionPerform();

        // -------------------------------------------------------------------------
        // Struts用単体テスト実行
        // -------------------------------------------------------------------------

        /* forwardの値をテスト */
        verifyForward( "failure" );

        /* pathの値をテスト */
        verifyForwardPath( "/WEB-INF/jsp/dispFailure.jsp" );

        /* ActionErrorが発生していないかテスト */
        verifyNoActionErrors();

        logEnd( testMethodNameStr );

    }


    /**
     * SmapleAction BL異常終了 想定外
     * 
     * <pre>
     *                [前提条件]
     *                なし
     *                [テスト内容]
     *                SampleBLのdoBizLogicが1で終了失敗した時の遷移
     *                [事後条件]
     *                successとなり、/WEB-INF/jsp/success.jspに遷移する
     * </pre>
     */
    public void testSampleActionFailureUnknown() {

        String testMethodNameStr = "testSampleActionFailureUnknown()";

        logStart( testMethodNameStr );

        // StrutsTestCase では、仕様制限で
        // セッションに値を保存してテストは出来ないので注意！

        // ----------------------------------------------------------------------
        // テスト準備1 テスト用 XML系の指定
        // ----------------------------------------------------------------------

        setServletConfigFile( "/WEB-INF/web.xml" );
        setConfigFile( "/WEB-INF/struts-config.xml" );

        // ----------------------------------------------------------------------
        // テスト準備2 テストする.doを設定
        // ----------------------------------------------------------------------

        setRequestPathInfo( "/sample" );

        // ----------------------------------------------------------------------
        // テスト準備3 POST・GETをシュミレート
        // ----------------------------------------------------------------------

        addRequestParameter( "postStaring01", "test" );

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        /*
         * テストのActionクラスのメッソッドの返り値を変更するデータ加工をする。
         * 開発時は、doBizLogicを横取りして、ActionクラスからBusiness Logicの
         * 処理を横取りしてテストケースの想定値にする事。
         */

        BusinessLogicCtrlSS blCtrl = new SampleBlCtrl();
        Integer forwardway = Integer.valueOf( 99 );

        addReturnValue( "jp.sf.bli.ss.sample.SampleAction", "getBlCtrl", blCtrl );
        addReturnValue( "jp.sf.bli.framework.ss.BusinessLogicCtrlSS",
                "doBizCtrl", forwardway );

        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRemoteAddr", "192.168.1.1" );
        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRequestURL", new StringBuffer() );

        // ----------------------------------------------------------------------
        // テスト準備3 Strutsのアクションを実行
        // ----------------------------------------------------------------------

        actionPerform();

        // -------------------------------------------------------------------------
        // Struts用単体テスト実行
        // -------------------------------------------------------------------------

        /* forwardの値をテスト */
        verifyForward( "failure" );

        /* pathの値をテスト */
        verifyForwardPath( "/WEB-INF/jsp/dispFailure.jsp" );

        /* ActionErrorが発生していないかテスト */
        verifyNoActionErrors();

        logEnd( testMethodNameStr );
    }


    /**
     * SmapleAction BL異常終了 Exception
     * 
     * <pre>
     *               [前提条件]
     *               なし
     *               [テスト内容]
     *               SampleBLのdoBizLogicが1で終了失敗した時の遷移
     *               [事後条件]
     *               successとなり、/WEB-INF/jsp/success.jspに遷移する
     * </pre>
     */
    public void testSampleActionFailureException() {

        String testMethodNameStr = "testSampleActionFailureException()";

        logStart( testMethodNameStr );

        // StrutsTestCase では、仕様制限で
        // セッションに値を保存してテストは出来ないので注意！

        // ----------------------------------------------------------------------
        // テスト準備1 テスト用 XML系の指定
        // ----------------------------------------------------------------------

        setServletConfigFile( "/WEB-INF/web.xml" );
        setConfigFile( "/WEB-INF/struts-config.xml" );

        // ----------------------------------------------------------------------
        // テスト準備2 テストする.doを設定
        // ----------------------------------------------------------------------

        setRequestPathInfo( "/sample" );

        // ----------------------------------------------------------------------
        // テスト準備3 POST・GETをシュミレート
        // ----------------------------------------------------------------------

        addRequestParameter( "postStaring01", "test" );

        // ----------------------------------------------------------------------
        // テスト準備4 Virtual Mockでテストケースに必要なテストデータ加工を行う
        // ----------------------------------------------------------------------

        /*
         * テストのActionクラスのメッソッドの返り値を変更するデータ加工をする。
         * 開発時は、doBizLogicを横取りして、ActionクラスからBusiness Logicの
         * 処理を横取りしてテストケースの想定値にする事。
         */

        BusinessLogicCtrlSS blCtrl = new SampleBlCtrl();

        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRemoteAddr", "192.168.1.1" );
        addReturnValue( "javax.servlet.http.HttpServletRequest",
                "getRequestURL", new StringBuffer() );

        addReturnValue( "jp.sf.bli.ss.sample.SampleAction", "getBlCtrl", blCtrl );
        addReturnValue( "jp.sf.bli.framework.ss.BusinessLogicCtrlSS",
                "doBizCtrl", new SQLException( "SQLException." ) );

        logging( testMethodNameStr, "SQLExceptionを発生させます" );

        // ----------------------------------------------------------------------
        // テスト準備3 Strutsのアクションを実行
        // ----------------------------------------------------------------------

        actionPerform();

        // -------------------------------------------------------------------------
        // Struts用単体テスト実行
        // -------------------------------------------------------------------------

        /* forwardの値をテスト */
        verifyForward( "fatal" );

        /* pathの値をテスト */
        verifyForwardPath( "/WEB-INF/jsp/fatal.jsp" );

        /* ActionErrorが発生していないかテスト */
        verifyNoActionErrors();

        logEnd( testMethodNameStr );

    }
}
