/*
 * Copyright (C) 2006-2007 BLI Project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms,
 * with or without modification, are permitted provided
 * that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain
 * the above copyright notice, this list of conditions
 * and the following disclaimer as the first lines of this file unmodified.
 * 
 * 2. Redistributions  in  binary  form must reproduce 
 * the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sf.bli.ss.sample.model;

import java.io.Serializable;

/** @author Hibernate CodeGenerator */
public class Sample implements Serializable {

    /** serialVersionUID */
    private static final long serialVersionUID = 1L;

    /** identifier field */
    private Integer           id;

    /** nullable persistent field */
    private String            name;

    /** nullable persistent field */
    private Integer           age;


    /** full constructor */
    public Sample( Integer id, String name, Integer age ) {

        this.id = id;
        this.name = name;
        this.age = age;
    }


    /** default constructor */
    public Sample() {

    }


    /** minimal constructor */
    public Sample( Integer id ) {

        this.id = id;
    }


    public Integer getId() {

        return this.id;
    }


    public void setId( Integer id ) {

        this.id = id;
    }


    public String getName() {

        return this.name;
    }


    public void setName( String name ) {

        this.name = name;
    }


    public Integer getAge() {

        return this.age;
    }


    public void setAge( Integer age ) {

        this.age = age;
    }

}
