/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.stringgroup.BlancoDbLoggingModeStringGroup;
import blanco.db.common.util.BlancoDbQueryParserUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;
import blanco.dbmetadata.BlancoDbMetaDataUtil;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author tosiki iga
 */
public class PrepareCallMethod2 extends BlancoDbAbstractMethod {
    public PrepareCallMethod2(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("prepareCall",
                "^ꂽSQLăvRpC{(ISQL)܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod
                .getParameterList()
                .add(
                        fCgFactory
                                .createParameter("query", "java.lang.String",
                                        "vRpC{SQLBISQL̏ꍇɂ́Äɂ͉Hꂽ̎s\SQL^܂B"));

        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        final List<String> listDesc = cgMethod.getLangDoc()
                .getDescriptionList();
        listDesc.add("Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B<br>");
        listDesc
                .add("ł͂Ȃꍇɂ́Ã\bh̗p͔ prepareCall()\bh (Ȃ)ĂяoĂB<br>");
        listDesc
                .add("ȂȂÃ\bhłSQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[\NĂ܂łB<br>");
        listDesc.add("IConnection.prepareCallĂяo܂B<br>");

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.DEBUG:
                listLine.add("if (fLog.isDebugEnabled()) {");
                listLine.add("fLog.debug(\"" + cgMethod.getName()
                        + ": query = \" + query);");
                listLine.add("}");
                break;
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
                listLine.add("fLog.info(\"" + cgMethod.getName()
                        + ": query = \" + query);");
                break;
            }
            listLine.add("");
        }

        listLine.add("close();");

        listLine.add("fStatement = fConnection.prepareCall(query);");

        final BlancoDbQueryParserUtil query = new BlancoDbQueryParserUtil(
                fSqlInfo.getQuery());

        for (int indexParameter = 0; indexParameter < fSqlInfo
                .getOutParameterList().size(); indexParameter++) {
            // AƂ肠^ꂽœoƉ肪Ă܂B
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                    .getOutParameterList().get(indexParameter);

            final int[] listCol = query.getSqlParameters(columnStructure
                    .getName());
            if (listCol == null) {
                System.out.println("[" + fSqlInfo.getName() + "] SQLo̓p[^["
                        + columnStructure.getName() + "]тĂ܂.");
                continue;
            }
            for (int iteSame = 0; iteSame < listCol.length; iteSame++) {
                final int index = listCol[iteSame];

                String stmtLine = "fStatement.registerOutParameter("
                        + index
                        + ", java.sql.Types."
                        + BlancoDbMetaDataUtil
                                .convertJdbcDataTypeToString(columnStructure
                                        .getDataType());
                stmtLine += ");";
                listLine.add(stmtLine);
            }
        }
    }
}