/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.commons.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * blanco Frameworkɂ PHP\[XR[ho͂̂߂̃[eBeBW߂NXłB
 * 
 * @author IGA Tosiki
 */
public final class BlancoPhpSourceUtil {
    /**
     * ^ꂽPHP\[XR[hƂďo͂̂ƂăGXP[v܂B
     * 
     * /obNXbṼGXP[vщsR[h̃GXP[vs܂B<br>
     * ȊȌ͍s܂BƂ΃CWFNVUȂǂւ̑ϐ́Ã\bh͈܂B
     * 
     * @param originalString
     *            ͕
     * @return GXP[vsꂽ̕
     */
    public static final String escapeStringAsPhpSource(
            final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "BlancoPhpSourceUtil.escapeStringAsPhpSourceœ͈ᔽB̃\bhnullp[^Ƃė^܂BnullȊO̒l͂ĂB");
        }

        final StringReader reader = new StringReader(originalString);
        final StringWriter writer = new StringWriter();
        try {
            for (;;) {
                final int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                switch (iRead) {
                case '\\':
                    writer.write("\\\\");
                    break;
                case '\n':
                    writer.write("\\n");
                    break;
                case '\'':
                    writer.write("\\'");
                    break;
                default:
                    writer.write((char) iRead);
                    break;
                }
            }
            writer.flush();
        } catch (IOException e) {
            // ɓĂ邱Ƃ́A肦܂B
            e.printStackTrace();
        }
        return writer.toString();
    }
}
