/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.stringgroup.BlancoDbSqlInfoScrollStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilJava;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Tosiki Iga
 */
public class GetListMethod extends BlancoDbAbstractMethod {
    public GetListMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("getList",
                "ʂXǧ`Ŏ擾܂B");
        fCgClass.getMethodList().add(cgMethod);

        // sIuWFNǧ^擾܂B
        final String rowObjectType = BlancoNameAdjuster.toClassName(fSqlInfo
                .getName()) + "Row";

        cgMethod.setReturn(fCgFactory.createReturn("java.util.List<"
                + rowObjectType + ">", fSqlInfo.getName()
                + "NXListBʂ0̏ꍇɂ͋̃Xg߂܂B"));

        BlancoDbCgUtilJava.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        fCgSourceFile.getImportList().add("java.util.ArrayList");

        final List<String> listDesc = cgMethod.getLangDoc()
                .getDescriptionList();
        listDesc.add("Xgɂ " + fSqlInfo.getName() + "NXi[܂B<br>");
        listDesc.add("ʂ̌炩߂킩ĂāAȂꍇɗp邱Ƃł܂B<br>");
        listDesc.add("ʂ̌ꍇɂ́Ã\bh͗pA next()\bh𗘗p邱Ƃ߂܂B<br>");
        if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_FORWARD_ONLY) {
            listDesc.add("QueryIterator FORWARD_ONLY(J[\)łBʂ̃f[^Ƃ킩Ăꍇɂ́AgetList\bh̗p͋ɗ͔邩A邢 XN[J[\Ƃă\[XR[hĐĂB");
        } else {
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("absoluteStartPoint", "int",
                            "ǂݏoJnsBŏ̍sǂݏoꍇɂ 1 w肵܂B"));
        }

        cgMethod.getParameterList().add(
                fCgFactory.createParameter("size", "int", "ǂݏossB"));

        final List<String> listLine = cgMethod.getLineList();

        listLine.add("List<" + rowObjectType + "> result = new ArrayList<"
                + rowObjectType + ">(8192);");
        if (fSqlInfo.getScroll() != BlancoDbSqlInfoScrollStringGroup.TYPE_FORWARD_ONLY) {
            listLine.add("if (absolute(absoluteStartPoint) == false) {");
            listLine.add("return result;");
            listLine.add("}");
        }
        listLine.add("for (int count = 1; count <= size; count++) {");
        if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_FORWARD_ONLY) {
            listLine.add("if (next() == false) {");
            listLine.add("break;");
            listLine.add("}");
        } else {
            listLine.add("if (count != 1) {");
            listLine.add("if (next() == false) {");
            listLine.add("break;");
            listLine.add("}");
            listLine.add("}");
        }
        listLine.add("result.add(getRow());");
        listLine.add("}");
        listLine.add("return result;");
    }
}