/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.valueobject.message.BlancoValueObjectMessage;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * o[IuWFNgpXMLt@C Java\[XR[hNXB
 * 
 * blancoValueObject̎傽NX̂ЂƂłB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JavaClass {
    /**
     * bZ[WB
     */
    private final BlancoValueObjectMessage fMsg = new BlancoValueObjectMessage();

    /**
     * blancoValueObject̃\[XohIuWFNgB
     */
    private final BlancoValueObjectResourceBundle fBundle = new BlancoValueObjectResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * o[IuWFNg\钆XMLt@CAJava\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param argDirectoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {
        final BlancoValueObjectClassStructure[] structures = new BlancoValueObjectXmlParser()
                .parse(argMetaXmlSourceFile);
        for (int index = 0; index < structures.length; index++) {
            // ꂽ񂩂Java\[XR[h𐶐܂B
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * ^ꂽNXo[IuWFNgA\[XR[h܂B
     * 
     * @param argClassStructure
     *            NX
     * @param argDirectoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void structure2Source(
            final BlancoValueObjectClassStructure argClassStructure,
            final File argDirectoryTarget) throws IOException {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        // BlancoCgObjectFactoryNX̃CX^X擾܂B
        fCgFactory = BlancoCgObjectFactory.getInstance();

        fCgSourceFile = fCgFactory.createSourceFile(argClassStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);

        // NX쐬܂B
        fCgClass = fCgFactory.createClass(argClassStructure.getName(), "");
        fCgSourceFile.getClassList().add(fCgClass);

        // NX̃ANZXݒB
        fCgClass.setAccess(argClassStructure.getAccess());
        // ۃNXǂB
        fCgClass.setAbstract(argClassStructure.getAbstract());

        // p
        if (BlancoStringUtil.null2Blank(argClassStructure.getExtends())
                .length() > 0) {
            fCgClass.getExtendClassList().add(
                    fCgFactory.createType(argClassStructure.getExtends()));
        }
        // 
        for (int index = 0; index < argClassStructure.getImplementsList()
                .size(); index++) {
            final String impl = (String) argClassStructure.getImplementsList()
                    .get(index);
            fCgClass.getImplementInterfaceList().add(
                    fCgFactory.createType(impl));
        }

        // NXJavaDocݒ肵܂B
        fCgClass.setDescription(argClassStructure.getDescription());
        for (String line : argClassStructure.getDescriptionList()) {
            fCgClass.getLangDoc().getDescriptionList().add(line);
        }

        for (int indexField = 0; indexField < argClassStructure.getFieldList()
                .size(); indexField++) {
            // ̂̂̃tB[h܂B
            final BlancoValueObjectFieldStructure fieldStructure = (BlancoValueObjectFieldStructure) argClassStructure
                    .getFieldList().get(indexField);

            // K{ڂݒ̏ꍇɂ͗O{܂B
            if (fieldStructure.getName() == null) {
                throw new IllegalArgumentException(fMsg
                        .getMbvoji03(argClassStructure.getName()));
            }
            if (fieldStructure.getType() == null) {
                throw new IllegalArgumentException(fMsg.getMbvoji04(
                        argClassStructure.getName(), fieldStructure.getName()));
            }

            // tB[h̐B
            buildField(argClassStructure, fieldStructure);

            // Zb^[\bh̐B
            buildMethodSet(argClassStructure, fieldStructure);

            // Qb^[\bh̐B
            buildMethodGet(argClassStructure, fieldStructure);
        }

        if (argClassStructure.getGenerateToString()) {
            // toString\bh̐B
            buildMethodToString(argClassStructure);
        }

        // WꂽɎۂ̃\[XR[hB
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * NXɃtB[h𐶐܂B
     * 
     * @param argClassStructure
     *            NXB
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildField(
            final BlancoValueObjectClassStructure argClassStructure,
            final BlancoValueObjectFieldStructure argFieldStructure) {
        final BlancoCgField field = fCgFactory.createField("f"
                + getFieldNameAdjustered(argClassStructure, argFieldStructure),
                argFieldStructure.getType(), null);
        fCgClass.getFieldList().add(field);

        // tB[hJavaDocݒ肵܂B
        field.setDescription(argFieldStructure.getDescription());
        for (String line : argFieldStructure.getDescriptionList()) {
            field.getLangDoc().getDescriptionList().add(line);
        }
        field.getLangDoc().getDescriptionList().add(
                fBundle.getXml2javaclassFieldName(argFieldStructure.getName()));

        if (argFieldStructure.getDefault() != null) {
            // tB[h̃ftHglݒ肵܂B
            field.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassFieldDefault(argFieldStructure
                            .getDefault()));
            if (argClassStructure.getAdjustDefaultValue() == false) {
                // ftHgl̕ό`off̏ꍇɂ́A`̒l̂܂܍̗pB
                field.setDefault(argFieldStructure.getDefault());
            } else {
                final String type = field.getType().getName();

                if (type.equals("java.lang.String")) {
                    // _uNI[gt^܂B
                    field.setDefault("\""
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaSource(argFieldStructure
                                            .getDefault()) + "\"");
                } else if (type.equals("boolean") || type.equals("short")
                        || type.equals("int") || type.equals("long")) {
                    field.setDefault(argFieldStructure.getDefault());
                } else if (type.equals("java.lang.Boolean")
                        || type.equals("java.lang.Integer")
                        || type.equals("java.lang.Long")) {
                    field.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(type) + "("
                            + argFieldStructure.getDefault() + ")");
                } else if (type.equals("java.lang.Short")) {
                    field.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(type)
                            + "((short) " + argFieldStructure.getDefault()
                            + ")");
                } else if (type.equals("java.math.BigDecimal")) {
                    fCgSourceFile.getImportList().add("java.math.BigDecimal");
                    // 񂩂BigDecimalւƕϊ܂B
                    field.setDefault("new BigDecimal(\""
                            + argFieldStructure.getDefault() + "\")");
                } else if (type.equals("java.util.List")
                        || type.equals("java.util.ArrayList")) {
                    // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                    // TODO 2blancoValueObject̗pꍇɂ́ASNXC|[gÓB
                    fCgSourceFile.getImportList().add(type);
                    field.setDefault(argFieldStructure.getDefault());
                } else {
                    throw new IllegalArgumentException(fMsg.getMbvoji05(
                            argClassStructure.getName(), argFieldStructure
                                    .getName(), argFieldStructure.getDefault(),
                            type));
                }
            }
        }
    }

    /**
     * set\bh𐶐܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildMethodSet(
            final BlancoValueObjectClassStructure argClassStructure,
            final BlancoValueObjectFieldStructure argFieldStructure) {
        // ̂̂̃tB[hɑ΂Zb^[\bh𐶐܂B
        final BlancoCgMethod method = fCgFactory.createMethod("set"
                + getFieldNameAdjustered(argClassStructure, argFieldStructure),
                fBundle.getXml2javaclassSetJavadoc01(argFieldStructure
                        .getName()));
        fCgClass.getMethodList().add(method);

        // \bh JavaDocݒB
        if (argFieldStructure.getDescription() != null) {
            method.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassSetJavadoc02(argFieldStructure
                            .getDescription()));
        }
        for (String line : argFieldStructure.getDescriptionList()) {
            method.getLangDoc().getDescriptionList().add(line);
        }

        method.getParameterList().add(
                fCgFactory.createParameter("arg"
                        + getFieldNameAdjustered(argClassStructure,
                                argFieldStructure),
                        argFieldStructure.getType(),
                        fBundle.getXml2javaclassSetArgJavadoc(argFieldStructure
                                .getName())));

        // \bh̎
        method.getLineList().add(
                "f"
                        + getFieldNameAdjustered(argClassStructure,
                                argFieldStructure)
                        + " = "
                        + "arg"
                        + getFieldNameAdjustered(argClassStructure,
                                argFieldStructure) + ";");
    }

    /**
     * get\bh𐶐܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     */
    private void buildMethodGet(
            final BlancoValueObjectClassStructure argClassStructure,
            final BlancoValueObjectFieldStructure argFieldStructure) {
        // ̂̂̃tB[hɑ΂Qb^[\bh𐶐܂B
        final BlancoCgMethod method = fCgFactory.createMethod("get"
                + getFieldNameAdjustered(argClassStructure, argFieldStructure),
                fBundle.getXml2javaclassGetJavadoc01(argFieldStructure
                        .getName()));
        fCgClass.getMethodList().add(method);

        // \bh JavaDocݒB
        if (argFieldStructure.getDescription() != null) {
            method.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassGetJavadoc02(argFieldStructure
                            .getDescription()));
        }
        for (String line : argFieldStructure.getDescriptionList()) {
            method.getLangDoc().getDescriptionList().add(line);
        }
        if (argFieldStructure.getDefault() != null) {
            method.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassGetDefaultJavadoc(argFieldStructure
                            .getDefault()));
        }

        method.setReturn(fCgFactory.createReturn(argFieldStructure.getType(),
                fBundle.getXml2javaclassGetReturnJavadoc(argFieldStructure
                        .getName())));

        // \bh̎
        method.getLineList().add(
                "return f"
                        + getFieldNameAdjustered(argClassStructure,
                                argFieldStructure) + ";");
    }

    /**
     * toString\bh𐶐܂B
     * 
     * @param argClassStructure
     *            NXB
     */
    private void buildMethodToString(
            final BlancoValueObjectClassStructure argClassStructure) {
        final BlancoCgMethod method = fCgFactory.createMethod("toString",
                "̃o[IuWFNg̕\擾܂B");
        fCgClass.getMethodList().add(method);

        method.getLangDoc().getDescriptionList().add("<P>gp̒</P>");
        method.getLangDoc().getDescriptionList().add("<UL>");
        method.getLangDoc().getDescriptionList().add(
                "<LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B");
        method.getLangDoc().getDescriptionList().add(
                "<LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB");
        method.getLangDoc().getDescriptionList().add("</UL>");
        method.setReturn(fCgFactory.createReturn("java.lang.String",
                "o[IuWFNg̕\B"));
        method.getAnnotationList().add("Override");

        final List<java.lang.String> listLine = method.getLineList();

        listLine.add("final StringBuffer buf = new StringBuffer();");
        listLine.add("buf.append(\"" + argClassStructure.getPackage() + "."
                + argClassStructure.getName() + "[\");");
        for (int indexField = 0; indexField < argClassStructure.getFieldList()
                .size(); indexField++) {
            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) argClassStructure
                    .getFieldList().get(indexField);

            final String fieldNameAdjustered = (argClassStructure
                    .getAdjustFieldName() == false ? field.getName()
                    : BlancoNameAdjuster.toClassName(field.getName()));

            if (field.getType().endsWith("[]") == false) {
                listLine.add("buf.append(\"" + (indexField == 0 ? "" : ",")
                        + field.getName() + "=\" + f" + fieldNameAdjustered
                        + ");");
            } else {
                // 2006.05.31 t.iga z̏ꍇɂ́A
                // ̔z񎩐gnullǂ̃`FbNKvłB
                listLine.add("if (f" + fieldNameAdjustered + " == null) {");
                // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                listLine.add("buf.append(" + (indexField == 0 ? "\"" :
                // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                        "\",") + field.getName() + "=null\");");
                listLine.add("} else {");

                // z̏ꍇɂ̓fB[vtoString܂B
                listLine.add("buf.append("
                // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                        + (indexField == 0 ? "\"" :
                        // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                                "\",") + field.getName() + "=[\");");
                listLine.add("for (int index = 0; index < f"
                        + fieldNameAdjustered + ".length; index++) {");
                // 2006.05.31 t.iga
                // ArrayListȂǂtoStringƓlɂȂ悤ɁAJ}̂ƂɔpXy[Xt^悤ɂ܂B
                listLine.add("buf.append((index == 0 ? \"\" : \", \") + f"
                        + fieldNameAdjustered + "[index]);");
                listLine.add("}");
                listLine.add("buf.append(\"]\");");
                listLine.add("}");
            }
        }
        listLine.add("buf.append(\"]\");");
        listLine.add("return buf.toString();");
    }

    /**
     * ς݂̃tB[h擾܂B
     * 
     * @param argFieldStructure
     *            tB[hB
     * @return ̃tB[hB
     */
    private String getFieldNameAdjustered(
            final BlancoValueObjectClassStructure argClassStructure,
            final BlancoValueObjectFieldStructure argFieldStructure) {
        return (argClassStructure.getAdjustFieldName() == false ? argFieldStructure
                .getName()
                : BlancoNameAdjuster.toClassName(argFieldStructure.getName()));
    }
}
