/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2012 Toshiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.runtime.util;

public class BlancoDbRuntimeStringUtil {
    /**
     * ꂽɂāAMicrosoft Windows {Ō` String ɕϊ܂B
     * 
     * @param original ͕B
     * @return ϊ̕B
     */
    public static String convertToMsWindows31jUnicode(final String original) {
        if (original == null) {
            // null ꂽꍇɂ null ߂܂B
            return null;
        }

        // 񂪕ύXꂽǂB
        boolean isModified = false;

        final char[] charArray = original.toCharArray();
        for (int index = 0; index < charArray.length; index++) {
            switch (charArray[index]) {
            case '\u2016':
                // From: DOUBLE VERTICAL LINE
                // To: PARALLEL TO
                // half width to full width.
                charArray[index] = '\u2225';
                isModified = true;
                break;
            case '\u2212':
                // From: MINUS SIGN
                // To: FULLWIDTH HYPHEN-MINUS
                // half width to full width.
                charArray[index] = '\uFF0D';
                isModified = true;
                break;
            }
        }

        if (isModified == false) {
            // ύX͂܂łB̂܂ܕԋp܂B
            return original;
        }

        // ύXꍇ̂ݕ𐶐܂B
        return new String(charArray);
    }
}
