/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dbmetadata;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Properties;

import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * f[^x[X烁^擾郆[eBeBB
 * 
 * {Iȃ\bh܂܂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoDbMetaDataUtil {
    /**
     * w肳ꂽƂɃf[^x[Xɐڑ܂B
     * 
     * DriverManager ͗pɁAƎŃf[^x[Xڑ܂B
     * ̓NX[_[̃CX^XقȂꍇłK؂ɓ삳邽߂̑ΏłB
     * 
     * @param argJdbcDriverClassName
     *            JDBChCoENXB
     * @param argJdbcUrl
     *            JDBCڑURLB
     * @param argJdbcUser
     *            JDBCڑ[UB
     * @param argJdbcPassword
     *            JDBCڑpX[hB
     * @return f[^x[XڑB
     * @throws ClassNotFoundException
     *             NXȂꍇB
     * @throws IllegalArgumentException
     *             ڑɗOꍇB
     */
    public static Connection connect(final String argJdbcDriverClassName,
            final String argJdbcUrl, final String argJdbcUser,
            final String argJdbcPassword) throws ClassNotFoundException {
        return connect(argJdbcDriverClassName, argJdbcUrl, argJdbcUser,
                argJdbcPassword, BlancoDbMetaDataUtil.class.getClassLoader());
    }

    /**
     * w肳ꂽƂɃf[^x[Xɐڑ܂B
     * 
     * DriverManager ͗pɁAƎŃf[^x[Xڑ܂B
     * ̓NX[_[̃CX^XقȂꍇłK؂ɓ삳邽߂̑ΏłB
     * 
     * @param argJdbcDriverClassName
     *            JDBChCoENXB
     * @param argJdbcUrl
     *            JDBCڑURLB
     * @param argJdbcUser
     *            JDBCڑ[UB
     * @param argJdbcPassword
     *            JDBCڑpX[hB
     * @param loader
     *            NX[_[B
     * @return f[^x[XڑB
     * @throws ClassNotFoundException
     *             NXȂꍇB
     * @throws IllegalArgumentException
     *             ڑɗOꍇB
     */
    @SuppressWarnings( { "unchecked" })
    public static Connection connect(final String argJdbcDriverClassName,
            final String argJdbcUrl, final String argJdbcUser,
            final String argJdbcPassword, final ClassLoader loader)
            throws ClassNotFoundException {
        Connection conn = null;
        Driver driver = null;
        Class driverClass = null;
        try {
            driverClass = loader.loadClass(argJdbcDriverClassName);
        } catch (ClassNotFoundException ex) {
            throw new ClassNotFoundException("f[^x[Xڑ: JDBChCoNX["
                    + argJdbcDriverClassName + "][hɎs܂: " + ex.toString(),
                    ex);
        }

        try {
            driver = (Driver) driverClass.newInstance();
        } catch (InstantiationException e) {
            throw new IllegalArgumentException("f[^x[Xڑ: JDBChCoNX["
                    + argJdbcDriverClassName + "]̃CX^XɎs܂: "
                    + e.toString());
        } catch (IllegalAccessException e) {
            throw new IllegalArgumentException("f[^x[Xڑ: JDBChCoNX["
                    + argJdbcDriverClassName + "]̃CX^X̍ۂɃANZXᔽ܂: "
                    + e.toString());
        }

        try {
            // DriverManagergpADriverconnect()\bh𒼐ڌĂяo܂B
            // ɂANX[_[ʂł삵܂B
            final Properties info = new Properties();
            info.put("user", argJdbcUser);
            info.put("password", argJdbcPassword);
            conn = driver.connect(argJdbcUrl, info);
        } catch (SQLException ex) {
            throw new IllegalArgumentException("f[^x[Xڑ: JDBCڑɎs܂: "
                    + ex.toString());
        }

        return conn;
    }

    /**
     * w肳ꂽ URI ꗗ JDBC hCo[ENX[hNX[_[쐬܂B
     * 
     * R[h: urlArray[0] = jarFile.toURL();
     * 
     * @param urlArray
     *            ǂݍ݂ URI ꗗB
     * @param argJdbcDriverClassName
     *            hCoNXB
     * @return NX[_[̃CX^XB
     * @throws ClassNotFoundException
     *             NXȂꍇB
     */
    public static final ClassLoader loadDriverClass(final URL[] urlArray,
            final String argJdbcDriverClassName) throws ClassNotFoundException {
        try {
            final ClassLoader loader = new URLClassLoader(urlArray,
                    BlancoDbMetaDataUtil.class.getClassLoader());
            loader.loadClass(argJdbcDriverClassName);

            return loader;
        } catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("f[^x[Xڑ: JDBChCoNX["
                    + argJdbcDriverClassName + "]̃NX[hɎs܂: "
                    + e.toString());
        }
    }

    /**
     * JDBCf[^^CvJava̕ɓǂݑւ܂B
     * 
     * [java.sql.Types.]Oɕt^Java JDBC̒萔ɂȂ܂B
     * 
     * @param argJdbcDataType
     *            JDBC̃f[^^B
     * @return Java̕B
     */
    public final static String convertJdbcDataTypeToString(
            final int argJdbcDataType) {
        switch (argJdbcDataType) {
        case Types.BIT:
            return "BIT";
        case Types.TINYINT:
            return "TINYINT";
        case Types.SMALLINT:
            return "SMALLINT";
        case Types.INTEGER:
            return "INTEGER";
        case Types.BIGINT:
            return "BIGINT";
        case Types.FLOAT:
            return "FLOAT";
        case Types.REAL:
            return "REAL";
        case Types.DOUBLE:
            return "DOUBLE";
        case Types.NUMERIC:
            return "NUMERIC";
        case Types.DECIMAL:
            return "DECIMAL";
        case Types.CHAR:
            return "CHAR";
        case Types.VARCHAR:
            return "VARCHAR";
        case Types.LONGVARCHAR:
            return "LONGVARCHAR";
        case Types.NCHAR:
            return "NCHAR";
        case Types.NVARCHAR:
            return "NVARCHAR";
        case Types.LONGNVARCHAR:
            return "LONGNVARCHAR";
        case Types.DATE:
            return "DATE";
        case Types.TIME:
            return "TIME";
        case Types.TIMESTAMP:
            return "TIMESTAMP";
        case Types.BINARY:
            return "BINARY";
        case Types.VARBINARY:
            return "VARBINARY";
        case Types.LONGVARBINARY:
            return "LONGVARBINARY";
        case Types.NULL:
            return "NULL";
        case Types.OTHER:
            return "OTHER";
        case Types.JAVA_OBJECT:
            return "JAVA_OBJECT";
        case Types.DISTINCT:
            return "DISTINCT";
        case Types.STRUCT:
            return "STRUCT";
        case Types.ARRAY:
            return "ARRAY";
        case Types.BLOB:
            return "BLOB";
        case Types.CLOB:
            return "CLOB";
        case Types.REF:
            return "REF";
        case Types.DATALINK:
            return "DATALINK";
        case Types.BOOLEAN:
            return "BOOLEAN";
        case Types.ROWID:
            return "ROWID";
        default:
            // vȂꍇɂ 󔒂߂܂B
            return "";
        }
    }

    /**
     * JDBCf[^^CvJavaTypesɓǂݑւ܂B
     * 
     * @param argJdbcDataType
     *            [java.sql.Types.]Oɕt^Java JDBC̒萔ɂȂlB
     * @return java.sql.Types̒lBqbgȂꍇɂ Integer.MIN_VALUEB
     */
    public final static int convertJdbcDataType2Int(final String argJdbcDataType) {
        if (argJdbcDataType.equals("BIT")) {
            return Types.BIT;
        }
        if (argJdbcDataType.equals("TINYINT")) {
            return Types.TINYINT;
        }
        if (argJdbcDataType.equals("SMALLINT")) {
            return Types.SMALLINT;
        }
        if (argJdbcDataType.equals("INTEGER")) {
            return Types.INTEGER;
        }
        if (argJdbcDataType.equals("BIGINT")) {
            return Types.BIGINT;
        }
        if (argJdbcDataType.equals("FLOAT")) {
            return Types.FLOAT;
        }
        if (argJdbcDataType.equals("REAL")) {
            return Types.REAL;
        }
        if (argJdbcDataType.equals("DOUBLE")) {
            return Types.DOUBLE;
        }
        if (argJdbcDataType.equals("NUMERIC")) {
            return Types.NUMERIC;
        }
        if (argJdbcDataType.equals("DECIMAL")) {
            return Types.DECIMAL;
        }
        if (argJdbcDataType.equals("CHAR")) {
            return Types.CHAR;
        }
        if (argJdbcDataType.equals("VARCHAR")) {
            return Types.VARCHAR;
        }
        if (argJdbcDataType.equals("LONGVARCHAR")) {
            return Types.LONGVARCHAR;
        }
        if (argJdbcDataType.equals("NCHAR")) {
            return Types.NCHAR;
        }
        if (argJdbcDataType.equals("NVARCHAR")) {
            return Types.NVARCHAR;
        }
        if (argJdbcDataType.equals("LONGNVARCHAR")) {
            return Types.LONGNVARCHAR;
        }
        if (argJdbcDataType.equals("DATE")) {
            return Types.DATE;
        }
        if (argJdbcDataType.equals("TIME")) {
            return Types.TIME;
        }
        if (argJdbcDataType.equals("TIMESTAMP")) {
            return Types.TIMESTAMP;
        }
        if (argJdbcDataType.equals("BINARY")) {
            return Types.BINARY;
        }
        if (argJdbcDataType.equals("VARBINARY")) {
            return Types.VARBINARY;
        }
        if (argJdbcDataType.equals("LONGVARBINARY")) {
            return Types.LONGVARBINARY;
        }
        if (argJdbcDataType.equals("NULL")) {
            return Types.NULL;
        }
        if (argJdbcDataType.equals("OTHER")) {
            return Types.OTHER;
        }
        if (argJdbcDataType.equals("JAVA_OBJECT")) {
            return Types.JAVA_OBJECT;
        }
        if (argJdbcDataType.equals("DISTINCT")) {
            return Types.DISTINCT;
        }
        if (argJdbcDataType.equals("STRUCT")) {
            return Types.STRUCT;
        }
        if (argJdbcDataType.equals("ARRAY")) {
            return Types.ARRAY;
        }
        if (argJdbcDataType.equals("BLOB")) {
            return Types.BLOB;
        }
        if (argJdbcDataType.equals("CLOB")) {
            return Types.CLOB;
        }
        if (argJdbcDataType.equals("REF")) {
            return Types.REF;
        }
        if (argJdbcDataType.equals("DATALINK")) {
            return Types.DATALINK;
        }
        if (argJdbcDataType.equals("ROWID")) {
            return Types.ROWID;
        }
        if (argJdbcDataType.equals("BOOLEAN")) {
            return Types.BOOLEAN;
        }

        // m肵ȂꍇB
        return Integer.MIN_VALUE;
    }

    /**
     * JDBC  nullableJava̕ɓǂݑւ܂B
     * 
     * [java.sql.ResultSetMetaData.]Oɕt^Java JDBC̒萔ɂȂ܂B
     * 
     * @param argJdbcDataType
     *            JDBC̃f[^^B
     * @return Java񖼏́B
     */
    public final static String convertJdbcNullableToString(
            final int argJdbcDataType) {
        switch (argJdbcDataType) {
        case ResultSetMetaData.columnNoNulls:
            return "columnNoNulls";
        case ResultSetMetaData.columnNullable:
            return "columnNullable";
        case ResultSetMetaData.columnNullableUnknown:
            return "columnNullableUnknown";
        default:
            // vȂꍇɂ 󔒂߂܂B
            return "";
        }
    }

    /**
     * f[^x[X̃^Cvf[^^CvĂ܂B
     * 
     * ORACLEɂ
     * TIMESTAMP^ɑ΂ăTCYwȂꍇOTHERɂȂĂ܂܂B̍ۂɖ̂^CvĂ鏈Ȃ܂B
     * 
     * OTHER  s ̏ꍇɂ̂݁Ȁ{悤ɂĂB
     * 
     * @param columnStructure
     *            \B
     * @return trueȂĂ̌ʍXVꂽB falseȂ牽{ĂȂB
     */
    public static final boolean mapTypeName2DataType(
            final BlancoDbMetaDataColumnStructure columnStructure) {

        // f[^x[X̌^擾܂B
        String wrkTypeName = columnStructure.getTypeName().toUpperCase();

        // ()ɂTCYw؂܂B
        int indexOfTrim = wrkTypeName.indexOf('(');
        if (indexOfTrim > 0) {
            wrkTypeName = wrkTypeName.substring(0, indexOfTrim);
        }

        // JDBC^Cv̕gāA^Ă{܂B
        final int jdbcDataType = convertJdbcDataType2Int(wrkTypeName);
        if (jdbcDataType != Integer.MIN_VALUE) {
            // oꂽf[^^Cv𐳂ƂĈ܂B
            columnStructure.setDataType(jdbcDataType);
            return true;
        }

        return false;
    }
}
