/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.csv.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.csv.task.valueobject.BlancoCsvProcessInput;

/**
 * Apache Ant^XN [BlancoCsv]̃NXB
 *
 * blancoCsṽ^XNłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.csv.task]BlancoCsvBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancocsv&quot; classname=&quot;blanco.csv.task.BlancoCsvTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoCsvTask extends Task {
    /**
     * blancoCsṽ^XNłB
     */
    protected BlancoCsvProcessInput fInput = new BlancoCsvProcessInput();

    /**
     * tB[h [metadir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldMetadirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * tB[h [encoding] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldEncodingProcessed = false;

    /**
     * tB[h [runtimepackage] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldRuntimepackageProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^t@Ci[fBNgw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
        fIsFieldMetadirProcessed = true;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^t@Ci[fBNgw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[encoding]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setEncoding(final String arg) {
        fInput.setEncoding(arg);
        fIsFieldEncodingProcessed = true;
    }

    /**
     * Ant^XN[encoding]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * \[Xt@C̕GR[fBOw肵܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getEncoding() {
        return fInput.getEncoding();
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * ^CNX𐶐鐶w肵܂Bw̏ꍇɂ t@C`(CSV)̒lɐ܂B<br>
     *
     * @param arg Zbgl
     */
    public void setRuntimepackage(final String arg) {
        fInput.setRuntimepackage(arg);
        fIsFieldRuntimepackageProcessed = true;
    }

    /**
     * Ant^XN[runtimepackage]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * ^CNX𐶐鐶w肵܂Bw̏ꍇɂ t@C`(CSV)̒lɐ܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getRuntimepackage() {
        return fInput.getRuntimepackage();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoCsvTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldMetadirProcessed == false) {
            throw new BuildException("K{Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- encoding:[" + getEncoding() + "]");
            System.out.println("- runtimepackage:[" + getRuntimepackage() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoCsvProcessC^tF[X blanco.csv.taskpbP[W BlancoCsvProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoCsvProcess proc = new BlancoCsvProcessImpl();
            if (proc.execute(fInput) != BlancoCsvBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
