/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.commons.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/**
 * blanco Framework̖Oό`Ɋւ郆[eBeBW߂NXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoNameAdjuster {
    /**
     * blanco Framework̖Oό`ƂāAׂł邩ǂ`FbN܂B
     * 
     * JavãNX⃁\bhƂėpsK؂ƍl镶ł邩ǂ𔻒fĂ܂B<br>
     * dl㗘p\ȕłĂAblanco FrameworkƂĂ͗p߂Ȃ͒ƂĔf܂B
     * 
     * @param checkChar
     *            `FbNs͕B
     * @return ׂƔfꍇɂtrue߂܂B
     */
    public static final boolean checkAdjustChar(final char checkChar) {
        switch (checkChar) {
        case '!':
        case '"':
        case '#':
        case '%':
        case '&':
        case '\'':
        case '(':
        case ')':
        case '-':
        case '=':
        case '^':
        case '~':
        case '\\':
        case '|':
        case '@':
        case '[':
        case ']':
        case '{':
        case '}':
        case ';':
        case '+':
        case ':':
        case '*':
        case '<':
        case '>':
        case ',':
        case '.':
        case '/':
        case '?':
        case '_':
        case ' ':
            // ׂłƔf܂B
            return true;
        default:
            return false;
        }
    }

    /**
     * blanco Framework̖Oό`ƂāAׂł邩ǂ`FbN܂B
     * 
     * JavãNX⃁\bhƂėpsK؂ƍl镶܂܂Ă邩ǂ𔻒fĂ܂B<br>
     * dl㗘p\ȕłĂAblanco FrameworkƂĂ͗p߂Ȃ͒ƂĔf܂B
     * 
     * @param checkChar
     *            `FbNs͕B
     * @return ׂƔfꍇɂtrue߂܂B
     */
    public static final boolean checkAdjustCharExist(final String checkChar) {
        if (checkChar == null) {
            throw new IllegalArgumentException(
                    "񂪊܂܂邩ǂ`FbN郁\bh (BlancoNameAdjuster.checkAdjustCharExist) null^܂Ã\bhnull^邱Ƃ͂ł܂B");
        }

        for (int index = 0; index < checkChar.length(); index++) {
            if (checkAdjustChar(checkChar.charAt(index))) {
                return true;
            }
        }
        return false;
    }

    /**
     * ^ꂽ̐擪̕啶ɂȂ悤ɖOό`܂B
     * 
     * @param originalString
     *            ͕BnullȊO̕^܂B0̕^邱Ƃ͋Ă܂B
     * @return ό`̕
     */
    public static final String toUpperCaseTitle(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "̐擪啶ɕϊ郋[`null^܂B");
        }
        if (originalString.length() == 0) {
            // 0̕ɂẮAĂ܂B̂܂ܖ߂܂B
            return originalString;
        }

        final char[] buf = originalString.toCharArray();
        if (buf[0] != Character.toUpperCase(buf[0])) {
            // 擪啶ł͖̂ŁA擪啶ɕϊ܂B
            buf[0] = Character.toUpperCase(buf[0]);
            // ό`̕߂܂B
            return new String(buf);
        } else {
            // ό`̕Kv̂ŁÂ͕܂ܖ߂܂B
            return originalString;
        }
    }

    /**
     * ^ꂽ̐擪̕ɂȂ悤ɖOό`܂B
     * 
     * 
     * @param originalString
     *            ͕BnullȊO̕^܂B0̕^邱Ƃ͋Ă܂B
     * @return ό`̕
     */
    public static final String toLowerCaseTitle(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "̐擪ɕϊ郋[`null^܂B");
        }
        if (originalString.length() == 0) {
            // 0̕ɂẮAĂ܂B̂܂ܖ߂܂B
            return originalString;
        }

        final char[] buf = originalString.toCharArray();
        if (buf[0] != Character.toLowerCase(buf[0])) {
            // 擪ł͖̂ŁA擪ɕϊ܂B
            buf[0] = Character.toLowerCase(buf[0]);
            // ό`̕߂܂B
            return new String(buf);
        } else {
            // ό`̕Kv̂ŁÂ͕܂ܖ߂܂B
            return originalString;
        }
    }

    /**
     * ^ꂽSđ啶łꍇɂ́A擪ȊO̕Sďɕϊ܂B
     * 
     * Sđ啶Ał͂Ȃđ啶肩ɂēςĂ܂B<br>
     * ̃\bh blanco Framework̓Ăяo邱Ƃz肵Ă܂B
     * 
     * @param originalString
     *            ͕B
     * @return ό`̕
     */
    public static final String weakenUpperCase(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "񂪑Sđ啶łꍇɁA擪ȊOɕϊ郋[`null^܂B");
        }

        if (originalString.equals(originalString.toUpperCase())) {
            // ^ꂽ̑SĂ啶łB
            // 擪݂̂啶ŁAȊO͏ɂȂ悤ɕϊ܂B
            return toUpperCaseTitle(originalString.toLowerCase());
        } else {
            // ό`̕Kv̂œ͕̂܂ܖ߂܂B
            return originalString;
        }
    }

    /**
     * ^ꂽAblanco Frameworkɂ钲ׂɊւĒႵĕ̕ւƕ܂B
     * 
     * Sđ啶Ƃꍇɂ́A擪ȊO͏ɕϊƂIɊ܂܂Ă܂B<br>
     * 񕪊̌ʁAz̒ɂ͒0̕񂪊܂܂\_ɒӂėpĂB
     * 
     * @param originalString
     *            ͕B
     * @return ŕꂽ̔zB
     */
    public static final String[] splitByAdjustChar(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "Ƃɕ𕪊郁\bh (BlancoNameAdjuster.splitByAdjustChar) null^܂B̃\bhnull^邱Ƃ͂ł܂B");
        }

        final List<java.lang.String> result = new ArrayList<java.lang.String>();
        final char[] bufRead = originalString.toCharArray();
        final CharArrayWriter writerWork = new CharArrayWriter();
        for (int index = 0; index < bufRead.length; index++) {
            if (checkAdjustChar(bufRead[index])) {
                // ׂ܂Bs܂B
                writerWork.flush();
                result.add(weakenUpperCase(writerWork.toString()));
                writerWork.reset();
            } else {
                // ȊO̕łBߍ݂s܂B
                writerWork.write(bufRead[index]);
            }
        }
        writerWork.flush();
        result.add(weakenUpperCase(writerWork.toString()));
        final String[] ret = new String[result.size()];
        return (String[]) result.toArray(ret);
    }

    /**
     * ^ꂽ blanco FrameworkƂĂ̖Oό`[ɏ]đÓȃNXւƖOό`܂B
     * 
     * ̃\bh blanco Framework̂Ȃ悭p郁\bhłBNXւƖOό`Kvȋǖʂł悭p܂B
     * 
     * @param originalString
     *            ͕B
     * @return NXƂĕό`ꂽ̕B
     */
    public static final String toClassName(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "NXւƖOό`郁\bh (BlancoNameAdjuster.toClassName) null^܂B̃\bhnull^邱Ƃ͂ł܂B");
        }

        final StringWriter result = new StringWriter();
        // 𒲐ŋ؂܂B
        // ŋ؂̕啶̏ꍇɂ́A擪ȊO͏̕ւƕϊ܂B
        final String[] work = splitByAdjustChar(originalString);
        for (int index = 0; index < work.length; index++) {
            if (work[index].length() == 0) {
                // 0̏ꍇ͏XLbv܂B
                continue;
            }
            // ŋ؂ꂽƂ̕ɂāA擪啶ւƕό`܂B
            result.write(toUpperCaseTitle(work[index]));
        }
        try {
            result.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(
                    "NXɒ郋[`ɂāA͂̂ȂO܂B:" + e.toString());
        }
        return result.toString();
    }

    /**
     * ^ꂽ blanco FrameworkƂĂ̖Oό`[ɏ]đÓȃp[^ւƖOό`܂B
     * 
     * Iɂ́AtoClassNameĂяo 擪ւƕό`Ă܂B
     * 
     * @param originalString
     *            ͕B
     * @return p[^Ƃĕό`ꂽ̕B
     */
    public static final String toParameterName(final String originalString) {
        if (originalString == null) {
            throw new IllegalArgumentException(
                    "p[^ւƖOό`郁\bh (BlancoNameAdjuster.toParameterName) null^܂B̃\bhnull^邱Ƃ͂ł܂B");
        }

        // NXւƖOό`ɐ擪ւƕό`܂B
        return toLowerCaseTitle(toClassName(originalString));
    }
}
