/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2011 Toshiki IGA
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2011 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
package blanco.eclipseast2cg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;

import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * Eclipse AST から blanco Cg へ変換するためのパーサーです。
 * 
 * @author Toshiki IGA
 */
public class BlancoEclipseAST2CgParser {
    /**
     * ソースコードの文字列エンコーディング。
     * 
     * FIXME エンコーディングを外から与える方法を提供すること
     */
    String encoding = "UTF-8";

    /**
     * ソースコードのパッケージ。
     */
    String sourcePackage = "noname";

    /**
     * ソースコードのファイル名。
     */
    String fileName = "noname";

    /**
     * Parse given file.
     * 
     * @param file
     *            Input file.
     * @return Result of parse.
     * @throws IOException
     *             例外が発生した場合。
     */
    public BlancoCgSourceFile parse(final File file) throws IOException {
        final InputStream inStream = new FileInputStream(file);
        try {
            return parse(inStream);
        } finally {
            inStream.close();
        }
    }

    public BlancoCgSourceFile parse(final InputStream inStream) throws IOException {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, encoding));
        return parse(reader);
    }

    public BlancoCgSourceFile parse(final BufferedReader reader) throws IOException {
        final StringBuffer strBuf = new StringBuffer();
        for (;;) {
            final String line = reader.readLine();
            if (line == null)
                break;
            strBuf.append(line + "\n");
        }

        return parse(strBuf.toString().toCharArray());
    }

    public BlancoCgSourceFile parse(final char[] source) throws IOException {
        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(source);
        final CompilationUnit unit = (CompilationUnit) parser.createAST(new NullProgressMonitor());

        final BlancoEclipseAST2CgVisitor visitor = new BlancoEclipseAST2CgVisitor(sourcePackage);
        unit.accept(visitor);

        return visitor.getCgSourceFile();
    }
}
