/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * blancoCg ̃\[XohB
 *
 * \[Xoh`: [BlancoCg]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoCgResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoCgResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCg]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoCgResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/cg/resourcebundle/BlancoCg");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoCgResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCg]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoCgResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/cg/resourcebundle/BlancoCg", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoCgResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoCg]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoCgResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/cg/resourcebundle/BlancoCg", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoCg], key[DEFAULT_FILE_COMMENT]
     *
     * [̃\[XR[h blanco Frameworkɂ莩܂B] (ja)<br>
     *
     * @return key[DEFAULT_FILE_COMMENT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getDefaultFileComment() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̃\[XR[h blanco Frameworkɂ莩܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("DEFAULT_FILE_COMMENT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoCg], key[FILE_HEADER_PATH]
     *
     * [./meta/program/fileheader.txt] (ja)<br>
     *
     * @return key[FILE_HEADER_PATH]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getFileHeaderPath() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "./meta/program/fileheader.txt";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("FILE_HEADER_PATH");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
