/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.logmessage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.logmessage.message.BlancoLogMessageMessage;
import blanco.logmessage.valueobject.BlancoLogMessageFieldStructure;
import blanco.logmessage.valueobject.BlancoLogMessageStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ubZ[W`vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoLogMessageXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoLogMessageMessage fMsg = new BlancoLogMessageMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoLogMessageStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoLogMessageStructure[] parse(
            final BlancoXmlDocument argXmlDocument) {
        final List<BlancoLogMessageStructure> listStructure = new ArrayList<BlancoLogMessageStructure>();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final BlancoLogMessageStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoLogMessageStructure[] result = new BlancoLogMessageStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoLogMessageStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoLogMessageStructure structure = new BlancoLogMessageStructure();
        // ̓p[^擾܂B

        final List<BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                .getElementsByTagName(argElementSheet, "blancomessage-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = listCommon.get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "package"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbmsgi01(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "suffix"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "idEmbedding") != null) {
            structure.setIdEmbedding("true".equals(BlancoXmlBindingUtil
                    .getTextContent(elementCommon, "idEmbedding")));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "stdout") != null) {
            structure.setStdout("true".equals(BlancoXmlBindingUtil
                    .getTextContent(elementCommon, "stdout")));
        }

        final BlancoXmlElement elementMessageList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancomessage-list");
        if (elementMessageList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                .getElementsByTagName(elementMessageList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final BlancoXmlElement elementField = listField.get(indexField);

            final BlancoLogMessageFieldStructure fieldStructure = new BlancoLogMessageFieldStructure();

            fieldStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            fieldStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "key"));
            if (BlancoStringUtil.null2Blank(fieldStructure.getName()).length() == 0) {
                // keyw肳ĂȂꍇɂ͏܂B
                continue;
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "level"))
                    .length() > 0) {
                fieldStructure.setLevel(BlancoXmlBindingUtil.getTextContent(
                        elementField, "level"));
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "value"))
                    .length() > 0) {
                fieldStructure.setMessage(BlancoXmlBindingUtil.getTextContent(
                        elementField, "value"));
            }

            if (BlancoStringUtil.null2Blank(fieldStructure.getMessage())
                    .length() == 0) {
                // ŌxB
                continue;
            }

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getFieldList().size(); indexPast++) {
                final BlancoLogMessageFieldStructure fieldPast = (BlancoLogMessageFieldStructure) structure
                        .getFieldList().get(indexPast);
                if (fieldPast.getName().equals(fieldStructure.getName())) {
                    throw new IllegalArgumentException(fMsg.getMbmsgi03(
                            structure.getName(), fieldStructure.getName()));
                }
            }

            structure.getFieldList().add(fieldStructure);
        }

        return structure;
    }
}
