/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.java;

import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgEnum;
import blanco.cg.valueobject.BlancoCgEnumElement;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgEnum\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgEnumJavaSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.JAVA;

    /**
     * ŗ񋓑̂WJ܂B
     * 
     * @param cgEnum
     *            ΏۂƂȂ񋓑́B
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     * @param argIsInterface
     *            C^tF[XǂBNX̏ꍇɂfalseBC^tF[X̏ꍇɂtrueB
     */
    public void transformEnum(final BlancoCgEnum cgEnum,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        if (BlancoStringUtil.null2Blank(cgEnum.getName()).length() == 0) {
            throw new IllegalArgumentException("񋓑̖̂OɓK؂Ȓlݒ肳Ă܂B");
        }

        // L킳st^܂B
        argSourceLines.add("");

        // ŏɃtB[hLangDocɓWJB
        if (cgEnum.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgEnum.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgEnum.getLangDoc().getTitle() == null) {
            cgEnum.getLangDoc().setTitle(cgEnum.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocJavaSourceExpander().transformLangDoc(cgEnum
                .getLangDoc(), argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgEnum.getAccess()).length() > 0) {
            buf.append(cgEnum.getAccess() + " ");
        }

        // 񋓑̖̐{̕WJ܂B
        buf.append("enum " + cgEnum.getName());

        // vfWJ܂B
        buf.append("{");
        boolean isFirstElement = true;
        for (BlancoCgEnumElement element : cgEnum.getElementList()) {
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                buf.append(", ");
            }
            buf.append(element.getName());
            if (BlancoStringUtil.null2Blank(element.getDescription()).length() > 0) {
                buf.append(" /* "
                        + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                                element.getDescription()) + " */");
            }
        }
        buf.append("}");

        buf.append(BlancoCgLineUtil.getTerminator(TARGET_LANG));
        argSourceLines.add(buf.toString());
    }
}
