/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.dbee.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import blanco.commons.util.BlancoNameUtil;
import blanco.db.common.message.BlancoDbCommonPluginMessage;

public class BlancoDbEEWizardPage3 extends WizardPage {

    public BlancoDbEEWizardPage3(ISelection selection) {
        super("wizardPage");
        setTitle("blancoDbEE vOC̃CXg[");
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;

        Composite container = new Composite(parent, SWT.NULL);
        container.setLayout(gridLayout);

        new Label(container, SWT.NONE)
                .setText("blancoDbEE vOC𓮍삳邽߂ɂ́AL̂̂KvłB");
        new Label(container, SWT.NONE)
                .setText("  1.Eclipse 3.2 ܂͂ȏ̃o[W EclipseB");
        new Label(container, SWT.NONE)
                .setText("  2.R/O}bsO쐬Ώۃf[^x[X JDBC hCoB");
        new Label(container, SWT.NONE)
                .setText("  3.Excel(*.xls) t@C`ǂݏ\ȃAvP[V\tgB");
        new Label(container, SWT.NONE)
                .setText("    SQL` Excel(*.xls) t@C`ŕۑ܂B");
        new Label(container, SWT.NONE)
                .setText("    ̂ Excel(*.xls) t@C`ǂݏ\ȃAvP[V\tgKvɂȂ܂B");
        new Label(container, SWT.NONE).setText("");

        final String[] strMsgs = BlancoNameUtil.splitString(
                new BlancoDbCommonPluginMessage().getMbdbcmi01(), '\n');
        for (String msg : strMsgs) {
            new Label(container, SWT.NONE).setText(msg);
        }

        setControl(container);
    }
}