/*
 * net/balusc/jsf/renderer/html/FileRenderer.java
 * 
 * Copyright (C) 2009 BalusC
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library.
 * If not, see <http://www.gnu.org/licenses/>.
 */
package net.balusc.jsf.renderer.html;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.render.FacesRenderer;

import net.balusc.http.multipart.MultipartRequest;
import net.balusc.http.multipart.UploadedFile;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.TextRenderer;

/**
 * <code>input type="file"</code> フィールドの Faces レンダラーです。
 * 
 * @author BalusC
 * @link 
 *       http://balusc.blogspot.com/2009/12/uploading-files-with-jsf-20-and-servlet
 *       .html
 */
@FacesRenderer(componentFamily = "javax.faces.Input", rendererType = "javax.faces.File")
public class FileRenderer extends TextRenderer {

	// 定数。
	// ----------------------------------------------------------------------------------

	private static final String EMPTY_STRING = "";
	private static final Attribute[] INPUT_ATTRIBUTES = AttributeManager
			.getAttributes(AttributeManager.Key.INPUTTEXT);

	// アクション。
	// ------------------------------------------------------------------------------------

	@Override
	protected void getEndTextToRender(final FacesContext context,
			final UIComponent component, final String currentValue)
			throws IOException {
		final ResponseWriter writer = context.getResponseWriter();
		writer.startElement("input", component);
		writeIdAttributeIfNecessary(context, writer, component);
		writer.writeAttribute("type", "file", null);
		writer.writeAttribute("name", (component.getClientId(context)),
				"clientId");

		// Render styleClass, if any.
		final String styleClass = (String) component.getAttributes().get(
				"styleClass");
		if (styleClass != null) {
			writer.writeAttribute("class", styleClass, "styleClass");
		}

		// styleClass 以外の標準 HTMLattributes をレンダリング。
		RenderKitUtils.renderPassThruAttributes(context, writer, component,
				INPUT_ATTRIBUTES, getNonOnChangeBehaviors(component));
		RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
		RenderKitUtils.renderOnchange(context, component, false);

		writer.endElement("input");
	}

	@Override
	public void decode(final FacesContext context, final UIComponent component) {
		rendererParamsNotNull(context, component);
		if (!shouldDecode(component)) {
			return;
		}
		String clientId = decodeBehaviors(context, component);
		if (clientId == null) {
			clientId = component.getClientId(context);
		}
		final UploadedFile file = ((MultipartRequest) context
				.getExternalContext().getRequest()).getFile(clientId);

		// If no file is specified, set empty String to trigger validators.
		((UIInput) component).setSubmittedValue((file != null) ? file
				: EMPTY_STRING);
	}

	@Override
	public Object getConvertedValue(final FacesContext context,
			final UIComponent component, final Object submittedValue)
			throws ConverterException {
		return (submittedValue != EMPTY_STRING) ? submittedValue : null;
	}
}