/*
 * net/balusc/http/multipart/UploadedFile.java
 * 
 * Copyright (C) 2011 Tosiki IGA
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this library.
 * If not, see <http://www.gnu.org/licenses/>.
 */
package net.balusc.http.multipart;

/**
 * MultipartMap を利用してアップロードされたファイルをあらわすクラス。
 * 
 * @author Tosiki IGA
 */
public class UploadedFile {
	/**
	 * ファイル名。
	 */
	protected String fileName;

	/**
	 * ファイルの内容。
	 */
	protected byte[] data;

	/**
	 * 指定したファイル名でオブジェクトを生成します。
	 * 
	 * @param fileName
	 *            ファイル名。
	 */
	public UploadedFile(final String fileName) {
		this.fileName = fileName;
	}

	/**
	 * ファイル名を取得します。
	 * 
	 * @return ファイル名。
	 */
	public String getName() {
		return fileName;
	}

	/**
	 * ファイルデータを設定します。
	 * 
	 * @param data
	 *            ファイルデータ。
	 */
	public void setData(byte[] data) {
		this.data = data;
	}

	/**
	 * ファイルデータを取得します。
	 * 
	 * @return ファイルデータ。
	 */
	public byte[] getData() {
		return data;
	}

	/**
	 * ファイルのサイズを取得します。
	 * 
	 * @return
	 */
	public long getSize() {
		return data.length;
	}
}
