/*
 * アップロードの使い方サンプル。
 */
package net.balusc.example.upload;

import java.util.Arrays;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;

import net.balusc.http.multipart.UploadedFile;

/**
 * 「net.balusc.jsf.upload」を利用したアップロードの実際の利用サンプルです。
 * 
 * @author Tosiki IGA
 */
@ManagedBean
@RequestScoped
public class UploadBean {

	private String text;
	private UploadedFile file;
	private String[] check;

	public void submit() {
		// Now do your thing with the obtained input.
		System.out.println("Text: " + text);
		System.out.println("File: " + file);
		System.out.println("Check: " + Arrays.toString(check));
	}

	public String getText() {
		return text;
	}

	public UploadedFile getFile() {
		return file;
	}

	public String[] getCheck() {
		return check;
	}

	public void setText(String text) {
		this.text = text;
	}

	public void setFile(UploadedFile file) {
		this.file = file;
	}

	public void setCheck(String[] check) {
		this.check = check;
	}
}