/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.constants;

import java.io.File;
import java.io.IOException;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.constants.message.BlancoConstantsMessage;
import blanco.constants.resourcebundle.BlancoConstantsResourceBundle;
import blanco.constants.valueobject.BlancoConstantsFieldStructure;
import blanco.constants.valueobject.BlancoConstantsStructure;

/**
 * XMLt@CJava\[XR[hNXłB
 * 
 * 萔`(XLS)\[XR[hvWFNg̈ꕔłB
 * 
 * @author IGA Tosiki
 */
public class BlancoConstantsXml2JavaClass {
    /**
     * bZ[WB
     */
    private final BlancoConstantsMessage fMsg = new BlancoConstantsMessage();

    /**
     * \[Xohւ̃ANZTNX̃IuWFNgB
     */
    private final BlancoConstantsResourceBundle fBundle = new BlancoConstantsResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@CJava\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param argDirectoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {
        final BlancoConstantsStructure[] structures = new BlancoConstantsXmlParser()
                .parse(argMetaXmlSourceFile);
        for (int index = 0; index < structures.length; index++) {
            // ꂽ񂩂Java\[XR[h𐶐܂B
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * WꂽɁAJava\[XR[ho͂܂B
     * 
     * @param processStructure
     *            \
     * @param directoryTarget
     *            o͐tH_B
     */
    public void structure2Source(
            final BlancoConstantsStructure processStructure,
            final File directoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getPackage(), null);
        fCgSourceFile.setEncoding(fEncoding);
        fCgClass = fCgFactory.createClass(processStructure.getName()
                + BlancoStringUtil.null2Blank(processStructure.getSuffix()),
                BlancoStringUtil.null2Blank(processStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        // NX̃ANZXݒB
        fCgClass.setAccess(processStructure.getAccess());
        // ۃNXǂB
        fCgClass.setAbstract(processStructure.getAbstract());

        // p
        if (BlancoStringUtil.null2Blank(processStructure.getExtends()).length() > 0) {
            fCgClass.getExtendClassList().add(
                    fCgFactory.createType(processStructure.getExtends()));
        }

        for (int indexField = 0; indexField < processStructure.getFieldList()
                .size(); indexField++) {
            BlancoConstantsFieldStructure fieldLook = (BlancoConstantsFieldStructure) processStructure
                    .getFieldList().get(indexField);
            final BlancoCgField field = fCgFactory.createField(fieldLook
                    .getName(), fieldLook.getType(), "");
            fCgClass.getFieldList().add(field);

            field.setAccess("public");
            field.setFinal(true);
            field.setStatic(true);

            if (fieldLook.getNo() != null) {
                field.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2javaclassFieldNo(fieldLook.getNo()));
            }
            if (fieldLook.getDescription() != null) {
                field.getLangDoc().getDescriptionList().add(
                        fieldLook.getDescription());
            }

            if (processStructure.getAdjustConstValue() == false) {
                // ̂܂ܑ܂B
                field.setDefault(fieldLook.getValue());
            } else {
                // ^ɂăftHgl܂B
                // ΉȂ^^ꂽꍇɂ͗O𔭐܂B
                if (fieldLook.getType().equals("java.lang.String")) {
                    field.setDefault("\""
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaSource(fieldLook
                                            .getValue()) + "\"");
                } else if (fieldLook.getType().equals("boolean")
                        || fieldLook.getType().equals("short")
                        || fieldLook.getType().equals("int")
                        || fieldLook.getType().equals("long")) {
                    field.setDefault(fieldLook.getValue());
                } else if (fieldLook.getType().equals("java.lang.Boolean")
                        || fieldLook.getType().equals("java.lang.Integer")
                        || fieldLook.getType().equals("java.lang.Long")) {
                    field.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(fieldLook
                                    .getType()) + "(" + fieldLook.getValue()
                            + ")");
                } else if (fieldLook.getType().equals("java.lang.Short")) {
                    field.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(fieldLook
                                    .getType()) + "((short) "
                            + fieldLook.getValue() + ")");
                } else if (fieldLook.getType().equals("java.math.BigDecimal")) {
                    fCgSourceFile.getImportList().add("java.math.BigDecimal");
                    field.setDefault("new BigDecimal(\"" + fieldLook.getValue()
                            + "\")");
                } else if (fieldLook.getType().equals("java.util.ArrayList")) {
                    // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                    fCgSourceFile.getImportList().add("java.util.ArrayList");
                    field.setDefault(fieldLook.getValue());
                } else {
                    throw new IllegalArgumentException(fMsg.getMbctji04(
                            processStructure.getName(), fieldLook.getName(),
                            fieldLook.getValue(), fieldLook.getType()));
                }
            }
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
