/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.caller;

import java.util.HashMap;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.util.BlancoDbQueryParserUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;
import blanco.db.util.BlancoDbMappingUtilDotNet;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Tosiki Iga
 */
public class GetCallerOutputParameterMethodDotNet extends
        BlancoDbAbstractMethod {
    private BlancoDbMetaDataColumnStructure fColumnStructure = null;

    public GetCallerOutputParameterMethodDotNet(
            final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass,
            final BlancoDbMetaDataColumnStructure columnStructure) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
        this.fColumnStructure = columnStructure;
    }

    @SuppressWarnings("unchecked")
    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("Get"
                + BlancoNameAdjuster.toClassName(fColumnStructure.getName()),
                null);
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add(
                "XgAhvV[W̎sʂ̏o̓p[^擾܂B");
        cgMethod.getLangDoc().getDescriptionList().add(
                "XgAhvV[W̎sʂƂĖ߂Ƃł̂͒lЂƂłB");
        cgMethod.getLangDoc().getDescriptionList()
                .add("NGɗ^̓p[^Zbg܂B");

        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn(BlancoDbMappingUtilDotNet
                .getFullClassName(fColumnStructure), ""));

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        final BlancoDbQueryParserUtil query = new BlancoDbQueryParserUtil(
                fSqlInfo.getQuery());

        // ɏp[^̃}bvB
        final HashMap mapProcessedParam = new HashMap();

        for (int indexParameter = 0; indexParameter < fSqlInfo
                .getOutParameterList().size(); indexParameter++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                    .getOutParameterList().get(indexParameter);

            final int[] listCol = query.getSqlParameters(columnStructure
                    .getName());
            if (listCol == null) {
                throw new IllegalArgumentException("SQL`ID["
                        + fSqlInfo.getName() + "] SQLo̓p[^["
                        + columnStructure.getName() + "]тĂ܂.");
            }

            if (columnStructure.getName().equals(fColumnStructure.getName()) == false) {
                // ^[Qbgł͂Ȃ̂ŏXLbv܂B
                continue;
            }

            // ɏς̃p[^ƂċL܂B
            mapProcessedParam.put(columnStructure.getName(), columnStructure);

            if (BlancoDbMappingUtilDotNet
                    .getPrimitiveAndNullable(columnStructure)) {
                listLine
                        .add("// ̃o[WblancoDbDotNetłnulli[Ăꍇ̎擾ʂADO.NETɈˑ܂B");
            }
            listLine.add("return ("
                    + BlancoDbMappingUtilDotNet
                            .getFullClassName(columnStructure)
                    + ") fStatement.Parameters[\"@" + columnStructure.getName()
                    + "\"].Value;");
        }
    }
}