/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.valueobject;

import java.util.List;

/**
 * \[Xoh킷\̃NXBꖼpbP[WȂǊ{񂪊܂܂܂B
 */
public class BlancoResourceBundleBundleStructure {
    /**
     * \[Xoh̊ꖼB
     *
     * tB[h: [name]B
     */
    private String fName;

    /**
     * ̃\[XohΉ郍P[̈ꗗB(Combinȅꍇɂ̂ݗL)
     *
     * tB[h: [listLocale]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     */
    private List<java.lang.String> fListLocale = new java.util.ArrayList<java.lang.String>();

    /**
     * pbP[WB
     *
     * tB[h: [package]B
     */
    private String fPackage;

    /**
     * NXɕt^TtBbNXB
     *
     * tB[h: [suffix]B
     */
    private String fSuffix;

    /**
     * ̃\[Xohɑ΂B
     *
     * tB[h: [description]B
     */
    private String fDescription;

    /**
     * ̃NX̃ANZXB{Iɂ public ŗp܂B
     *
     * tB[h: [access]B
     * ftHg: ["public"]B
     */
    private String fAccess = "public";

    /**
     * eL[{l̏B
     *
     * tB[h: [itemList]B
     * ftHg: [new java.util.ArrayList<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure>()]B
     */
    private List<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure> fItemList = new java.util.ArrayList<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure>();

    /**
     * [NɗptB[hB
     *
     * tB[h: [resourceItem]B
     */
    private BlancoResourceBundleBundleItemStructure fResourceItem;

    /**
     * ݏĂ郍P[L܂B
     *
     * tB[h: [currentLocale]B
     */
    private String fCurrentLocale;

    /**
     * ݏĂ郊\[XL܂B
     *
     * tB[h: [currentResourceString]B
     */
    private String fCurrentResourceString;

    /**
     * tB[h [name] ̒lݒ肵܂B
     *
     * tB[h̐: [\[Xoh̊ꖼB]B
     *
     * @param argName tB[h[name]ɐݒ肷lB
     */
    public void setName(final String argName) {
        fName = argName;
    }

    /**
     * tB[h [name] ̒l擾܂B
     *
     * tB[h̐: [\[Xoh̊ꖼB]B
     *
     * @return tB[h[name]擾lB
     */
    public String getName() {
        return fName;
    }

    /**
     * tB[h [listLocale] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\[XohΉ郍P[̈ꗗB(Combinȅꍇɂ̂ݗL)]B
     *
     * @param argListLocale tB[h[listLocale]ɐݒ肷lB
     */
    public void setListLocale(final List<java.lang.String> argListLocale) {
        fListLocale = argListLocale;
    }

    /**
     * tB[h [listLocale] ̒l擾܂B
     *
     * tB[h̐: [̃\[XohΉ郍P[̈ꗗB(Combinȅꍇɂ̂ݗL)]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     *
     * @return tB[h[listLocale]擾lB
     */
    public List<java.lang.String> getListLocale() {
        return fListLocale;
    }

    /**
     * tB[h [package] ̒lݒ肵܂B
     *
     * tB[h̐: [pbP[WB]B
     *
     * @param argPackage tB[h[package]ɐݒ肷lB
     */
    public void setPackage(final String argPackage) {
        fPackage = argPackage;
    }

    /**
     * tB[h [package] ̒l擾܂B
     *
     * tB[h̐: [pbP[WB]B
     *
     * @return tB[h[package]擾lB
     */
    public String getPackage() {
        return fPackage;
    }

    /**
     * tB[h [suffix] ̒lݒ肵܂B
     *
     * tB[h̐: [NXɕt^TtBbNXB]B
     *
     * @param argSuffix tB[h[suffix]ɐݒ肷lB
     */
    public void setSuffix(final String argSuffix) {
        fSuffix = argSuffix;
    }

    /**
     * tB[h [suffix] ̒l擾܂B
     *
     * tB[h̐: [NXɕt^TtBbNXB]B
     *
     * @return tB[h[suffix]擾lB
     */
    public String getSuffix() {
        return fSuffix;
    }

    /**
     * tB[h [description] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\[Xohɑ΂B]B
     *
     * @param argDescription tB[h[description]ɐݒ肷lB
     */
    public void setDescription(final String argDescription) {
        fDescription = argDescription;
    }

    /**
     * tB[h [description] ̒l擾܂B
     *
     * tB[h̐: [̃\[Xohɑ΂B]B
     *
     * @return tB[h[description]擾lB
     */
    public String getDescription() {
        return fDescription;
    }

    /**
     * tB[h [access] ̒lݒ肵܂B
     *
     * tB[h̐: [̃NX̃ANZXB{Iɂ public ŗp܂B]B
     *
     * @param argAccess tB[h[access]ɐݒ肷lB
     */
    public void setAccess(final String argAccess) {
        fAccess = argAccess;
    }

    /**
     * tB[h [access] ̒l擾܂B
     *
     * tB[h̐: [̃NX̃ANZXB{Iɂ public ŗp܂B]B
     * ftHg: ["public"]B
     *
     * @return tB[h[access]擾lB
     */
    public String getAccess() {
        return fAccess;
    }

    /**
     * tB[h [itemList] ̒lݒ肵܂B
     *
     * tB[h̐: [eL[{l̏B]B
     *
     * @param argItemList tB[h[itemList]ɐݒ肷lB
     */
    public void setItemList(final List<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure> argItemList) {
        fItemList = argItemList;
    }

    /**
     * tB[h [itemList] ̒l擾܂B
     *
     * tB[h̐: [eL[{l̏B]B
     * ftHg: [new java.util.ArrayList<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure>()]B
     *
     * @return tB[h[itemList]擾lB
     */
    public List<blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure> getItemList() {
        return fItemList;
    }

    /**
     * tB[h [resourceItem] ̒lݒ肵܂B
     *
     * tB[h̐: [[NɗptB[hB]B
     *
     * @param argResourceItem tB[h[resourceItem]ɐݒ肷lB
     */
    public void setResourceItem(final BlancoResourceBundleBundleItemStructure argResourceItem) {
        fResourceItem = argResourceItem;
    }

    /**
     * tB[h [resourceItem] ̒l擾܂B
     *
     * tB[h̐: [[NɗptB[hB]B
     *
     * @return tB[h[resourceItem]擾lB
     */
    public BlancoResourceBundleBundleItemStructure getResourceItem() {
        return fResourceItem;
    }

    /**
     * tB[h [currentLocale] ̒lݒ肵܂B
     *
     * tB[h̐: [ݏĂ郍P[L܂B]B
     *
     * @param argCurrentLocale tB[h[currentLocale]ɐݒ肷lB
     */
    public void setCurrentLocale(final String argCurrentLocale) {
        fCurrentLocale = argCurrentLocale;
    }

    /**
     * tB[h [currentLocale] ̒l擾܂B
     *
     * tB[h̐: [ݏĂ郍P[L܂B]B
     *
     * @return tB[h[currentLocale]擾lB
     */
    public String getCurrentLocale() {
        return fCurrentLocale;
    }

    /**
     * tB[h [currentResourceString] ̒lݒ肵܂B
     *
     * tB[h̐: [ݏĂ郊\[XL܂B]B
     *
     * @param argCurrentResourceString tB[h[currentResourceString]ɐݒ肷lB
     */
    public void setCurrentResourceString(final String argCurrentResourceString) {
        fCurrentResourceString = argCurrentResourceString;
    }

    /**
     * tB[h [currentResourceString] ̒l擾܂B
     *
     * tB[h̐: [ݏĂ郊\[XL܂B]B
     *
     * @return tB[h[currentResourceString]擾lB
     */
    public String getCurrentResourceString() {
        return fCurrentResourceString;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure[");
        buf.append("name=" + fName);
        buf.append(",listLocale=" + fListLocale);
        buf.append(",package=" + fPackage);
        buf.append(",suffix=" + fSuffix);
        buf.append(",description=" + fDescription);
        buf.append(",access=" + fAccess);
        buf.append(",itemList=" + fItemList);
        buf.append(",resourceItem=" + fResourceItem);
        buf.append(",currentLocale=" + fCurrentLocale);
        buf.append(",currentResourceString=" + fCurrentResourceString);
        buf.append("]");
        return buf.toString();
    }
}
