/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.python;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgSourceFileUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgSourceFile\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgSourceFilePythonSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.PYTHON;

    /**
     * ͂ƂȂ\[XR[h\B
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * ԓIɗp\[XR[h킷ListBjava.lang.StringXgɊi[܂B(BlancoCgLineł͂܂B
     * )
     * 
     * ł͐`O\[XR[hԓIɂ킦܂B
     */
    private List<java.lang.String> fSourceLines = null;

    /**
     * SourceFile琮`O\[XR[hXg𐶐܂B
     * 
     * @param argSourceFile
     *            \[XR[h킷o[IuWFNgB
     * @return \[XR[hɓWJ̃XgB
     */
    public List<java.lang.String> transformSourceFile(
            final BlancoCgSourceFile argSourceFile) {
        // mɃ\[Xs̃Xg܂B
        fSourceLines = new ArrayList<java.lang.String>();

        fCgSourceFile = argSourceFile;

        // \[Xt@C̃t@Cwb_[o͏܂B
        expandSourceFileHeader();

        // pbP[W̐B
        // if (BlancoStringUtil.null2Blank(fCgSourceFile.getPackage()).length()
        // > 0) {
        // fSourceLines.add("package " + fCgSourceFile.getPackage()
        // + BlancoCgLineUtil.getTerminator(TARGET_LANG));
        // fSourceLines.add("");
        // }
        //
        // if (fCgSourceFile.getImportList() == null) {
        // throw new IllegalArgumentException("import̃Xgnull^܂B");
        // }
        //
        // // ̌㔼ŃC|[gҐȂ܂A̍ۂɎQƂAJ[ǉĂ܂B
        // BlancoCgImportJavaSourceExpander.insertAnchorString(fSourceLines);

        // // C^tF[X̓WJ{܂B
        // if (fCgSourceFile.getInterfaceList() == null) {
        // throw new IllegalArgumentException("C^tF[X̃Xgnull^܂B");
        // }
        // for (int index = 0; index < fCgSourceFile.getInterfaceList().size();
        // index++) {
        // final Object objClass = fCgSourceFile.getInterfaceList().get(index);
        // if (objClass instanceof BlancoCgInterface == false) {
        // throw new IllegalArgumentException("C^tF[X̃XgɃC^tF[XȊǑ^["
        // + objClass.getClass().getName() + "]̒l^܂B");
        // }
        // final BlancoCgInterface cgInterface = (BlancoCgInterface) objClass;
        // new BlancoCgInterfaceJavaSourceExpander().transformInterface(
        // cgInterface, fCgSourceFile, fSourceLines);
        // }

        // NX̓WJ{܂B
        if (fCgSourceFile.getClassList() == null) {
            throw new IllegalArgumentException("NX̃Xgnull^܂B");
        }
        for (int index = 0; index < fCgSourceFile.getClassList().size(); index++) {
            final BlancoCgClass cgClass = fCgSourceFile.getClassList().get(
                    index);

            new BlancoCgClassPythonSourceExpander().transformClass(cgClass,
                    fCgSourceFile, fSourceLines);
        }

        // import̓WJ܂B
        // ̏ANXWJɎ{Ă̂ɂ͈Ӗ܂B
        // NXWJȂǂoāA߂ăC|[g̈ꗗm肷邩łB
        // new BlancoCgImportJavaSourceExpander().transformImport(fCgSourceFile,
        // fSourceLines);

        return fSourceLines;
    }

    /**
     * \[Xt@C̃t@Cwb_[o͏܂B
     */
    private void expandSourceFileHeader() {
        // TODO cp932ߑłŃ\[X𐶐
        fSourceLines.add("# -*- coding: cp932 -*-");

        if (BlancoStringUtil.null2Blank(fCgSourceFile.getDescription())
                .length() > 0) {
            fSourceLines.add("\"\"\"" + fCgSourceFile.getDescription());
        } else {
            // w肪ꍇɂ̓ftHg̃Rg𗘗p܂B
            for (String line : BlancoCgSourceFileUtil.getDefaultFileComment()) {
                fSourceLines.add("\"\"\"" + line);
            }
        }

        // hLg̒ԕ𐶐܂B
        new BlancoCgLangDocPythonSourceExpander().transformLangDocBody(
                fCgSourceFile.getLangDoc(), fSourceLines);
        if (true)
            return;

        fSourceLines.add("\"\"\"");
    }
}
