/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.common.Assert;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class BooleanRecord
extends CellValue
implements BooleanCell {
    private boolean error = false;
    private boolean value = false;

    public BooleanRecord(Record t, FormattingRecords fr, SheetImpl si) {
        super(t, fr, si);
        byte[] data = this.getRecord().getData();
        boolean bl = this.error = data[7] == 1;
        if (!this.error) {
            this.value = data[6] == 1;
        }
    }

    public boolean isError() {
        return this.error;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public String getContents() {
        Assert.verify(!this.isError());
        return new Boolean(this.value).toString();
    }

    @Override
    public CellType getType() {
        return CellType.BOOLEAN;
    }

    @Override
    public Record getRecord() {
        return super.getRecord();
    }
}

